#pragma once

#include <util/generic/string.h>
#include <util/generic/noncopyable.h>
#include <util/generic/maybe.h>
#include <library/cpp/json/json_value.h>

#include <yt/yt/core/ytree/public.h>
#include <yt/yt/client/api/client.h>


// https://wiki.yandex-team.ru/yt/userdoc/RPC-Proxy/


namespace NIrt {


struct TRpcProxyResponse {
    bool Success = true;
    TMaybe<NJson::TJsonValue> Data;
    TMaybe<TString> Message;
};


class TRpcProxyRequester : private TNonCopyable {
public:
    TRpcProxyRequester(NYT::NYTree::INodePtr ytParams);
    TRpcProxyResponse DoSelect(const TString query);
    void Shutdown();

private:
    NYT::NApi::IClientPtr Client;
};


class TRpcProxyAcl {
public:
    TRpcProxyAcl(NYT::NYTree::INodePtr aclParams);
    bool Allowed(TString path) const;

private:
    TVector<TString> AllowedPrefices;
};


} // namespace NIrt
