#pragma once

#ifndef STATIC_MAP_STATIC_MAP_ENGINE_H_
#define STATIC_MAP_STATIC_MAP_ENGINE_H_

#undef seed

#include <util/generic/vector.h>
#include <util/string/builder.h>

#include <cstdio>
#include <algorithm>
#include <set>
#include <string>
#include <map>
#include <unordered_set>
#include <functional>

#include "../../cpp-source/common/norm/Tokens.h"

class StaticMapEngine {
public:
    StaticMapEngine(const char* data_file_directory);

    void LoadData(const char* data_file_directory);

    void GetValue(const unsigned char* key,
                  size_t key_size,
                  const unsigned char*& value,
                  size_t& value_size);

    const char* Value(char* key) {
        size_t value_size;
        const unsigned char* value;
        size_t key_size = strlen(key) + 1;
        key[key_size - 1] = '\t';
        GetValue((const unsigned char*)key, key_size, value, value_size);
        key[key_size - 1] = 0;
        if (buffer_size_ < value_size + 1) {
            while (buffer_size_ < value_size + 1) {
                buffer_size_ <<= 1;
            }
            delete[] buffer_;
            buffer_ = new char[buffer_size_];
        }
        memcpy(buffer_, value, value_size);
        buffer_[value_size] = 0;
        return buffer_;
    }

    const char* LangValue(char* key, const char* lang);

    void GetSubstrValue(const unsigned char* p, size_t key_size, const unsigned char* prx, size_t prx_size, const unsigned char*& value, size_t& value_size);

    const char* GetSubstr(char* key, char* prx) {
        size_t value_size;
        const unsigned char* value;
        size_t key_size = strlen(key);
        size_t prx_size = strlen(prx);
        GetSubstrValue((const unsigned char*)key, key_size, (const unsigned char*)prx, prx_size, value, value_size);
        if (buffer_size_ < value_size + 1) {
            while (buffer_size_ < value_size + 1) {
                buffer_size_ <<= 1;
            }
            delete[] buffer_;
            buffer_ = new char[buffer_size_];
        }
        memcpy(buffer_, value, value_size);
        buffer_[value_size] = 0;
        return buffer_;
    }

    std::map<std::string, std::unordered_set<std::string>> stops;
    int stop_chk[1000];
    void AddStop(const char* stop, const char* lang) {
        if (stop[0]) {
            stop_chk[(unsigned char)stop[0]] = 1;
        }
        if (stop[1]) {
            stop_chk[(unsigned char)stop[1] + 256] = 1;
        }
        if (stop[2]) {
            stop_chk[(unsigned char)stop[2] + 512] = 1;
        }
        stops[lang].insert(stop);
    }
    void LoadStopWords(const char* stop_words_dict, const char* lang);
    bool IsStop(const char* stop, const char* lang) {
        return stops[lang].find(stop) != stops[lang].end();
    }

    const char* GetNorm(const char* text, const char* lang, bool uniq = false, bool sort = true);
    const char* GetNormList(char* text, const char* lang);
    void GetSubphrases(char* text, int cnt, std::vector<char*>& phrases);

    virtual ~StaticMapEngine();

    Tokens tokenizer;

private:
    void Clear();

    size_t default_search_range;
    unsigned char** deepcache;

    int data_file_descriptor;
    size_t storage_size_;
    unsigned char* storage_;

    size_t buffer_size_;
    char* buffer_;

    size_t buffer_size_nrm;
    char* buffer_nrm;

    //Буффер для перебора подстрок
    size_t buffer_size_subphrases;
    char* buffer_subphrases;
};

#endif // STATIC_MAP_STATIC_MAP_ENGINE_H_
