#pragma once

#include "../../common/HuffmanTree.h"

#include <iostream>
#include <string>
#include <vector>

class StaticZmap {
 public:
  StaticZmap(const char* data_file,
             char words_delim = '/',
             bool keep_key_unencoded = false,
             char elements_delim = '\n',
             char fields_delim = '\t',
             char escape = '\\',
             char escaped_elements_delim = '0',
             char escaped_fields_delim = '1');

  ~StaticZmap();
  std::string At(const char* key, char words_delim) const;
  std::string At(const char* key) const;

  struct Header {
    char signature[15];  // StaticZmapData
    char version;

    Header();
    Header(const char* _signature, char _version);
  };

 private:
  static size_t FileSizeInBytes(const char* file);

  int StrCmp(const std::vector<char>& key, const char* element) const;

  void SetSearchParams();

  std::vector<char> ApplyEscape(const std::vector<char>& encoded_data) const;

  std::vector<char> ApplyUnescape(const std::vector<char>& encoded_data) const;

  HuffmanTree huffman_tree_;
  int data_file_descriptor;
  const char* storage_;
  size_t storage_size_;
  size_t dict_offset_;
  char words_delim_;
  bool keep_key_unencoded_;
  char elements_delim_;
  char fields_delim_;
  char escape_;
  char escaped_elements_delim_;
  char escaped_fields_delim_;
  const char* left_bound_;
  size_t search_range_;
};

std::istream& operator>>(std::istream& stream, StaticZmap::Header& header);
