#pragma once

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <util/system/rwlock.h>

class Node;

using TOriginalMap = TMap<TString, TMap<TString, TString> >;

class SubphraserIndex {
public:

    SubphraserIndex();
    ~SubphraserIndex();

    // добавление фразы в индекс
    void AddPhrase(const TStringBuf& phrase, const TStringBuf& data);

    // поиск подфраз во фразе
    void GetSubphrases(const TStringBuf& phrase, TVector<TString>& result) const;

    // поиск фразы в индексе (точное совпадение)
    const TStringBuf GetPhraseData(const TStringBuf& phrase) const;

    void SetPhraseOriginal(const TStringBuf& category, const TStringBuf& phrase, const TStringBuf& text);
    const TStringBuf GetPhraseOriginal(const TStringBuf& category, const TStringBuf& phrase) const;

    // работа со свойствами
    bool SetProperty(const TStringBuf& prop_name, const TStringBuf& prop_value);

private:

    // корень дерева
    THolder<Node> root;

    TOriginalMap original_map;

    // свойства
    int     prop_dont_sort;         // не сортировать слова во фразах
    int     prop_max_words_dist;    // максимальное расстояние между словами подфраз

private:

    // превращение фразы в массив слов
    const TVector<TStringBuf> GetPhraseWords(const TStringBuf& phrase) const;

    // прослеживание фразы в индексе при добавлении
    void TraceAddPhrase(const TVector<TStringBuf>& words, unsigned pos, Node& node, const TStringBuf& data);

    // прослеживание фразы в индексе при получении списка подфраз
    void TraceGetSubphrases(const TVector<TStringBuf>& words, unsigned pos, const Node& node, TVector<TStringBuf>& trace, TVector<TString>& result) const;

    TRWMutex Lock;
};
