#include "SubphraserServer.h"

#include <rt-research/broadmatching/scripts/cpp-source/common/Session.h>

#include <util/generic/string.h>
#include <util/stream/file.h>

#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/logger/global/global.h>

int main(int argc, char** argv) {
    ui32 port;
    TString exec_file;
    NLastGetopt::TOpts opts;
    opts.AddLongOption("port").Optional().DefaultValue("11222").StoreResult(&port);
    opts.AddLongOption("exec-file").Optional().StoreResult(&exec_file);
    NLastGetopt::TOptsParseResult(&opts, argc, argv);

    SubphraserServer server(port);

    if (exec_file) {
        try {
            INFO_LOG << "Executing commands from external file '" << exec_file << "'...";
            TFileInput stream(exec_file);


            int num_cmds = 0;
            TString buffer;
            Session fake_session(0, &server);
            while (stream.ReadLine(buffer)) {
                if (buffer) {
                    server.ExecCommand(buffer, &fake_session);
                    num_cmds++;
                }
            }
            INFO_LOG << num_cmds << " commands have been executed";
        } catch (TIoException& exception) {
            ERROR_LOG << "ERROR: can't open file '" << exec_file << "'";
        }
    }

    server.Run();

    return 0;
}
