#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use IO::Socket;
use IO::Handle;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;

my $proj = Project->new({});

while(defined(my $query = STDIN->getline)) {
    chomp $query;
    print "-> $query\n";
    
    my $resp = $proj->subphrases_client->exec_command($query);
    print "<- $resp\n";

    last if !$proj->subphrases_client->is_connected;
}
