#pragma once

#include "common.h"

#include <string>
#include <string>

#include <library/cpp/containers/comptrie/comptrie_trie.h>

#include <util/stream/buffer.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>


class TAmpersandParser {
public:
    TAmpersandParser();

    using TResult = TMaybe<TErrorMessage>;

    [[nodiscard]] TResult ProcessChar(char symbol) noexcept;
    [[nodiscard]] TResult Finish() noexcept;
    TString GetReadText() const noexcept;

private:
    enum EState {
        Start,
        Ampersand,
        Name,
        Hash,
        Hex,
        Number,
    };
    TCompactTrie<char> CurrentTrie;
    EState State_;
    TString Read_;
    ui64 Number_;
};
