#include "common.h"
#include "cycle_detector.h"

#include <util/string/builder.h>

TCycleDetector::TCycleDetector() {}

void TCycleDetector::AddCategory(const TString& id, const TMaybe<TString>& parentId) noexcept {
    if (!graph_.contains(id)) {
        graph_.insert({id, {TCycleDetector::COLOR_WHITE, TVector<TString>()}});
    }
    if (parentId.Defined()) {
        if (!graph_.contains(*parentId)) {
            graph_.insert({*parentId, {TCycleDetector::COLOR_WHITE, TVector<TString>()}});
        }
        graph_.at(*parentId).second.push_back(id);
    }
}

TMaybe<TErrorMessage> TCycleDetector::Finish() noexcept {
    if (!graph_.empty()) {
        for (auto& i : graph_) {
            if (i.second.first == TCycleDetector::COLOR_WHITE) {
                i.second.first = TCycleDetector::COLOR_GRAY;
                if (auto error = Travel(graph_, i.first, i.second.second)) {
                    graph_.clear();
                    return error;
                }
                i.second.first = TCycleDetector::COLOR_BLACK;
            }
        }
    }
    graph_.clear();
    return Nothing();
}

TMaybe<TErrorMessage> TCycleDetector::Travel(TCycleDetector::Graph& graph, const TString& parent, const TVector<TString>& edges) {
    for (const auto& i : edges) {
        if (graph[i].first == TCycleDetector::COLOR_GRAY) {
            if (parent == i) {
                return TErrorMessage{
                    .en = TStringBuilder{} << "Problem in category `" << parent << "`: it must not contain itself as a parent.",
                    .ru = TStringBuilder{} << "Проблема в категории `" << parent << "`: категория не должна являться собственным родителем."
                };
            }
            return TErrorMessage{
                .en = TStringBuilder{} << "Detected cycle in category tree on edge '" << parent << "' -> '" << i << "'.",
                .ru = TStringBuilder{} << "Обнаружен цикл в дереве категорий на ребре '" << parent << "' -> '" << i << "'."
            };
        } else if (graph[i].first == TCycleDetector::COLOR_WHITE) {
            graph[i].first = TCycleDetector::COLOR_GRAY;
            if (auto error = Travel(graph, i, graph[i].second)) {
                return error;
            }
            graph[i].first = TCycleDetector::COLOR_BLACK;
        }
    }
    return Nothing();
}

