#pragma once

#include "common.h"

#include <string>
#include <util/generic/maybe.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>

// https://stackoverflow.com/questions/261573/best-algorithm-for-detecting-cycles-in-a-directed-graph
class TCycleDetector {
public:
    TCycleDetector();
    void AddCategory(const TString& id, const TMaybe<TString>& parentId) noexcept;

    // Returns error message if there is a cycle
    [[nodiscard]] TMaybe<TErrorMessage> Finish() noexcept;

private:
    enum Color {
        COLOR_WHITE,
        COLOR_GRAY,
        COLOR_BLACK
    };
    using Graph = THashMap<TString, std::pair<Color, TVector<TString>>>;
    static TMaybe<TErrorMessage> Travel(Graph& graph, const TString& parent, const TVector<TString>& edges);
    Graph graph_;
};
