#!/usr/bin/perl

use strict;
use warnings;

use open ':utf8';

use JSON qw(from_json to_json);
use Getopt::Long;
use File::Path qw(make_path);
use List::Util qw(shuffle);

use FindBin;
use lib "$FindBin::Bin/../../lib";

use BM::BannersMaker::Tasks::TaskUtils qw(get_task_file);
use Utils::Sys qw(
    save_json load_json
    dir_files
);
use Project;

my %opt;
GetOptions(\%opt, 'help|h');

if ($opt{help} or !@ARGV) {
    printf "Usage: $0 task-type [task_list]\n";
    exit;
}


my $proj = Project->new({
    load_dicts => 1,
    load_minicategs_light => 1,
    use_comptrie_subphraser => 1,
});


my $type = shift @ARGV;

my $tasks_list = shift @ARGV;
my @tasks;
if ($tasks_list) {
    @tasks = split /,/, $tasks_list;
} else {
    my $table = ($type eq 'perf') ? 'PerfTasks' : 'DynTasks';
    my $rows = $proj->bannerland_dbh->List_SQL("
        select TaskID from $table
            order by end desc
            limit 100
    ");
    @tasks = map { $_->{TaskID} } @$rows;
}


for my $task_id (@tasks) {
    $proj->log("found task $task_id");

    my $task_file = $proj->get_tempfile('taskjson');
    get_task_file($proj, $type, $task_id, $task_file)
        or do { warn "Can't get file for task $type: $task_id!"; next };

    my $task_inf = load_json($task_file);
    my $task = ($type eq 'dyn') ? $proj->dyntask($task_inf) : $proj->perftask($task_inf);

    my $feed;
    if ($type eq 'dyn') {
        my $feed_info = $task->get_feeddata;
        $feed = $proj->feed({
            extfile => $feed_info->{main_feed_file},
            datatype => 'offers_tskv',
        });
    } else {
        my $filetskv_mpd = $task->get_feed_nofilters->offers_tskv_mpd_file;
        $feed = $task->get_feed_by_extfile($filetskv_mpd);
    }
    $task->do_export_offers($feed);
}
