import datetime
import six

import ads.libs.yql
import library.python.resource
import yt.wrapper as yt

import irt.bannerland.options
import irt.bannerland.options.cypress
import irt.logging


logger = irt.logging.getLogger(irt.logging.BANNERLAND_PROJECT, __name__)


def main():
    logger.info("====== START script ======")

    input_bs_logs = "home/bs/logs"
    dyn_bs_log_dir = "//home/bannerland/logs/dyn_bs_log"

    yt_client = yt.YtClient(proxy="hahn", config=yt.default_config.get_config_from_env())

    yt_lock_client = yt.YtClient(proxy="locke", config=yt.default_config.get_config_from_env())

    with yt_lock_client.Transaction():
        try:
            yt_lock_client.lock("//home/bannerland/locks/dyn_bs_log")
        except Exception:
            logger.warning("The script is already running (Locke file is locked)...")
            return

        logger.info("Start dyn_bs_log updating")

        yql_get_daily_dyn_perf_stat = six.ensure_str(library.python.resource.find("get_daily_dyn_perf_stat.yql"))

        days_ago_start = 20
        cur_date = datetime.datetime.today()
        for days_ago in range(days_ago_start, 0, -1):
            with yt_client.Transaction() as hahn_tx:
                date_ado = cur_date - datetime.timedelta(days=days_ago)
                year_str = "{:04d}".format(date_ado.year)
                month_str = "{:02d}".format(date_ado.month)
                day_str = "{:02d}".format(date_ado.day)
                date_str = "{}{}{}".format(year_str, month_str, day_str)

                fs_date_from = date_ado.date() - datetime.timedelta(days=1)
                fs_date_to = date_ado.date() + datetime.timedelta(days=1)
                fs_date_from_str = fs_date_from.strftime(irt.bannerland.options.get_option("bannerland_pocket_name_format"))
                fs_date_to_str = fs_date_to.strftime(irt.bannerland.options.get_option("bannerland_pocket_name_format"))
                if yt_client.exists("{}/{}".format(dyn_bs_log_dir, date_str)):
                    logger.info("dyn_bs_log for '%s' date is already exists.", date_str)
                    continue

                def check_availability_of_all_bs_logs():
                    for hour in range(24):
                        if not yt_client.exists("//{}/JoinedEFH/1h/{}-{}-{}T{:02d}:00:00".format(
                            input_bs_logs,
                            year_str,
                            month_str,
                            day_str,
                            hour
                        )):
                            logger.warning("There is no part of dyn_bs_log for '%s'.", date_str)
                            return False
                    return True

                if not check_availability_of_all_bs_logs():
                    logger.warning("No input table for date '%s'", date_str)
                    continue

                logger.info("Creating dyn_bs_log for '%s' date...", date_str)
                date_yql_req = yql_get_daily_dyn_perf_stat.format(
                    bl_path=dyn_bs_log_dir,
                    bs_path=input_bs_logs,
                    year=year_str,
                    month=month_str,
                    day=day_str,
                    fs_date_from=fs_date_from_str,
                    fs_date_to=fs_date_to_str,
                    perf_fs=irt.bannerland.options.cypress.PerfYTConfig().get_path("full_state_archive"),
                    dyn_fs=irt.bannerland.options.cypress.DynYTConfig().get_path("full_state_archive"),
                )
                ads.libs.yql.run_yql_query(db='hahn', query=date_yql_req, transaction_id=hahn_tx.transaction_id)

                logger.info("Create dyn_bs_log for '%s' date...", date_str)

        logger.info("====== END script ======")


if __name__ == "__main__":
    main()
