#!/usr/bin/perl

use strict;
use warnings;
use autodie;
use utf8;

use open ":utf8";
no warnings "utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";

use Utils::Sys qw(get_file_lock);

use CatalogiaMediaProject;


get_file_lock() and main();
exit(0);


sub main {
    my $proj = shift // _get_proj();

    $proj->log("Start cleanup...");
    
    clean_monitor_entries($proj);

    $proj->log("Cleanup done.");
    
    return 1;
}

sub _get_proj {
    return CatalogiaMediaProject->new({
        indcmd => 1,
        no_auth => 1,
        no_form => 1,
        nrmsrv => 0,
    });
}

sub clean_monitor_entries {
    my $proj = shift;
    my $tables = shift // [
        'DynTasksMonitorEntries',
        'DynGrpTasksMonitorEntries',
        'PerfTasksMonitorEntries',
    ];

    for my $table (@$tables) {
        $proj->log("Clean table '$table'...");
        my $rows_deleted = $proj->bannerland_dbh()->do("
            delete from $table
            where Time < now() - interval 3 month
        ");
        $proj->log("Clean table '$table' done, $rows_deleted rows removed");
    }

    return 1;
}

