#! /usr/bin/perl -w 

# для каждого вхождения слова во все подфразы добавляет его полисемию

use strict;
use utf8;
use 5.010;
use Data::Dumper;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN, ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

$Data::Dumper::Useqq = 1;
{ 
    no warnings 'redefine';
    sub Data::Dumper::qquote {
        my $s = shift;
        return "'$s'";
    }
}
use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../cpan";
use lib "$FindBin::Bin/../wlib";
select STDERR; $| = 1;
select STDOUT; $| = 1;
use Project;
my $proj = Project->new({ indcmd => 1, 
    load_dicts =>0,
    load_minicategs_light => 0,
    no_auth => 1,
    no_form => 1,
    nrmsrv => 0, 
    timelogpackages => [ qw[ 
        BM::PhraseNrmSrv BM::Phrase BM::PhraseList BM::PhraseListNrmSrv 
        BM::PhraseParser
        BM::Pages::Page BM::Banners::LBannerAnalysis
        BM::Pages::PageHierarchy
        BM::PhraseCategs
    ] ] 
});

my %h = map { chomp; my @a=split/ => /; $a[0] => $a[1] } <DATA>;
my $re = join("|", keys %h );

while (<>){
    chomp;
    my $text = $_;
    my @a = split/\s*\:\s*/, $text;
    my $phrtext = $a[0];
    my $isacc = $a[1] || '';
    my $mapto = $a[2] || '';
    my $categ = $a[3] || ''; 
    print "$text\n" if $mapto;
    next if $mapto;
    $mapto = $phrtext;
    my $found = '';
    if ( $phrtext =~ /(?:^|\s+)($re)(?:\s+|$)/ ){
        my $found = $1;
        $mapto =~ s/(\s+|^)($found)(\s+|$)/$1$h{$found}$3/;
    } else {
        $mapto = '';
    }
    my $addition = join(" : ", ($isacc,$mapto,$categ));
    my $line = join(" : ", ($phrtext,$addition));
    print $addition=~/\w/ ? $line : $phrtext, "\n";
}

__DATA__
очки => очки
брюки => брюки
кроссовок => кроссовки
валенок => валенки
кед => кеды
сланец => сланцы
колготки => колготки
лосины => лосины
бриджи => бриджи
бермуды => бермуды
варежка => варежки
шаровары => шаровары
носок => носки
чулок => чулки
шлепанец => шлепанцы
сандалия => сандалии
слипон => слипоны
перчатка => перчатки
мокасин => мокасины
мокасин => мокасины
гетра => гетры
ботинок => ботинки
джинс => джинсы
джинсы => джинсы
сапог => сапоги
полусапог => полусапоги
трусы => трусы
трус => трусы
шорты => шорты
туфля => туфли
ботильон => ботильоны
лофер => лоферы
босоножка => босоножки
конек => коньки
бутса => бутсы
час => часы
велоштан => велоштаны
педаль => педали
часы => часы
ласт => ласты
наушник => наушники
наушники => наушники
нарды => нарды
страз => стразы
плавки => плавки
полуботинок => полуботинки
щипцы => щипцы
духи => духи
тапочка => тапочки
