#!/usr/bin/perl
use strict;
use warnings;

use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Sys qw(
    load_json save_json
    handle_errors
);
use Utils::Common;
use Utils::CompileTime;
use Getopt::Long;


handle_errors(DIE => {stack_trace=>1});

my %opt;
GetOptions(\%opt,
    'help|h',
    'task_type|task-type=s',
);
if ($opt{help}) {
    printf "Usage: $0 --task-type TYPE WHAT\n";
    printf "TYPE: dyn|perf (choose one)\n";
    printf "WHAT: mapping|export_offers (csv list)\n";
    exit(0);
}

my @todo = split /,/, $ARGV[0];
my %supported = map { $_ => 1 } qw(mapping export_offers);
if (grep { !$supported{$_} } @todo) {
    die "Not supported types found!";
}

my $file;
if ($opt{task_type} eq 'dyn') {
    $file = $Utils::Common::options->{dyn_svn_revision_file};
} elsif ($opt{task_type} eq 'perf') {
    $file = $Utils::Common::options->{perf_svn_revision_file};
} else {
    die "Task type $opt{task_type} not supported!";
}
print "Will update file: $file\n";
print "Change fields: @todo\n";

my $info = load_json($file) // {};

my $svn_revision = Utils::CompileTime::get_revision();
for my $type (@todo) {
    $info->{$type} = $svn_revision;
}

save_json($info, $file)
    or die "Can't save_json!";
