import argparse
import datetime

import yt.wrapper as yt


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt_dir', required=True, help='dir with tskvs')
    parser.add_argument('--yesterday', action='store_true', help='save with yesterday date')
    parser.add_argument('--output', help='path to output table')
    parser.add_argument('--output_dir', help='path to output table')
    parser.add_argument('--delete_older_than', help='delete tables older than X days', type=int)
    args = parser.parse_args()

    # get YT client
    yt_client = yt.YtClient(proxy='hahn', config=yt.default_config.get_config_from_env())

    tablename_format = '%Y%m%d'
    today_date = datetime.datetime.today().date()

    if args.output_dir and args.delete_older_than:
        max_days = int(args.delete_older_than)
        for table in yt_client.list(args.output_dir):
            try:
                days = (today_date - datetime.datetime.strptime(table, tablename_format).date()).days
                if days > max_days:
                    yt_client.remove(yt.ypath_join(args.output_dir, table))
            except ValueError:
                pass

    date = datetime.datetime.today()
    if args.yesterday:
        date -= datetime.timedelta(days=1)
    filename = date.strftime(tablename_format)

    # process data
    tables = list(filter(lambda s: s.find('tskv') != -1, yt_client.search(args.yt_dir, node_type=['table'])))
    table_final = args.output or yt.ypath_join(args.output_dir or args.yt_dir, filename)

    yt_client.concatenate(tables, yt.TablePath(table_final, attributes={'compression_codec': 'brotli_5'}))


if __name__ == '__main__':
    main()
