#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/lib";

use List::Util qw(max);
use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    fork_tasks
    rotate_files
    handle_errors
);
use BM::Phrase;
use Project;

handle_errors();

get_file_lock()
    or die "enumerate_categs.pl is already runned";

my $proj = Project->new({
    load_dicts => 1,
    load_minicategs => 1,
});

my $filename = $Utils::Common::options->{categs_direct_ids};
my %ids;
my %groupids;
my $max_id = 200_000_000;
my %cts;
my %groups;

if(open F, $filename) {
    for ( map{chomp; [split "\t"]} <F> ) {
        die "Duplicate key error" if exists $ids{$_->[1]};
        $ids{$_->[1]} = $_->[0];
    }
    close F;
    $max_id = max(($max_id, map{$ids{$_}} keys %ids)) if %ids;
} else {
    die "Could not open $filename ($!)";
}

#группы категорий маркируются при помощи этого же счетчика
foreach my $groupname ( qw(mediagroups videodirectgroups) ) {
    if ( $proj->$groupname->is_mapped_to_direct ) {
        my $filename = $proj->$groupname->direct_mapping_file;
        if(open F, $filename) {
            for ( map{chomp; [split "\t"]} <F> ) {
                die "Duplicate key error" if exists $groupids{$groupname}{$_->[1]};
                $groupids{$groupname}{$_->[1]} = $_->[0];
            }
            close F;
            my $group_max_id = 0;
            $group_max_id = max(map{$groupids{$groupname}{$_}} keys %{$groupids{$groupname}}) if $groupids{$groupname};
            $max_id = max(($max_id, $group_max_id));
        } else {
            die "Could not open $filename ($!)";
        }
    }
}

$cts{$ids{$_}} = $_ for keys %ids;
for my $ct ($proj->categs_tree->get_minicategs_list()) {
    $ids{$ct} = ++$max_id unless $ids{$ct};
    $cts{$ids{$ct}} = $ct; 
}

foreach my $groupname ( qw(mediagroups videodirectgroups) ) {
    if ( $proj->$groupname->is_mapped_to_direct ) {
        for my $grp ( keys %{$proj->$groupname->group2categ} ) {
            $groupids{$groupname}{$grp} = ++$max_id unless $groupids{$groupname}{$grp};
            $groups{$groupname}{$groupids{$groupname}{$grp}} = $grp;
        }
    }
}

my $filename_tmp = $proj->get_tempfile('categs_direct_ids', UNLINK => 1,);
$filename = $Utils::Common::options->{categs_direct_ids};
open F, "> $filename_tmp" or die "Could not open $filename_tmp ($!)";
print F "$_\t$cts{$_}\n" for sort{$a <=> $b} keys %cts;
close F or die "Could not close $filename_tmp ($!)";
$proj->do_sys_cmd("mv $filename_tmp $filename");


foreach my $groupname ( qw(mediagroups videodirectgroups) ) {
    if ( $proj->$groupname->is_mapped_to_direct ) {
        my $filename = $proj->$groupname->direct_mapping_file;
        my $filename_tmp = $proj->get_tempfile($groupname.'_direct_ids', UNLINK => 1,);
        open F, "> $filename_tmp" or die "Could not open $filename_tmp ($!)";
        print F "$_\t$groups{$groupname}{$_}\n" for sort{$a <=> $b} keys $groups{$groupname};
        close F or die "Could not close $filename_tmp ($!)";
        $proj->do_sys_cmd("mv $filename_tmp $filename");
    }
}



$proj->log("Done");

exit(0);
