import argparse
import irt.iron.options as iron_opts
from os import path, mkdir, makedirs, walk
from shutil import move
from api.copier import Copier
from sandbox.common import rest
from sandbox.common.auth import OAuth


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--resource_name', required=True)
    parser.add_argument('--arcadia_root', required=True)
    parser.add_argument('--temp_dir', required=True)
    args = parser.parse_args()
    resource_type = args.resource_name
    arcadia_root = args.arcadia_root.rstrip('/')
    temp_dir = args.temp_dir.rstrip('/')
    fetch_resource(resource_type, arcadia_root, temp_dir)


def fetch_resource(resource_type, arcadia_root, temp_dir):
    # считываем информацию о наиболее свежем ресурсе из sandbox, если в sandbox вообще нет такого ресурса, то будет keyerror, ну и хорошо
    with open(iron_opts.get("sandbox_token_path")) as f:
        token = f.readline().strip()
    sandbox = rest.Client(auth=OAuth(token))
    response = sandbox.resource.read(state="READY", order=["-id"], type="IRT_DATA", owner="IRT", limit=1, attr_name="sub_type", attr_value=resource_type)
    skynet_id = response["items"][0]["skynet_id"]
    filename = response["items"][0]["file_name"]
    resource_id = response["items"][0]["id"]
    # ID ресурса при последнем скачивании лежит в <arcadia_root>/.sandbox_resources_info/<resource_name>.id
    # проверяем его и выходим, если ресурс данной версии уже скачали
    dirname = arcadia_root + "/.sandbox_resources_info"
    resource_info_filename = dirname + '/' + resource_type
    if not path.exists(dirname):
        mkdir(dirname, 0o775)
    elif path.exists(resource_info_filename):
        with open(resource_info_filename) as f:
            last_id = int(f.readline().strip())
        if last_id == resource_id:
            return
    # Скачиваем skynet'ом, во временный каталог сваливается дерево с каталогами и файлами
    Copier().handle(skynet_id).get(dest=temp_dir).wait()
    # Проходим по файлам и переносим их
    temp_dir += '/' + resource_type
    resource_files = []
    for dirname, dirs, files in walk(temp_dir):
        for filename in files:
            resource_files += [[dirname, filename]]
    for dirname, filename in resource_files:
        target_dir = arcadia_root + dirname[len(temp_dir):]
        if not path.exists(target_dir):
            makedirs(target_dir, mode=0o775)
        move("{}/{}".format(dirname, filename), "{}/{}".format(target_dir, filename))
    # Сохраняем ID скачанного ресурса
    with open(resource_info_filename, "w") as f:
        f.write(str(resource_id))


if __name__ == "__main__":
    main()
