#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';
use Data::Dumper;

use FindBin;
use IO::Handle;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";
use lib "$FindBin::Bin/cpan";

use Utils::Common;
use Utils::Sys qw(
    _get_lockname
    get_file_lock
    get_lock_pid
    release_file_lock
    handle_errors
    print_log
    log_msg_fmt
    do_safely
    md5int
);
use CatalogiaMediaProject;
use BM::BannersMaker::Tasks::TaskQueue;

handle_errors();

my $helpformat = 'usage: kill_cronlight_tasks_queue.pl type';

my $type = $ARGV[0];
die($helpformat) unless $type;

for (my $fork_index = 1; ; $fork_index++) {
    my $lock_name = "process_cronlight_tasks_${type}_$fork_index";
    my $file_name = _get_lockname($lock_name);

    last unless -e $file_name;

    print_log("lock_name=$lock_name file_name=$file_name");

    my $pid = get_lock_pid($lock_name);
    if(!$pid) {
        print_log("process is not running");
        next;
    }

    open F, "ps -eo pid,etime | " or die($!);
    while(<F>) {
        chomp;
        my ($curr_pid, $etime) = /^\s*(\d+)\s+(\S+)/;
        if($curr_pid && $curr_pid eq $pid) {
            print_log("pid=$curr_pid etime=$etime");
            my ($days) = $etime =~ /^(\d+)\-/;
            if($days && $days > 12) {
                print_log("task is being processed for $days days");
                kill "KILL", $pid;
            }
            last;
        }
    }
    close F;
}

