package BM::BMClient::BannersBender;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(BM::BMClient::BenderClient);

use IO::Select;
use Data::Dumper;
use File::Copy qw/ /;
use List::Util qw(min);
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Utils::Sys qw(staticmap_value md5int);
use BM::BMClient::BenderPattern;

########################################################
# Интерфейс
#
#   find_ids            айдишники баннеров, содержащих указанную фразу
#
########################################################

########################################################
# Инициализация
########################################################

__PACKAGE__->mk_accessors(qw(
    server_count
));

sub init {
    my ($self) = @_;
}

sub phrase2text {
    my ($self, $phr) = @_;
    return $phr->norm_phr;
}

sub find_ids_raw {
    my ($self, $text, $num_banners) = @_;

    $num_banners ||= 10;

    # получаем от сервера список пар вида "текст, ID"
    my $resp = $self->exec_command(join ("\t", "top", $num_banners, 0, $text));
    return () if !$resp;

    my @data = split "\t", $resp;
    return map{$data[$_ * 2 + 1]} (0..($#data / 2));
}

sub find_ids {
    my ($self, $phrase, $num_banners) = @_;

    if ($ENV{NO_REMOTE_REQ}) {
        die "BM::BMClient::BannersBender not supported on MR";
    }

    return $self->find_ids_raw($self->phrase2text($phrase), $num_banners);
}

sub find_ids_atoms {
    my ($self, $phrase, $num_banners) = @_;

    my $proj = $self->proj;
    my $text = $phrase->text;
    $text =~ s/&lt;/</g;
    $text =~ s/&gt;/>/g;

    my $pattern = BM::BMClient::BenderPattern->new({proj => $proj, text => $text});

    return $self->find_ids_raw($pattern->{server_pattern}, $num_banners) unless $pattern->{server_pattern} =~ /__mw_/;

    my $num_request = $num_banners;
    my $count = 0;
    while (1) {
        $count++;
        my @banner_ids = $self->find_ids_raw($pattern->{server_pattern}, $num_request);
        my $banners = $proj->bf->ids2bnl(\@banner_ids);

        my @flt_banner_ids = ();
        for my $bnr (@$banners) {
            if ($pattern->is_match([$bnr->title, $bnr->body])) {
                push @flt_banner_ids, $bnr->id;
            }
        }
        return @flt_banner_ids[0..$num_banners - 1] if scalar(@flt_banner_ids) >= $num_banners;
        return @flt_banner_ids if scalar(@banner_ids) < $num_request || $count >= 5;
        my $count_flt = scalar(@flt_banner_ids) || 1;
        $num_request = int(2 * $num_request * $num_banners / $count_flt);
    }
}

sub random_banners {
    my ($self, $num_banners, $query) = @_;

    $num_banners ||= 10;

    # получаем от сервера список пар вида "текст, ID"
    my $resp = $query
        ? $self->exec_command(join ("\t", "random_query", $num_banners, $query))
        : $self->exec_command(join ("\t", "random", $num_banners));

    return () if !$resp;
    return grep { $_ } split m/\s+/, $resp;
}

1;

