package BM::BMClient::BaseHttpServer;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(Net::Server::HTTP);

use IO::Select;
use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Socket;

########################################################
# Интерфейс
########################################################

########################################################
# Инициализация
########################################################

sub new {
    my ( $class ) = @_;
    my $self = $class->SUPER::new();
    bless $self, $class;
    $self->{active_children} = {};
    return $self;
}

sub child_init_hook {
    my ( $self ) = @_;
    require Project;
    my $proj = Project->new({ });
    $self->{proj} = $proj;
}

sub process_http_request {
    my ( $self, @data ) = @_;
    my $buffer = "";
    my $result = "";
    my $proj = $self->{proj};
    my $process_post = $self->{process_post} || sub {
        my ($proj, $post_data) = @_;
        return "$post_data\n";
    };
    my $is_alive = $self->{is_alive} || sub {
        my ($proj) = @_;

        return 0;
    };

    my ( $bytes_in, $bytes_out ) = ( 0, 0 );
    if ($ENV{'REQUEST_METHOD'} eq 'POST') {
        my $bytes_to_read = int($ENV{'CONTENT_LENGTH'});
        if ( $bytes_to_read > 0 ) {
            $buffer = _read_bytes_from_stdin( $ENV{'CONTENT_LENGTH'} );
        } else {
            $proj->log("empty POST request");
        }

        {
           require bytes; $bytes_in += length($buffer);
        }

        if ( $buffer ) {
            my $proj = $self->{proj};
            my $query = Encode::decode('UTF-8', $buffer);
            $result = Encode::encode('UTF-8', $process_post->($proj, $query));
        }
    } else {
        if ($ENV{'REQUEST_METHOD'} eq 'GET' || $ENV{'REQUEST_METHOD'} eq 'HEAD') {
            if ( $ENV{'QUERY_STRING'} eq 'alive' ) {
                if ($is_alive->($self->{proj})) {
                    $result = "ALIVE!";
                } else {
                    $result = "DEAD!";
                }
            } else {
                $result = "unknown GET-command";
            }
        }
    }
    { require bytes; $bytes_out += length($result); }
    
    $proj->log("bytes in:$bytes_in, bytes out:$bytes_out");

    print "Content-Type: text/plain\r\n",
          "Content-Length: ", length($result), "\r\n\r\n",
          $result;

    return 1;
}

sub _read_bytes_from_stdin {
    my ( $bytes ) = @_;
    my $buf = 0;

    my $offset = 0; # с какой позиции читаем

    # ждем максимально 10 секунд
    my $total_wait   = 10;
    my $start_wait = [gettimeofday];
    while ( $offset < $bytes ) {
        my $to_read = $bytes - $offset;
        my $bytes_read = int(sysread( STDIN, $buf, $bytes - $offset, $offset ));
        print STDERR "$offset $to_read $bytes_read\n";
        if ( $bytes_read < 0 ) {
            print STDERR "closed connection from socket, bytes_read:$bytes_read, to_read:$to_read, bytes:$bytes, offset:$offset\n";
            return undef;
        }
        if ( $! ) {
            print STDERR "socket error found:$!\n";
            return undef;
        }
        if ( $bytes_read == 0 && tv_interval( $start_wait ) < $total_wait ) {
            usleep(100_000);
        };
        if ( tv_interval( $start_wait ) >= $total_wait ) {
            print STDERR "read bytes:0, return empty string cause of wait expired\n";
            $buf = "";
            return $buf;
        }
        $offset += $bytes_read;
    }
    return $buf;
}

sub print_error {
    my $error_text = $_[0];
    print "Content-type: text/plain; charset=utf-8\n\n$error_text\n";
    return 1;
}

1;
