package BM::BMClient::ComptrieSubphrasesClient;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use SubphraserServer;
use BMSubphraser;   # ads/quality/bm_subphraser/xs

########################################################
# Интерфейс
########################################################

########################################################
# Инициализация
########################################################

__PACKAGE__->mk_accessors(qw(
    init_data_file
    comptrie_file
));

sub init {
    my ($self) = @_;

    ######!!!!!!#####
    $self->{comptrie_subphraser} = BMSubphraser::GetSubphraser($self->{comptrie_file});

}

sub is_connected {
    my ($self) = @_;

    return 1;
}

sub connect_once {
    my ($self) = @_;

    return;
}

sub connect {
    my ($self) = @_;
    return;
}

sub disconnect {
    my ($self) = @_;
    return;
}

sub exec_command {
    my ($self, $cmd) = @_;
    my $resp = undef;

    while(!defined($resp)) {
        $resp = $self->exec_command_once($cmd);
    }

    return $resp;
}

sub exec_command_once {
    my ($self, $cmd) = @_;
    my $full_resp;

    if($self->{private_server}) {
        # локальный сервер
        $full_resp = $self->{private_server}->ExecCommand($cmd);
    } else {
        $full_resp = $self->{comptrie_subphraser}->ExecCommandOnce($cmd);
    }

    # анализ ответа от сервера
    chomp $full_resp;
    if($full_resp =~ /^ERROR/) {
        return undef;
    }

    return $full_resp;
}

sub stop_server {
    my ($self) = @_;

    return;
}

sub create_private_server {
    my ($self) = @_;

    if(!$self->{private_server}) {
        $self->disconnect if $self->is_connected;
        $self->log("create private subphraser");
        $self->{private_server} = new SubphraserServer(0);
        open F, $self->init_data_file or die($!);
        while(<F>) {
            chomp;
            next if !$_;
            $self->exec_command_once($_);
        }
        close F;
        $self->log("/ create private subphraser");
    }
}

1;

