package BM::BMClient::DistrBannersBender;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(BM::BMClient::BannersBender);

use IO::Select;
use Data::Dumper;
use List::Util qw(min);
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Utils::Hosts qw(
    get_curr_host
);
use Utils::Sys qw(md5int);
use Utils::Math qw(permutation_by_number factorial);
use List::Util qw(shuffle);

########################################################
# Инициализация
########################################################

__PACKAGE__->mk_accessors(qw(
    hosts
    clients
));

sub init {
    my ($self) = @_;

    $self->{clients} = [];
    for my $server_id (1..$self->server_count) {
        push @{$self->clients}, BM::BMClient::BannersBender->new({ 
            proj => $self->proj, 
            %{$Utils::Common::options->{bender_params}},
            port                => $self->port,
            host                => $self->hosts->[$server_id - 1],
            binary_file         => $self->binary_file . "_$server_id",
            data_file           => $self->data_file . "_$server_id",
            index_file          => $self->index_file . "_$server_id",
            encoded_file        => $self->encoded_file . "_$server_id",
            server_id           => $server_id,
            server_count        => $self->server_count,
            max_attempts        => 3,
            max_exec_attempts   => 20,
            reconnect_sleep     => 1,
        });
    }
}

sub server_count :CACHE {
    my ($self) = @_;

    return scalar(@{$self->hosts});
}

sub find_ids_raw {
    my ($self, $text, $num_banners) = @_;
    my @result;

    $num_banners ||= 10;

    my $max_banners = $num_banners;
    my @perm = permutation_by_number($self->server_count, md5int($text) % factorial($self->server_count));
    for my $client (map {$self->clients->[$_]} @perm) {
        my @ids = $client->find_ids_raw($text, $max_banners);
        push @result, @ids;
        $max_banners -= scalar(@ids);
        last if !$max_banners;
    }

    if(@result > $num_banners) {
        @result = sort @result;
        @result = @result[0..($num_banners - 1)];
    }

    return @result;
}

sub random_banners {
    my ($self, $num_banners, $query) = @_;

    $num_banners ||= 10;

    my @result;
    for my $client (shuffle @{ $self->clients }) {
        my @ids = $client->random_banners($num_banners, $query);
        push @result, @ids;
        last if scalar(@result) >= $num_banners;
    }

    if (scalar(@result) > $num_banners) {
        @result = @result[0..($num_banners - 1)];
    }

    return @result;
}

sub get_current_host_server {
    my ($self) = @_;
    my $host = get_curr_host;

    for my $client (@{$self->clients}) {
        my $prefix = $client->host;

        if($host =~ /^$prefix/) {
            return $client;
        }
    }

    return undef;
}

1;

