package BM::BMClient::FCGI_HTTP_Server; 

# Функции из scripts/broadmatching-server/fcgi-http-server (fcgi-сервер для bmapi)
# TODO - перенести сюда все функции из scripts/broadmatching-server/fcgi-http-server

use strict;

use utf8;
use open ':utf8';

use File::Basename;

use Utils::Common;
use Utils::Sys qw(
    print_err
    get_file_lock
    get_children_pids
    mtime
);

use base qw(Exporter);

our @EXPORT_OK = qw(
    set_fcgi_parent_pid
    get_fcgi_parent_pid
    set_process_state
    get_fcgi_processes_count
    get_fcgi_pid2state
    get_fcgi_process_elapsed_time
);

our $fcgi_processes_dir = $Utils::Common::options->{dirs}{tmpfs} . "/fcgi-http-server";
my $fcgi_pidfile = $Utils::Common::options->{dirs}{lock} . "/fcgi-http-server.pid";

sub get_fcgi_parent_pid {
    if ( -f $fcgi_pidfile ) {
        open (fF,"<$fcgi_pidfile") or die("cannot open fcgi_pidfile $fcgi_pidfile ($!)");
        my $pid = <fF>;
        close fF;
        return int($pid);
    }
    return 0;
}

sub set_fcgi_parent_pid {
    my ($pid) = @_;
    my $pidfiles_dir = ($fcgi_pidfile =~ m!^(.*/)[^/]+!)[0] or die "Bad fcgi_pidfile path ($fcgi_pidfile)";
    unless (-d $pidfiles_dir) {
        Utils::Sys::do_sys_cmd("mkdir -p $pidfiles_dir");
    }
    open (tF,">$fcgi_pidfile") or die("cannot open fcgi_pidfile $fcgi_pidfile ($!)");
    print tF $pid;
    close tF;
    return 0;
}

sub set_process_state {
    my ($proj, $pid, $state) = @_;
    $proj->log("set_process_state $pid $state ...");

    my $file = _get_state_file($proj, $pid); 
    if ($state) {
        open my $fh, "> $file" or do {
            $proj->log("WARN: Could not set_process_state: open $file ($!)");
            return;
        };
        print $fh $state, "\n"; 
        close $fh or do {
            $proj->log("WARN: Could not set_process_state: close $file ($!)");
            return;
        };
    } else {
        if (-f $file) {
            unlink $file;
        }
    }

    $proj->log("set_process_state $pid $state done");
    return 1;
}

sub _get_state_file {
    my ($proj, $pid) = @_;

    unless (-d $fcgi_processes_dir) {
        $proj->do_sys_cmd("mkdir -p $fcgi_processes_dir", no_die => 1);
    }
    return "$fcgi_processes_dir/process_state_$pid";
}

sub get_process_state {
    my ($proj, $pid) = @_;

    my $file = _get_state_file($proj, $pid); 

    open my $fh, '<', $file or do {
        $proj->log("WARN: Could not get_process_state: open $file ($!)");
        return;
    };
    my $state = <$fh>;
    chomp $state;
    close $fh or do {
        $proj->log("WARN: Could not get_process_state: close $file ($!)");
        #return;
    };

    #$proj->log("get_process_state $pid $state");
    return $state;
}

sub get_fcgi_processes_count {
    my ($proj, $state) = @_;
    $state //= '';

    my $fcgi_parent_pid = get_fcgi_parent_pid();
    $proj->log("fcgi_parent_pid: $fcgi_parent_pid");
    my @pids = eval { get_children_pids($fcgi_parent_pid) };
    if ($@) {
        $proj->log("ERROR: get_children_pids: $@");
        return;
    }
    $proj->log("pids: @pids");
    if ($state) {
        @pids = grep {
            my $st = get_process_state($proj, $_) // '';
            grep { $_ eq $state } split /,/, $st;
        } @pids;
    }
    my $number = @pids;
    $proj->log("get_fcgi_processes_number($state): $number (@pids)");
    return $number;
}

sub get_fcgi_pid2state {
    my ($proj) = @_;

    my $fcgi_parent_pid = get_fcgi_parent_pid();
    $proj->log("fcgi_parent_pid: $fcgi_parent_pid");
    my @pids = eval { get_children_pids($fcgi_parent_pid) };
    if ($@) {
        $proj->log("ERROR: get_children_pids: $@");
        return;
    }
    $proj->log("pids: @pids");
    my $pid2state = { map { $_ => get_process_state($proj, $_) } @pids };
    return $pid2state;
}

# Сколько времени процесс находится в текущем состоянии
sub get_fcgi_process_elapsed_time {
    my ($proj, $pid) = @_;

    my $start_time = mtime(_get_state_file($proj, $pid))
        or return;
    my $elapsed_time = time - $start_time;
    #$proj->log("pid: $pid elapsed_time: $elapsed_time");
    return $elapsed_time;
}

1;
