package BM::BMClient::HttpServerControl;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use FindBin;
use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Socket;
use BM::BMClient::BaseHttpServer;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

########################################################
# Интерфейс
########################################################

########################################################
# Инициализация
########################################################

__PACKAGE__->mk_accessors(qw(
    port
    pid_file
    num_forks
));
    
my $SCRIPT = $FindBin::Script;

sub init {
    my ($self) = @_;
}

sub exec_command {
    my ($self, $cmd, %opts) = @_;

    if($cmd eq "start") {
        $self->start_server(%opts);
    } elsif($cmd eq "restart") {
        $self->stop_server(%opts);
        sleep(3);
        $self->start_server(%opts);
    } elsif($cmd =~ /^restart(\d+)s$/) {
        my ($max_sleep_time) = $cmd =~ /^restart(\d+)s$/;
        my $sleep_time = int(rand($max_sleep_time));
        $self->log("sleeping for $sleep_time seconds");
        sleep($sleep_time);
        $self->stop_server(%opts);
        sleep(3);
        $self->start_server(%opts);
    } elsif($cmd eq "stop") {
        $self->stop_server(%opts);
    } else {
        print_err("usage: $SCRIPT (start|restart|stop)");
        exit(1);
    }
}

sub start_server {
    my ($self, %opts) = @_;
    
    get_file_lock("start-$SCRIPT") or print_err("found already running script, do exit") and exit(0);

    my $new_pid = fork();
    exit(0) if $new_pid;

    my $pid_file = $self->pid_file;
    open F, "> " . $pid_file or die("pid file:$pid_file error:$!");
    print F $$;
    close F;

    my $params = $Utils::Common::options->{BmHttp_params};

    my $server = BM::BMClient::BaseHttpServer->new();
    $server->{$_} = $opts{$_} for qw(process_post is_alive);
    $server->run(
         port => $opts{port} || $self->{port}, 
         server_type => 'PreFork',
         min_servers  => $self->num_forks,
         max_servers  => $self->num_forks,
    );

    release_file_lock("start-$SCRIPT") or print_err("found already running script, do exit") and exit(0);
}

sub stop_server {
    my ($self) = @_;
    my $pid_file = $self->pid_file;

    if(!open(F, $pid_file)) {
        print_log("no pid file");
        return;
    } 

    my $pid = <F>;
    chomp $pid;
    close F;

    if(!open(F, "/proc/$pid/cmdline")) {
        print_log("server is not running");
        return;
    } 

    my $name = <F>;
    close F;

    if($name !~ /$SCRIPT/) {
        print_log("server is not running");
        return;
    }
   
    print_log("killing $pid...");
    `kill $pid`;
    my $num_attempts = 10;
    while($num_attempts && kill(0, $pid)) {
        sleep 1;
        $num_attempts--;
    }
    if(kill(0, $pid)) {
        die("can't kill $pid");
    }
    print_log("done");
}

1;

