package BM::BMClient::MarketSubphraser;
use strict;
use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

use BMSubphraser;
use Utils::Sys qw(staticmap_value);
use Utils::Common;

#
# Класс, дающий доступ к маркетным данным.
# Работает только через комптрай, а не сервис-сабфрейзер.
#

__PACKAGE__->mk_accessors(qw(
    init_data_file
    comptrie_file
    staticmap_file
));

sub norm_text {
    my ($self, $text) = @_;
    $text =~ s/\-/ /g;
    return join(" ", sort $self->proj->phrase(lc($text))->pluswords);
}

sub comptrie_subphraser :CACHE {
    my $self = shift;
    return BMSubphraser::GetSubphraser($self->comptrie_file);
}

# возвращает хэш { text => [ model_id, category_id ] }
sub get_market_ids {
    my ($self, $texts) = @_;

    my $result = { map { $_ => [0, 0] } @$texts };
    return $result if !@$texts;

    my $query = join("\t", 'getn', 'model', join(",", map{$self->norm_text($_)} @$texts));
    my $resp = $self->comptrie_subphraser->ExecCommandOnce($query);
    my @resp_data = split "\t", $resp;
    my $i = 1;
    for my $text (@$texts) {
        last if $i >= @resp_data;

        my $count = $resp_data[$i];
        $result->{$text} = [ split " ", $resp_data[$i + 2] ] if $count;
        $i += $count + 1;
    }

    return $result;
}

# по ключу (model_id) возвращает хэш со всеми полями файла id_category_vendor_model
sub get_market_data {
    my $self = shift;
    my $key  = shift // '';

    my $line = staticmap_value($self->staticmap_file, $key);

    my @flds = @{$Utils::Common::options->{market_data_fields}};
    my @key_flds = qw(model_id);
    my @nonkey_flds = grep { !($_ ~~ @key_flds) } @flds;

    my %h;
    @h{@nonkey_flds} = split /\t/, $line, -1;
    @h{@key_flds} = split ' ', $key;

    return \%h;
}

1;
