package BM::BMClient::PrefProjSrvClient;
use strict;

use base qw{ObjLib::Obj};

use Encode;
use JSON::XS;
use IO::Socket;
use Utils::Common;
use Data::Dumper;

our $host2socket = {};


sub init {
    my $self = shift;

    $self->{host} //= $Utils::Common::options->{PrefProjSrv_params}{host};

    my $json = JSON::XS->new;
    $json->utf8(0);  # оставляем Unicode
    $json->indent(0);
    $self->{json} //= $json;
}

sub ys_do {
    my ($self, $str) = @_;
    my $socket = $self->{socket};

    unless( $socket ){
        $socket = $host2socket->{$self->{host}};
    }

    if($socket && !$socket->connected) {
        $self->log("prefprojsrv: connection is lost");
        $socket = 0;
        $host2socket->{$self->{host}} = 0;
        $self->{socket} = 0;
    }

    my $num_attempts = 3;
    my $res = undef;
    my $last_error = "";
    $self->{client_timeout} ||= $Utils::Common::options->{PrefProjSrv_params}{client_timeout};
    while($num_attempts && !defined($res)) {
        $self->log("prefprojsrv: num_attempts=$num_attempts last_error='$last_error'") if $last_error;
        $last_error = "";

        if(!$socket) {
            $socket = IO::Socket::INET->new(
                PeerAddr => ($self->{host} ||= "127.0.0.1"),
                PeerPort => $Utils::Common::options->{PrefProjSrv_params}{port},
                Proto => "tcp",
                Timeout => 5
            );

            $num_attempts--;

            if($socket) {
                binmode($socket, ":utf8");

                $self->{socket} = $socket;
                $host2socket->{$self->{host}} = $socket;

                $self->log("prefprojsrv: connected to " . $self->{host});
            } else {
                $last_error = $! if !$socket;
            }
        }

        if($socket) {
            my $num_bytes = $socket->send("$str\n");
            if(!defined($num_bytes)) {
                $last_error = "Socket::send() failed";
                close($socket);
                $socket = 0;
                $host2socket->{$self->{host}} = 0;
                $self->{socket} = 0;
                next;
            }

            my @resp_chunks = ();
            while(!@resp_chunks || $resp_chunks[-1] !~ /\n/) {
                my $resp;
                my @ready = IO::Select->new($socket)->can_read($self->{client_timeout});
                if(!@ready) {
                    @resp_chunks = ();
                    $last_error = "prefprojsrv can_read timeout";
                    close($socket);
                    $socket = 0;
                    $host2socket->{$self->{host}} = 0;
                    $self->{socket} = 0;
                    last;
                }

                if(!defined($socket->recv($resp, 1024)) || !$resp) {
                    $last_error = "Socket::recv() failed (resp='$resp', resp_chunks='".join("", @resp_chunks)."')";
                    @resp_chunks = ();
                    close($socket);
                    $socket = 0;
                    $host2socket->{$self->{host}} = 0;
                    $self->{socket} = 0;
                    last;
                }

                push @resp_chunks, $resp;
            }

            if(@resp_chunks) {
                $res = join "", @resp_chunks;
            } else {
                close($socket) if $socket;
                $socket = 0;
                $host2socket->{$self->{host}} = 0;
                $self->{socket} = 0;
            }
        }
    }

    die("can't connect to prefprojsrv (host='".$self->{host}."', last_error='$last_error', str='$str')") if !defined($res);

    chomp $res;
    return $res;
}

#добавлено для совместимости со старым интерфейсом нормализатора
sub json_decode {
    my ($self, $data) = @_;
    return $self->{json}->decode($data);
}

sub json_encode {
    my ($self, $data) = @_;
    return $self->{json}->encode($data);
}

# доп. параметры:
#   timeout  =>  $timeout (по умолчанию - 15)
sub Do {
    my ($self, $cmd) = @_;
    my $res = $self->ys_do($cmd);
    chomp $res;

    if( $res =~ /^DoCommandERROR /){
        $res =~ s/ \/\/ /\n/g;
        print STDERR "$res\n";
        die "$res\n";
    }

    return $res;
}

sub DoJson {
    my $self = shift;
    my @cmd_params = @_;

    #$self->{proj}->dd([44,55,66]);
    #print "Content-type: text/html\n\n";
    #print '<pre>'.Dumper('EEEE', \@cmd_params);
    #print "\n====================================\n";

    my $cmd = "DoJson\t".$self->{json}->encode(\@cmd_params);
    my $res = $self->ys_do($cmd);
    my $restext = $res;

    #Если на сервере что-то пошло не так и он вернул описание ошибки
    if( $restext =~ /^DoCommandERROR/ ){ #Ошибка от сервера
        $restext =~ s/\/\//\n/g;
        die "$restext\n";
    }

    eval {
        $res = $self->{json}->decode($res);
    };
    if($@){
        local $SIG{'__DIE__'} = sub { print STDERR $self->stack_trace('  JSON ERROR   '); print STDERR "  JSON CMD     $cmd_params[0] $cmd_params[1]\n"; };
        die "JSON ERROR: $@\nCMD HEAD (substr 200):".substr($cmd, 0, 200)."\nRES:\n$res\nRESTEXT:\n$restext\n";
    }
    return $res;
}

1;
