package BM::BMClient::RandomBannersClient;

use strict;
use warnings;

use utf8;
use open ':utf8';
no warnings 'utf8';

use base qw(ObjLib::ProjPart);

use List::MoreUtils qw(uniq);

sub init {
    my ($self) = @_;
}

sub _options2tokens {
    my $self = shift;
    my $options = shift;

    my @tokens;
    my $proj = $self->proj;

    my $unsupported_semantics_message = "'or' semantics is not supported anymore, use BM::YQL::Helpers::get_k_random_banners() instead";

    # токены вида lang_ru
    if (defined $options->{lang}) {
        my @langs = @{ $options->{lang} };
        die $unsupported_semantics_message if scalar(@langs) > 1;
        my $lang = shift @langs;
        push @tokens, "lang_" . $lang if $lang;
    }

    # токены вида categ_g1626
    if (defined $options->{categ_ids}) {
        my @categ_ids = @{ $options->{categ_ids} // [] };
        die $unsupported_semantics_message if scalar(@categ_ids) > 1;
        my $categ_id = shift(@categ_ids);
        push @tokens, "categ_" . $categ_id if $categ_id;
    }
    
    # поддерживаем только вариант active_flag => [1]
    if (
        defined($options->{active_flag})
        && scalar(@{ $options->{active_flag} }) == 1
        && $options->{active_flag}->[0] == 1
    ) {
        push @tokens, "active_flag";
    }

    # конвертировать имена категорий в идентификаторы - теперь забота пользователя
    if (defined $options->{mctgs}) {
        die "'mctgs' option is not supported anymore, use 'categ_ids'";
    }
    
    # при подготовке данных для бендера в текст баннера добавляется довольно много других интересных токенов, см. yt_prepare_banners_data.py, можно поддержать и их, если нужны
    
    return uniq @tokens;
}

# gets $k random uniformly distributed banners from banners pool filtered by $options
# $options supports lang, active_flag, categ_ids and mctgs parameters
# as of now, "or" semantics is not supported
# for example, { lang => ['ru'], active_flag => [1] } works, but { lang => ['ru', 'en'] } does not 
sub k_random_banners {
    my ($self, $k, $options) = @_;
    
    my @tokens = $self->_options2tokens($options);
    return join ",", $self->proj->banners_bender->random_banners($k, join(" ", @tokens));
}

sub k_random_bnl {
    my $self = shift;
    my $resp = $self->k_random_banners(@_);
    my @bids = split /,/, $resp;
    return $self->proj->bf->ids2bnl(\@bids);
}

1;

