package BM::BMClient::ServerCommands;
use strict;

use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

use Encode;
#use JSON;
use JSON::XS;
use IO::Socket;
use Data::Dumper;

use Utils::Common;
use Utils::Words;
use BM::Phrase;
use BM::Banners::LBannerDirect;

use Time::HiRes qw/time/;


__PACKAGE__->mk_accessors(qw(
    json
));

sub init {
    my $self = shift;

    my $proj = $self->proj;

    my $json = JSON::XS->new;
    $json->utf8(0);
    $json->indent(0);
    $self->{json} = $json;
}

sub DoCommand {
    my $self = shift;
    my $res = '';
    my @prms = @_;
    my $err = $self->proj->catch_exception( sub { $res = $self->_DoCommand(@prms) });
    if($err){
        $err =~ s/\n/ \/\/ /g;
        print STDERR "ERROR: $err";
        return "DoCommandERROR $err";
    }
    return $res;
}

# обработка комманд  - работает с UTF-8
sub _DoCommand : TIMELOG {
    my $self = shift;
    my $command = shift;
    $self->{commands_processed}++;
    my $proj = $self->proj;
    my $json = $self->json;

#    print STDERR "DoCommandLog:[$command]\n";

    if ($command =~ /^alive$/i) {
        return 'YES';
    } elsif ($command =~ /^eval\s+(.*)/) {
        # произвольные вычисления с $proj
        # DoCommand('eval join("/",$proj->phrase("test")->get_minicategs)');
        my $cmd = $1;
        my $res = eval $cmd;
        return $@ ? '' : $res;
    } elsif ($command =~ /^DoJson\t(.*)/) {
        $self->proj->timelogbeg('json->decode');
        my $data = $json->decode($1);
        $self->proj->timelogend('json->decode');
        unless( ref($data) eq 'ARRAY' ){
            print STDERR "ERROR: Bad DoJson data\n";
            return $self->json->encode([]);
        }
        my ($type, $cmd, @params) = @$data;
        if($type){
            my @arr;
            if( $type eq 'site' ){
                my $t = shift @params;
                #print STDERR "site: $cmd $t\n";
                @arr = $proj->site($t)->$cmd(@params);
            }elsif( $type eq 'phrase' ){
                my $t = shift @params;
                #print STDERR "phrase: $cmd $t\n";
                @arr = $proj->phrase($t)->$cmd(@params);
            }elsif( $type eq 'banner' ){
                my $t = shift @params;
                #print STDERR "phrase: $cmd $t\n";
                @arr = $proj->smart_json_decode($t)->$cmd(@params);
            }elsif( $type =~ /^banner_lang_(.*)/ ){
                my $lang = $1;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $t = shift @params;
                #print STDERR "phrase ($lang): $cmd $t\n";
                @arr = $proj->smart_json_decode($t)->$cmd(@params);

                $proj->current_lang($prevlang);
            }elsif( $type =~ /^phrase_lang_(.*)/ ){
                my $lang = $1;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $t = shift @params;
                #print STDERR "phrase ($lang): $cmd $t\n";
                @arr = $proj->phrase($t)->$cmd(@params);

                $proj->current_lang($prevlang);
            }elsif( $type eq 'phrase_list' ){
                my $t = shift @params;
                #print STDERR "phrase: $cmd $t\n";
                @arr = $proj->phrase_list($t)->$cmd(@params);
            }elsif( $type =~ /^phrase_list_lang_(.*)/ ){
                my $lang = $1;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $t = shift @params;
                #print STDERR "phrase_list ($lang): $cmd $t\n";
                @arr = $proj->phrase_list($t)->$cmd(@params);

                $proj->current_lang($prevlang);
            }elsif( $type =~ /^pair_phrase_list_lang_(.*)/ ){
                my $lang = $1;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $t  = shift @params;
                my $t2 = shift @params;
                my $phl1 = $proj->phrase_list($t);
                my $phl2 = $proj->phrase_list($t2);
                #print STDERR "phrase_list ($lang): $cmd $t\n";
                @arr = $phl1->$cmd($phl2, @params);

                $proj->current_lang($prevlang);
            }elsif( $type =~ /^phrase_list_db_\(([^)]*)\)_\(([^)]*)\)/ ){
                my $lang = $1;
                my $login = $2;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $t = shift @params;
                #print STDERR "phrase_list db ($lang) ($login): $cmd $t\n";
                my $phl = $proj->phrase_list($t);
                @arr = $phl->$cmd(@params);

                #if((@arr == 1)&&($arr[0] =~ /PhraseList/)){
                $proj->save_phrase_list($_) for $phl;
                for my $el (@arr){
                    my $rf = ref($el);
                    if ($rf =~ /PhraseList/){
                        $proj->save_phrase_list($_) for $el;
                        $proj->add_phrase_list_action({
                            phlid => $el->cache_id,
                            act => $cmd,
                            prevphlid => $phl->cache_id,
                            name => 'PhraseList [PS] '.$el->cache_id,
                            dir => 'unsorted',
                            login => $login,
                        });
                    }
                }

                $proj->current_lang($prevlang);
            }elsif( $type eq 'page' ){
                my $url      = shift @params;
                my $name     = shift @params;
                my $pagetext = shift @params;
                $pagetext = undef if $pagetext eq '-';
                @arr = $proj->page($url, $name, $pagetext)->$cmd(@params);
            }elsif( $type =~ /^page_lang_(.*)/ ){
                my $lang = $1;
                my $prevlang = $proj->current_lang;
                $proj->current_lang($lang);

                my $url  = shift @params;
                my $name = shift @params;
                my $pagetext = shift @params;
                $pagetext = undef if $pagetext eq '-';
                @arr = $proj->page($url, $name, $pagetext)->$cmd(@params);

                $proj->current_lang($prevlang);
            }elsif( $type eq 'page_list' ){
                my $t = shift @params;
                #print STDERR "page_list: $cmd $t\n";
                @arr = $proj->page_list($t)->$cmd(@params);
            }elsif( $type eq 'cat' ){
                my $catid  = shift @params;
                if($cmd eq 'get_minicateg_by_id'){
                    @arr = ($proj->categs_tree->get_minicateg_by_id($catid));
                }elsif($cmd eq 'get_minicateg_id'){
                    @arr = ($proj->categs_tree->get_minicateg_id($catid));
                }elsif($cmd eq 'get_minicateg_by_norm'){
                    @arr = ($proj->categs_tree->get_minicateg_by_norm($catid));
                }
            }else{
                die("Unknown cmd='$cmd' type='$type'");
            }
            for my $el ( @arr ){
                my $rf = ref($el);
                $el = ['::phrase_list', join(',', map {"$_"} @$el) ] if $rf =~ /PhraseList/;
                $el = ['::page', $el->url, $el->name ] if $rf =~ /Page/ && $rf !~ /PageList/;
                $el = ['::page_list', [ map {[$_->url, $_->name]} @$el ] ] if $rf =~ /PageList/;
                $el = ['::phrase', "$el" ] if $rf =~ /Phrase(?!List)/;
#                $el = ['::page_list', [ map {"$_"} @$el ] ] if $rf =~ /PageList/;
            }
            my $res;
            eval {
                $res = $self->json->encode(\@arr);
            };
            if($@){
                die("ERROR: '$@', DATA: '$command'");
            }
            return $res;
        }
        print STDERR "ERROR: Bad DoJson type\n";
        return $self->json->encode([]);
    } elsif ($command =~ /^Phrase::(\S+)\s+(.*)/) {
        # общая команда для объекта Phrase
        my ($method, $text) = ($1, $2);
        my $phr = $proj->phrase($text);
        my $res = eval { $phr->$method };
        return '' if $@;
        my $str;
        if (ref($res) eq 'BM::Phrase') {
            $str = $res->text;
        } elsif (ref($res) eq 'HASH' or ref($res) eq 'ARRAY') {
            $str = $self->json->encode($res);
        } else {
            $str = $res;
        }
        return $str;
    } elsif ($command =~ /^norm_phr\s+(.*)$/) {
        my $phrase = $1;
        return $proj->phrase($phrase)->norm_phr;
    } elsif ($command =~ /^snorm_phr\s+(.*)$/) {
        my $phrase = $1;
        return $proj->phrase($phrase)->snorm_phr;
    } elsif ($command =~ /^badphrsreason\s+(.*)$/) {
        my $phrase = $1;
        return $proj->phrase($phrase)->badphrsreason;
    } elsif ($command =~ /^get_page_categs\s+(.*)$/) {
        return join('/', $proj->page($1)->get_minicategs);
    } elsif ($command =~ /^get_page_categs_data\s+(.*)$/) {
        my $url = $1;
        my $page = $proj->page($url);
        my $data = Dumper($proj->default_language->pages_categories->get_page_categs_subphrases($page->one_line_text));
        $data =~ s/\n/<br>/g;
        return $data;
    } elsif ($command =~ /^get_regions\s+(.*)$/) {
        my $text = $1;
        return $self->json->encode([$proj->phrase($text)->get_regions]);
    } elsif ($command =~ /^get_minicategs\s+(.*)$/) {
        my $phrase = $1;
        return join('/', $proj->phrase($phrase)->get_minicategs);
    } elsif ($command =~ /^get_minicategs_subphrases\s+(.*)$/) {
        my $phrase = $1;
        my $ph_obj = $proj->phrase($phrase);
        my $h = $ph_obj->decode_minicategs_subphrases_hash;

        # список встречающихся во фразах атомов
        my $atoms = {};
        for my $ph (keys %$h) {
            my @atoms = $ph =~ /(\[[^\]]+\])/g;
            $atoms->{$_}++ for @atoms;
        }

        $h->{$_} = join("/", sort keys %{$h->{$_}}) for keys %$h;
        for my $ph (keys %{$ph_obj->{atom_codes}}) {
            my @atoms = grep{$atoms->{$_}} map{$ph_obj->language->code_atoms->{$_}} split "/", $ph_obj->{atom_codes}{$ph};

            $h->{"[".$ph."]"} = join("/", @atoms) if @atoms;
        }
        return join("\t", %$h);
    } elsif ($command =~ /^get_bnr_minicategs\s+(\d+)/) {
        my $bnr_id = $1;
        my $bnr = $self->proj->bf->get_banner_by_id($bnr_id);
        return '-' if !$bnr;  # чтобы отличить от случая, когда категорий нет
        return join('/', $bnr->get_minicategs);
    } elsif ($command =~ /^categs2categids\s+(.*)$/) {
        my $cat_str = $1;
        my @cat = split /\//, $cat_str;
        my @ids = map { $self->proj->categs_tree->get_minicateg_id($_) || '0' } @cat;
        return join(',', map { $_ || '?' } @ids);
    } elsif ($command =~ /^get_minicategs_str\s+(.*)$/) {
        my $phrase = $1;
        my @ctgs = $proj->phrase($phrase)->get_minicategs;
        my @ctg_ids = map { $self->proj->categs_tree->get_minicateg_id($_) || '?' } @ctgs;
        return join(' / ', map { "$ctgs[$_] ($ctg_ids[$_])" } 0 .. $#ctgs);
    } elsif ($command =~ /^stopword\s+(.*)$/) {
        my $word = $1;
        return stop4norm(word2norm(lc $word)) ? 1 : 0;
    } elsif ($command =~ /^badword\s+(.*)$/) {
        my $word = $1;
        return bad4snorm(word2snorm(lc $word)) ? 1 : 0;
    } elsif ($command =~ /^word_analyze\s+(.*)$/) {
        return $self->do_word_analyze($1);
    } elsif ($command =~ /^check_add_phrases\s(.*)$/) {
        my @phrases = map{$proj->phrase($_)} split ",", $1;
        my @result;

        for my $ph (@phrases) {
            my $msg = "OK";
            my @exact_cts = $ph->get_exact_minicategs;

            if($ph->snorm_phr !~ /\s/) {
                $msg = "WARNING однословная фраза";
            } elsif (@exact_cts) {
                $msg = "ERROR фраза уже содержится в категориях (".join("/", @exact_cts).")";
            } elsif($ph->is_wide_phrase) {
                $msg = "WARNING широкая фраза";
            }

            push @result, join("\t", $ph->text, $ph->snorm_phr, join("/", $ph->get_minicategs), $msg);
        }

        return join "#", @result;
    } elsif ($command =~ /^expand_phrases\s(\d+)\s(.+)/) {
        my ($max_phrases, $phrases) = ($1, $2);
        my @result;

        # каждую фразу разваливаем по атомам
        for my $ph (map{$proj->phrase($_)} split ",", $phrases) {
            my $phl = $ph->expand_to_phl_atoms_bender($max_phrases);

            push @result, $_ for $phl->phrases;
        }

        # разваливание по синонимам
        my %final;
        for my $ph (@result) {
            $final{$ph->text}++;
            $final{$_->text}++ for $ph->get_bender_syn->phrases;
        }

        return join ", ", sort keys %final;
    } elsif($command =~ /^get_model_vendor_phrases\s+(.*)$/ ) {
        my @phrases = map{$proj->phrase($_)} split ",", $1;
        my @res = ();

        for my $phrase ( @phrases ) {
	    my ($vendor, $model) = $phrase->parse_fast();
            push @res, join("###", $vendor, $model);
        }
	my $text_result = join(',', @res);
	$text_result =~ s/[\r\n]+/ /g;
	return $text_result;
    } elsif($command =~ /^bnr_categs\s(\w+)\t(.+)/) {
        my $given_phr = $proj->get_language($1)->phrase($2);
        my $phr = $given_phr->get_banner_prefiltered_phrase;
        my $h = $phr->orig_minicategs_subphrases_hash;
        my $cth = {map{$_=>[]} $phr->get_minicategs};

        for my $ph (keys %$h) {
            for my $categ (keys %{$h->{$ph}}) {
                my $arr = $cth->{$categ};
                push @$arr, $ph if $arr;
            }
        }

        my $flags_str = join(",", $given_phr->get_banner_catalogia_flags);

        return join("\t", $flags_str, map {
                $_,
                join(",", sort @{$cth->{$_}})
               } sort keys %$cth);
    } elsif($command =~ /^bnr_categs_json\s(\w+)\t(.+)/) {
        my $given_phr = $proj->get_language($1)->phrase($2);
        my $phr = $given_phr->get_banner_prefiltered_phrase;
        my $h = $phr->orig_minicategs_subphrases_hash;
        my $cth = {map{$_=>[]} $phr->get_minicategs};

        for my $ph (keys %$h) {
            for my $categ (keys %{$h->{$ph}}) {
                my $arr = $cth->{$categ};
                push @$arr, $ph if $arr;
            }
        }

        my $flags_str = join(",", $given_phr->get_banner_catalogia_flags);

        return $self->json->encode({
            flags => $flags_str,
            catphrases => $cth,
        });
        #return join("\t", $flags_str, map {
        #        $_,
        #        join(",", sort @{$cth->{$_}})
        #       } sort keys %$cth);
    } elsif ($command =~ /^bnr_categs_by_id\s(\d+)/) {
        my $bid = $1;
        my $bnr = $proj->bf->lbanner($bid);
        return $bnr ? join('/', $bnr->get_minicategs) : "";
    } elsif ($command =~ /^camp_categs\s(\d+)/) {
        my $cid = $1;
        my $camp = $proj->bf->campaign($cid);
        return join('/', $camp->get_minicategs);
    } elsif ($command =~ m!^(GET / HTTP/1.0|HELP|)\s*$!) {
        $proj->log("WARN: scan command, skip it"); # https://st.yandex-team.ru/IRT-326#1473880719000
        return '';
    } else {
        my @netstat = `netstat -ap`;
        my @ps = `ps auxf`;
        $proj->log("ERROR: unknown command: [$command]");
        $proj->log("Netstat:  " . join(" // ", map {chomp; $_} @netstat) );
        $proj->log("Ps:  " . join(" // ", map {chomp; $_} @ps) );
        return '';
    }
}

# полный анализ слова
# на входе - строка "$word $lang"
# возвращает хэш
# word => слово
# norm => , snorm => ,
# flags => [ 'WIDE', 'STOP' , ... ]
# synonyms => [ goodsyn, [ misspells ] ]
sub do_word_analyze {
    my $self = shift;
    my $cmd_text = shift;
    my $proj = $self->proj;
    my $json = $self->{json};

    my %result;
    my ($word, $lang) = split /\s+/, $cmd_text;
    $self->log("lang:$lang ($cmd_text)");
    $result{word} = $word;

    my $norm = word2norm($word, $lang);
    my $snorm = norm2snorm($norm, $lang);
    $result{norm} = $norm;
    $result{snorm} = $snorm;
    my @flags;
    push @flags, 'STOP' if stop4norm($norm, $lang);
    push @flags, 'WIDE' if $proj->get_language($lang)->is_snorm_wide($snorm);
    push @flags, 'BAD' if bad4snorm($snorm);    # TODO  $lang
    $result{flags} = \@flags;

    $result{goodsyns} = [ grep { $_ ne $norm } snorm2goodsyns($snorm, $lang) ];
    $result{misprints} = [ norm2misprints($norm, $lang) ];

    return $self->json->encode(\%result);
}

sub _get_fake_banner {
    my $proj = shift;

    my %h = (
        proj            => $proj,
        id              => 0,
        campaign_id     => 0,
        title           => 'Fake banner title',
        body            => 'Fake banner body',
        targetting      => 213,
        phrases         => '',
        url             => 'http://ya.ru',
        active_flag     => 1,
        bs_banner_id    => 0,
        bs_order_id     => 0,
        site_domain     => 'ya.ru',
        group_id        => 0,
        is_moderated    => 1,
        image_flag      => 0,
        status_show     => 1,
        status_archived => 0,
        banner_type     => 'text',
    );
    require BM::Banners::LBannerBM;
    return BM::Banners::LBannerBM->new(\%h);
}

# for test purposes
sub power {
    my $self = shift;
    my $x = shift;
    my %par = @_;
    return $x ** ($par{pow} || 2);
}

1;
