package BM::BMClient::SubphrasesClient;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use IO::Select;
use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use IO::Socket::INET6;
use Utils::Sys qw(switch_to_ipv4 switch_to_ipv6);
use POSIX;
use SubphraserServer;

########################################################
# Интерфейс
########################################################

########################################################
# Инициализация
########################################################

__PACKAGE__->mk_accessors(qw(
    port
    host
    dir_server
    init_data_file
    max_connect_attempts
    temp_dir
    work_dir
    comptrie_file
    sandbox_resource
));

sub init {
    my ($self) = @_;

    $self->{socket} = 0;
}

sub is_connected {
    my ($self) = @_;

    return $self->{socket};
}

sub connect_once {
    my ($self) = @_;

    return if $self->is_connected;

    my $socket = IO::Socket::INET->new(
        PeerAddr => $self->host,#inet_ntoa(inet_aton($self->host)), 
        PeerPort => $self->port, 
        Proto => "tcp",
        Timeout => 5
    );
    
    if($socket) {
        if(!$socket->connected) {
            $socket = 0;
            return;
        }

        binmode($socket, ":utf8");

        $self->log("subphraser: connected to ".$self->host.":".$self->port);

        $self->{socket} = $socket;
    }
}

sub connect {
    my ($self) = @_;
    my $socket;
    my $num_attempts = 0;
    
    while(!$self->is_connected && $num_attempts < $self->max_connect_attempts) {
        if($num_attempts) {
            $self->log("subphraser: can't connect to ".$self->host.":".$self->port." ($num_attempts attempts) -- $!");
            sleep(10);
        }
        $self->connect_once;
        $num_attempts++;
    }
}

sub disconnect {
    my ($self) = @_;

    close($self->{socket}) if $self->{socket};
    $self->{socket} = 0;

    $self->log("subphraser: disconnected");
}

sub exec_command {
    my ($self, $cmd) = @_;
    my $resp = undef;

    while(!defined($resp)) {
        $resp = $self->exec_command_once($cmd);
    }

    return $resp;
}

sub exec_command_once {
    my ($self, $cmd) = @_;
    my $num_bytes;
    my $full_resp;

    if($self->{private_server}) {
        # локальный сервер
        $full_resp = $self->{private_server}->ExecCommand($cmd);
    } else {
        $self->connect;
        
        eval { $num_bytes = $self->{socket}->send("$cmd\n"); };
        if(!defined($num_bytes) || $@) {
            $self->disconnect;
            $self->log("Socket::send() failed " . ($@ || ""));
            return undef;
        }

        my @resp_chunks = ();
        while(!@resp_chunks || $resp_chunks[-1] !~ /\n/) {
            my $resp;

            my @ready = IO::Select->new($self->{socket})->can_read(5);
            if(!@ready) {
                $self->log("can_read timeout");
                $self->disconnect;
                return undef;
            }

            if(!defined($self->{socket}->recv($resp, 1024)) || !$resp) {
                $self->disconnect;
                $self->log("Socket::recv() failed");
                return undef;
            }

            push @resp_chunks, $resp;
        }
        
        $full_resp = join "", @resp_chunks;
    }

    # анализ ответа от сервера
    chomp $full_resp;
    $self->disconnect if $full_resp eq "BYE";
    if($full_resp =~ /^ERROR/) {
        $self->disconnect;
        return undef;
    }

    return $full_resp;
}

sub stop_server {
    my ($self) = @_;

    $self->connect_once;
    $self->exec_command("stop") if $self->is_connected;
}

sub create_private_server {
    my ($self) = @_;

    if(!$self->{private_server}) {
        $self->disconnect if $self->is_connected;
        $self->log("create private subphraser");
        $self->{private_server} = new SubphraserServer(0);
        open F, $self->init_data_file or die($!);
        while(<F>) {
            chomp;
            next if !$_;
            $self->exec_command_once($_);
        }
        close F;
        $self->log("/ create private subphraser");
    }
}

1;

