package BM::Banners::BannerFactoryYT;

use strict;
use warnings;

use utf8;
use open ':utf8';

use base qw(BM::Banners::BannerFactoryDB);

use BM::YQL::Client qw(make_yql_request);


sub _get_yt_banners_table {
    my $self = shift;

    return {
        cluster => "hahn",
        path => "//home/catalogia/banners_extended",
    };
}

sub domains2banners {
    my ($self, $lst) = @_;

    my $banners_table = $self->_get_yt_banners_table();
    my $yql = "
        select bid
        from $banners_table->{cluster}.`$banners_table->{path}`
        where domain in (" . join(", ", map { "'$_'" } @$lst) .  ")
    ";

    my ($yql_result) = make_yql_request($yql);
    my $data = $self->proj->yt_client()->read_table($yql_result->{table_path}, "'<encode_utf8=false>json'");

    return map { $_->{bid} } @$data;
}

sub get_campaigns_by_domain {
    my ($self, $lst) = @_;

    my $banners_table = $self->_get_yt_banners_table();
    my $yql = "
        select distinct cid
        from $banners_table->{cluster}.`$banners_table->{path}`
        where domain in (" . join(", ", map { "'$_'" } @$lst) .  ")
    ";

    my ($yql_result) = make_yql_request($yql);
    my $data = $self->proj->yt_client()->read_table($yql_result->{table_path}, "'<encode_utf8=false>json'");

    return map { $_->{cid} } @$data;
}

sub domains2domains_login {
    my ($self, $lst) = @_;

    my $banners_table = $self->_get_yt_banners_table();
    my $yql = "
        select distinct domain, uid
        from $banners_table->{cluster}.`$banners_table->{path}`
        where domain in (" . join(", ", map { "'$_'" } @$lst) .  ")
    ";

    my ($yql_result) = make_yql_request($yql);
    my $data = $self->proj->yt_client()->read_table($yql_result->{table_path}, "'<encode_utf8=false>json'");

    my $lh = $self->proj->get_uid2login_hash([ keys %{{ map {$_->{'uid'} => 1} @$data }} ]);

    return map { $_->{'domain'} . ' =*> ' . $lh->{$_->{'uid'}} } @$data;
}

sub _get_firstcampaigns {
    my ($self, $dmns) = @_;

    my $yt2mysql = $self->fields_mapping->{yt2mysql};

    my $banners_table = $self->_get_yt_banners_table();
    my $yql = "
        select `domain` as `$yt2mysql->{domain}`, `uid` as `$yt2mysql->{uid}`, min(`cid`) as `campaign_id`
        from $banners_table->{cluster}.`$banners_table->{path}`
        where `domain` in (" . join(", ", map { "'$_'" } @$dmns) .  ")
        group by `uid`, `domain`
    ";

    my ($yql_result) = make_yql_request($yql);
    my $data = $self->proj->yt_client()->read_table($yql_result->{table_path}, "'<encode_utf8=false>json'");

    return { map { $_->{uid} => $_ } @$data };
}

sub get_domain_phrases {
    my ($self, $lst, %prm) = @_;

    my $banners_table = $self->_get_yt_banners_table();
    my $limit_str = $prm{bnrs_limit} ? "limit $prm{bnrs_limit}" : "";
    my $yql = "
        select domain, phrases
        from $banners_table->{cluster}.`$banners_table->{path}`
        where domain in (" . join(", ", map { "'$_'" } @$lst) .  ")
        $limit_str
    ";

    my ($yql_result) = make_yql_request($yql);
    my $data = $self->proj->yt_client()->read_table($yql_result->{table_path}, "'<encode_utf8=false>json'");

    return map { [ $_->{domain}, $_->{phrases} ] } @$data;
}

1;
