package BM::Banners::Campaign;
use strict;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);

use URI::Escape;

########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(
    campaign_id
));

########################################################
# Инициализация
########################################################

sub get_proxy_ref {
    my $self = shift;
    if (!defined $self->{proxy_ref}) {
        my $weak_ref = $self;
        weaken($weak_ref);
        $self->{proxy_ref} = \$weak_ref;
    }
    return $self->{proxy_ref};
}

########################################################
#Методы
########################################################


sub cid               { $_[0]->get_inf->{'cid'} }
sub name              { $_[0]->get_inf->{'name'} }
sub OrderID           { $_[0]->get_inf->{'OrderID'} }
sub shows             { $_[0]->get_inf->{'shows'} }
sub clicks            { $_[0]->get_inf->{'clicks'} }
sub sum               { $_[0]->get_inf->{'sum'} }
sub sum_spent         { $_[0]->get_inf->{'sum_spent'} }
sub statusActive      { $_[0]->get_inf->{'statusActive'} }
sub autobudget        { $_[0]->get_inf->{'autobudget'} }
sub autobudget_sum    { $_[0]->get_inf->{'autobudget_sum'} }
sub ContextLimit      { $_[0]->get_inf->{'ContextLimit'} }
sub minus_words       { $_[0]->get_inf->{'minus_words'} }
sub broad_match_limit { $_[0]->get_inf->{'broad_match_limit'} }
sub GoalID            { $_[0]->get_inf->{'GoalID'} }
sub uid               { $_[0]->get_inf->{'uid'} }
sub ClientID          { $_[0]->get_inf->{'ClientID'} }
sub broad_match_flag  { $_[0]->get_inf->{broad_match_flag} }
sub broad_match_rate  { $_[0]->get_inf->{broad_match_rate} }
sub status_archived   { $_[0]->get_inf->{status_archived} }

sub recent_sum_rub    { $_[0]->get_inf->{recent_sum_rub} }

sub related_keywords_flag { $_[0]->get_inf->{broad_match_flag} }  # IRT-1453: related_keywords_flag = broad_match_flag


# не кэшируем, чтобы не запоминать лишние баннеры в остальных методах
sub get_all_banners {
    my $self = shift;
    my $bf = $self->bf;
    my $lst = $bf->banner_list( $bf->get_campaign_banners($self->campaign_id) );
    $self->assign_banner($_) for @$lst;
    return $lst;
}

sub assign_banner {
    my $self = shift;
    my $bnr = shift;

    $bnr->{'campaign_obj_wkn'} = $self->get_proxy_ref;
}

# баннеры без картинок
sub bnl :CACHE {
    my $self = shift;
    return $self->get_all_banners->lgrep(sub { !$_->image_flag });
}

sub get_remotecache_id {
    my ($self) = @_;
    return $self->campaign_id;
}

sub bf {
    my ($self) = @_;
    return ${$self->{'bf'}} if defined $self->{'bf'};
    return $self->proj->bf;
}

sub get_inf :CACHE {
    my ($self) = @_;
    my $lst = $self->bf->get_campaign_inf($self->campaign_id);
    return $lst->[0] if @$lst;
    return {};
}

sub get_minicategs :CACHE {
    my $self = shift;
    return $self->bnl->get_minicategs;
}

sub dumper_text {
    my ($self) = @_;
    $_[0] = \"Campaign $self->{campaign_id}";
    return @_;
}

sub dumper_text_lite {
    my ($self) = @_;
    $_[0] = \"Campaign $self->{campaign_id}";
    return @_;
}

sub FREEZE {
    my ($self) = @_;
    my %inf;
    my @native = qw(campaign_id);
    my @cache = map { '_cached_'.$_ } qw(GoalID get_inf);
    for my $key (@native, @cache) {
        if (exists $self->{$key}) {
            $inf{$key} = $self->{$key};
        }
    }
    return \%inf;
}

our $JSON_KEY = '__j_BM_Banners_Campaign__';
our $JSON_CLASS = 'BM::Banners::Campaign';

sub TO_JSON {
    my $self = shift;

    my $inf = $self->FREEZE();

    return { $BM::Banners::Campaign::JSON_KEY => $inf };
}

sub FROM_JSON {
    my ($class, $proj, $proto_obj, $hash, $smart_cache) = @_;
    $hash->{proj} = $proj;
    return $proto_obj->new($hash);
}

use overload
    '@{}' => sub {
             my ($self) = @_;
             return \@{$self->bnl};
        },
    '""' => sub {
             my ($self) = @_;
             my $bnl = $self->bnl;
             return "$bnl";
        },
    'bool' => sub {
             my ($self) = @_;
             return 1;
        };


1;


