package BM::Banners::LBannerBM;
use strict;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Banners::LBannerDirect);

use Utils::Sys qw(md5int);


########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(
));

########################################################
# Инициализация
########################################################

########################################################
#Методы
########################################################

sub bmpgl { return undef  }

# matching env - информация о привязке
sub menv {
    my $self = shift;
    if (@_) {
        $self->{menv} = $_[0];
    }
    $self->{menv} //= {};
    return $self->{menv};
}

#
# эксперименты
#

sub experiment {
    my $self = shift;
    return $self->get_current_experiments($self->id);
}

# метод класса
sub get_current_experiments {
    my $class = shift;
    my $id = shift;
    my %exper;

    return \%exper;
}

sub FREEZE {
    my ($self) = @_;
    my %inf;
    my @native = qw(
        active_flag
        banner_type
        body
        bs_banner_id
        bs_order_id
        campaign_id
        categories
        group_id
        id
        image_flag
        is_moderated
        lang
        phrases
        site_domain
        status_archived
        status_show
        targetting
        title
        uid
        url

        menv
    );
    my @cache = map { '_cached_'.$_ } qw(GoalID get_inf get_minicategs);
    for my $key (@native, @cache) {
        if (exists $self->{$key}) {
            $inf{$key} = $self->{$key};
        }
    }
    return \%inf;
}


our $JSON_KEY = '__j_BM_Banners_LBannerBM__';
our $JSON_CLASS = 'BM::Banners::LBannerBM';

sub TO_JSON {
    my $self = shift;

    my %inf = ();
    my %native = map { ( $_ => 1 ) } qw/
        active_flag
        banner_type
        body
        bs_banner_id
        bs_order_id
        campaign_id
        categories
        group_id
        id
        image_flag
        is_moderated
        lang
        phrases
        site_domain
        status_archived
        status_show
        targetting
        title
        title_extension
        uid
        url

        menv
    /;
    my %cache = map { ( "_cached_$_" => 1 ) } qw/GoalID get_inf/;
    for my $key (keys %{ $self }) {
        if ($native{$key} || $cache{$key}) {
            $inf{$key} = $self->{$key};
        }
    }

    return { $BM::Banners::LBannerBM::JSON_KEY => \%inf };
}

sub FROM_JSON {
    #TODO support smart cache (see BM::Phrase)
    my ($class, $proj, $proto_obj, $hash) = @_;
    $hash->{proj} = $proj;
    return $proto_obj->new($hash);
}

1;


