package BM::Banners::LBannerDirect;
use strict;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Banners::LBannerAnalysis);

use Utils::Urls qw(banner_domain url_to_domain);
use Utils::Regions qw();


########################################################
# Интерфейс
########################################################

#   id                            id баннера
#   campaign_id                   номер кампании - может потребоваться для получения настроек для кампании
#   domain                        нормализованный домен
#   raw_domain                    домен, полученный из url
#   site_domain                   домен после редиректов
#   effective_domain              домен второго уровня (с учетом хостингов и региональных доменов)


__PACKAGE__->mk_accessors(qw(
    id
    campaign_id
    uid
    targetting
    active_flag
    bs_banner_id
    bs_order_id
    group_id

    site_domain

    status_show
    image_flag
    status_archived
    is_moderated
    banner_type
));

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;
    $self->SUPER::init;
}


########################################################
#Методы
########################################################

sub get_remotecache_id {
    my ($self) = @_;
    return $self->id;
}

sub domain :CACHE {
    my $self = shift;
    return banner_domain(url_to_domain($self->url));
}

sub geotargeting_subtree :CACHE {
    my ($self) = @_;
    return [ Utils::Regions::geobase_subtree([split /,/, $self->{targetting}]) ];
}
sub geotargeting_subtree_hash :CACHE {
    my ($self) = @_;
    return +{ map { $_ => 1 } @{ $self->geotargeting_subtree } };
}

use overload
    '""' => sub {
            my ($self) = @_;
            my $phrs = '';
            $phrs .= $_->text."\n" for $self->phrases;
            my $banner = $self->title."\n".
                         $self->body."\n".
                         $self->url."\n".
                         $phrs;
            return $banner;
        };


1;
