package BM::Banners::LBannerList;
use strict;

use utf8;
use open ':utf8';

use List::Util qw(max);

use std;
use base qw(ObjLib::ListObj);
use Utils::XLS;
use Utils::Regions;
use Utils::Sys qw(
    md5int
);
use BM::Phrase;
use BM::PhraseParser;
use List::Util qw(min);

########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(
    banners_array
));

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;
#    my $proj = $self->proj;
}

########################################################
#Методы
########################################################

sub list_arrayref { return shift->banners_array }

sub number_of_banners { return $_[0]->count }

sub new_listobj { shift->banner_list(@_) }

#Получение текста из списка
sub list2text { return join( '', map {"$_"} @{ shift() }) }
sub banners2text { shift->list2text }

sub bf { return shift->proj->bf }
sub banner { return shift->bf->lbanner(@_) }
sub banner_list { return shift->bf->banner_list(@_) }
sub banners { return shift->list }

sub get_common_phrases {
    my ($self) = @_;

    my $phl = $self->phrase_list;
    $phl += $_ for map { $_->phl } @$self;

    my %h = ();
    $h{$_}++ for map { map {$_->norm_phr}  @$_ } @$phl;

    my $modellimit = @$self * 0.2;
    $modellimit = 3 if $modellimit < 3;
    my ($cmnphl, $mdlphl) = $phl->divide(sub { $h{$_->norm_phr} > $modellimit });

    return ($cmnphl, $mdlphl);
}

sub filter_phrases_by_banner {
    my ( $self ) = @_;
    return $self->bf->banner_list( [ map { $_->filter_phrases_by_banner } $self->banners ] );
}

sub _clean {
    my ( $text ) = @_;
    $text = "$text";
    #$text =~ s/\"/ /g;
    $text =~ s/^(\s+|\n+)//g;
    $text =~ s/(\s+|\n+)$//g;
    $text =~ s/\s+/ /g;
    return $text;
}

sub get_minicategs :CACHE {
    my $self = shift;

    my %cts;
    for my $bnr (@$self) {
        $cts{$_}++ for $bnr->get_minicategs;
    }

    # дальнейшее взято из BM::Categories::PagesCategories::categorize_one_line
    # очистка по иерархии
    my %clean_cts;
    for my $ct (keys %cts) {
        next if !$self->proj->categs_tree->get_minicateg_parent($ct);
        my @children = grep{$cts{$_}} $self->proj->categs_tree->get_minicateg_children($ct);
        next if scalar(@children) == 1 && $cts{$children[0]} == $cts{$ct};
        $clean_cts{$ct} = $cts{$ct};
    }
    %cts = %clean_cts;

    my @top = sort{$b->[1] <=> $a->[1]} map{[$_, $cts{$_}]} keys %cts;

    return sort map{$_->[0]} grep{2 * $_->[1] > $top[0][1]} @top;
}

sub get_hypothesis_phrases_for_categs {
    my $self = shift;
    my $proj = $self->proj;
    my @arr = ();
    for my $bn (@$self){
        #Если указан дефолтный шаблон - берём его
        if($bn->title =~ /#(.+)#/){
            push(@arr, $1);
        }
        my $tbph = $bn->title_body_phr; #Фраза текста баннера
        #Парсим подфразы
        my $prdphs = $proj->product("$tbph")->phrases;
        #$proj->dd($prd->phrases);
        push( @arr, @$prdphs );
        #Берём фразы, которые полностью входят в баннер
        #my $sphl = $bn->phl->search_subphrases_in_phrase($bn->title_body_phr);
        #push( @arr, @$sphl);
        #Берём все фразы баннера
        push( @arr, @{ $bn->phl });
        #Смотрим на пересечение фраз и текстов баннеров
        my $flt = $bn->phl->snormwordshash;
        my @w = grep { $flt->{$_} } $tbph->snormwords;
        @w = keys %{{ map {$_=>1} @w }};
        if(@w > 1){
            push(@arr, join(' ', @w));
        }
    }
    my $phl = $self->proj->phrase_list(\@arr)->snorm_pack_list;
    $phl = $phl->get_wide_filtered;
    my ($gphl, $bphl) = $phl->divide(sub {! $_->get_exact_minicategs });
    return $gphl;
}

sub fulltext {
    my ($self) =  @_;
    my $res = '';
    $res .= $_->fulltext for ($self->banners);
    return $res;
}

1;
