package BM::BannersMaker::BodyBuilder;
use strict;
use base qw(ObjLib::ProjPart);
use Scalar::Util qw(looks_like_number);
use Template;
use utf8;

my $AD_TITLE_LENGTH = 35;
my $AD_BODY_LENGTH = 81;
my $AD_LONG_BODY_LENGTH = 500;
my $BODY_LENGTH_DIFFERENCE = 1.2;
my $MIN_BODY_LENGTH = 11;
my $ALLOW_FIRST_PUNCTUATION_NUM = 15;

# метод возвращает длинну с игнорированием первых $ALLOW_FIRST_PUNCTUATION_NUM символов пунктуации
sub get_length_ignore_punctuation {
    my $text = shift;
    my $src_text_length = length($text);
    $text =~ s/[^.!,:;"'«»]//g;
    my $punctuation_len = length($text);
    $punctuation_len = $ALLOW_FIRST_PUNCTUATION_NUM if $punctuation_len > $ALLOW_FIRST_PUNCTUATION_NUM;
    return $src_text_length - $punctuation_len;
}

sub get_templates: GLOBALCACHE {
    return {
        'SMART_FLIGHTS_DOMAIN'=> 'Авиабилеты[% IF domain %] на [%domain%][% END %]',
        'SMART_BOOKING'=> 'Забронировать!',
        'SMART_HOTELS_DOMAIN'=> 'Забронировать отель [%stars%]',
        'SMART_HOTELS_BODY'=> 'Номер в [%stars%]-звездочном отеле.',
        'SMART_CLOTHES_SIZES'=> 'Размеры: [%size%].',
        'SMART_CLOTHES_CONSIST'=> 'Состав: [%size%].',
    }
}

sub get_template_toolkit: GLOBALCACHE{
    return Template->new;
}

sub text_from_body_template {
    my $self = shift;
    my $namespace = shift;
    my $args = shift // {};

    my $res;
    my $ttmp = $self->get_templates()->{$namespace};
    my $tt = get_template_toolkit();
    $tt->process(\$ttmp, $args, \$res);
    return $res;
}

sub get_body_from_use_as {
    my $self = shift;
    my $pt = shift;
    my $body = $self->proj->dse_tools->truncate_title($pt->{use_as_body}, $AD_BODY_LENGTH);
    return $self->proj->make_bs_compatible_or_empty($body);
}

sub get_long_body_from_use_as {
    my $self = shift;
    my $pt = shift;
    my $body = $self->proj->dse_tools->truncate_title($pt->{use_as_body}, $AD_LONG_BODY_LENGTH);
    return $self->proj->make_bs_compatible_or_empty($body);
}

sub get_pcode_data {
    my $self = shift;
    my $pt = shift;
    my $business_type = shift;
    my $is_body_need = shift // 1;

    my $body =  '';
    my $long_body =  '';
    my @callouts = ();
    my $domain = '';
    my $title = '';
    my $description = '';
    my $is_body_generation_completed = 0;

    if (!$is_body_need) {
        $is_body_generation_completed = 1;
        $body = '';
        $long_body = '';
    }
    elsif ($pt->{use_as_body}) {
        $body = $self->get_body_from_use_as($pt);
        $long_body = $self->get_long_body_from_use_as($pt) || $body;
        $is_body_generation_completed = $body ? 1: 0;
    }

    my $template_name;
    if ($business_type eq "retail" || $business_type eq "other" || $business_type eq "realty") {
        # заголовок и домен одинаковы для все retail
        $title = $pt->{first_title};
        $domain = $pt->{main_mirror};

        my $params = $pt->get_parsed_params();
        @callouts = split '/;/', $params if $params;
        if ($pt->ad_type() eq "clothes") {
            my $sizes = $pt->{sizes} ? join ', ', split(';', $pt->{sizes}) : "";
            my $consists = $pt->{consist} ? join ', ', split(';', $pt->{consist}) : "";
            push @callouts, $self->text_from_body_template("SMART_CLOTHES_SIZES", {size=>$sizes}) if $sizes;
            push @callouts, $self->text_from_body_template("SMART_CLOTHES_CONSIST", {size=>$consists}) if $consists;
        }
        @callouts = grep {$_} map {$self->proj->make_bs_compatible_or_empty($_)} @callouts;

        unless ($is_body_generation_completed) {
            $description = $pt->get_description();
            if ($description) {
                $description = $self->proj->phrase($description)->replace_html_spec(ret_text => 1); # подменяем символы верстки
                $description =~ s/[—–−]/-/g;                                                        # заменяем все типы дефисов на один
                $description =~ s/"([^"]+)"/«$1»/g;
            }

            if ($business_type eq "realty") {
                my $location = $pt->{location} || '';
                my $address = $pt->{address} || '';
                my $metro = $pt->{metro} || '';
                $location .= '.' if ($location && $location !~ /\.$/);
                $address .= '.' if ($address && $address !~ /\.$/);
                $metro = 'м. ' . $metro if $metro;

                if ($metro) {
                    my $body_prefix = $self->add_string_to_body({body => $location, str =>  $metro, prepend => 0});
                    $body = $self->append_description({body => $body, description => $body_prefix . ".", prepend => 1});

                    my $long_body_prefix = $self->add_string_to_body({body => $location, str => $metro, prepend => 0, len => $AD_LONG_BODY_LENGTH});
                    $long_body = $self->append_description({body => $body, description => $long_body_prefix . '.', prepend => 1, len => $AD_LONG_BODY_LENGTH});
                } else {
                    my $location_phr = $self->proj->phrase($location);
                    my $address_phr = $self->proj->phrase($address);
                    if (length($address_phr) > length($address_phr % $location_phr)) {
                        $body = $self->append_description({ body => $body, description => $address, prepend => 1 });
                        $long_body = $self->append_description({ body => $body, description => $address, prepend => 1, len => $AD_LONG_BODY_LENGTH});
                    }
                    else {
                        my $body_prefix = $self->add_string_to_body({body => $location, str => $address, prepend => 0});
                        $body = $self->append_description({body => $body, description => $body_prefix, prepend => 1});

                        my $long_body_prefix = $self->add_string_to_body({body => $location, str => $address, prepend => 0});
                        $long_body = $self->append_description({body => $body, description => $long_body_prefix, prepend => 1, len => $AD_LONG_BODY_LENGTH});
                    }
                }
                $body =~ s/^(.*)$/\u$1/;
                $long_body =~ s/^(.*)$/\u$1/;
            }
            elsif ($business_type eq "retail") {
                # склеиваем body по логике из https://st.yandex-team.ru/DYNSMART-939
                $body = $self->append_description({body => $body, description => $description, prepend => 0}); # 0 - доклеиваем к body справа
                $body = $self->add_strlist_to_body({body => $body, str_list => \@callouts, prepend => 0});
                $long_body = $self->append_description({body => $long_body, description => $description, len => $AD_LONG_BODY_LENGTH, prepend => 0}); # 0 - доклеиваем к body справа
                $long_body = $self->add_strlist_to_body({body => $long_body, str_list => \@callouts, len => $AD_LONG_BODY_LENGTH, prepend => 0});
            } else {
                $body = $self->add_strlist_to_body({body => $body, str_list => \@callouts, prepend => 1}); # 1 - доклеиваем к body слева
                $body = $self->append_description({body => $body, description => $description, prepend => 1});
                $long_body = $self->append_description({body => $long_body, description => $description, len => $AD_LONG_BODY_LENGTH, prepend => 1}); # 1 - доклеиваем к body слева
                $long_body = $self->add_strlist_to_body({body => $long_body, str_list => \@callouts, len => $AD_LONG_BODY_LENGTH, prepend => 1});
            }
        }
    } elsif ($business_type eq "auto") {
        $title = $pt->{first_title} || '';
        $domain = $pt->{main_mirror} || lc($title);
        @callouts = split(';', $pt->get_facilities());
        @callouts= grep {$_} map {$self->proj->make_bs_compatible_or_empty($_)} @callouts;

        unless ($is_body_generation_completed) {
            $body = "Узнать подробнее!";
            $body = $self->add_strlist_to_body({body => $body, str_list => \@callouts, prepend => 1}); # 1 - доклеиваем к body слева
            $long_body = $self->add_strlist_to_body({body => $long_body, str_list => \@callouts, len => $AD_LONG_BODY_LENGTH, prepend => 1}); # 1 - доклеиваем к body слева
        }
    } elsif ($business_type eq "flights") {
        my $from = $pt->{origin};
        my $to = $pt->{destination};
        if ($from && $to) {
            $title = "$from – $to";
        }
        $domain = $self->text_from_body_template("SMART_FLIGHTS_DOMAIN", {domain=>$pt->{main_mirror}});

        unless ($is_body_generation_completed) {
            my $booking = $self->text_from_body_template('SMART_BOOKING');
            $body = $self->add_string_to_body({body => $body, str => $booking});
            $long_body = $self->add_string_to_body({body => $long_body, str => $booking, len => $AD_LONG_BODY_LENGTH});
        }

    } elsif ($business_type eq "hotels") {
        @callouts = split(';', $pt->get_facilities());
        @callouts = grep {$_} map {$self->proj->make_bs_compatible_or_empty($_)} @callouts;

        my $hotelClass = $pt->get_class();
        my $location = $pt->get_location() || "";
        my $locationInTitle = 0;

        # генерируем title
        if ($pt->can("property_type")) {
            $title = $pt->property_type || "";
        } else {
            $title = "";
        }
        $title .= $pt->{first_title};
        if (get_length_ignore_punctuation("$title, $location") < $AD_TITLE_LENGTH) {
            $title .= ", $location";
            $locationInTitle =  1;
        }

        # генерируем домен
        if ($hotelClass && looks_like_number($hotelClass)) {
            my $stars = $hotelClass.'*';  # было: '★', но этот символ запрещен в Директе; из-за него все отели будут фильтроваться
            $domain = $self->text_from_body_template('SMART_HOTELS_DOMAIN', {stars=> $stars});
        }

        # генерируем body
        unless ($is_body_generation_completed) {
            my $booking = $self->text_from_body_template('SMART_BOOKING');

            $body = $self->add_string_to_body({body => $body, str => "$location."}) if (!$locationInTitle && $location);
            $long_body = $self->add_string_to_body({body => $long_body, str => "$location.", len => $AD_LONG_BODY_LENGTH}) if (!$locationInTitle && $location);

            if ($hotelClass) {
                $template_name = "SMART_HOTELS_BODY";
                my $bodyHead = $self->text_from_body_template($template_name, { stars => $hotelClass });
                $body = $self->add_string_to_body({body => $body, str =>$bodyHead});
                $long_body = $self->add_string_to_body({body => $long_body, str =>$bodyHead, len => $AD_LONG_BODY_LENGTH});
            }

            $body = $self->add_string_to_body({body => $body, str => $booking});
            $long_body = $self->add_string_to_body({body => $long_body, str => $booking, len => $AD_LONG_BODY_LENGTH});
        }
    }

    @callouts = grep {$_ and length($_) <= 25} @callouts;
    @callouts = @callouts[0..29] if @callouts>30;

    if ($long_body && $body && length($long_body) / length($body) < $BODY_LENGTH_DIFFERENCE) {
        $long_body = '';
    }

    return {
        body => $body,
        long_body => $long_body,
        callouts => \@callouts,
        domain => $domain,
        title => $title
    };
}

sub append_description {
    my $self = shift;
    my $args = shift // {};

    my $body = $args->{body} // '';
    my $description = $args->{description} // '';
    my $prepend = $args->{prepend} // '';
    my $body_max_length = $args->{len} // $AD_BODY_LENGTH;

    return $body unless $description;

    my $dots = '...';

    if (length($body) + 1 + length($description)  <= $body_max_length) {
        return $self->add_string_to_body({body => $body, str => $description, prepend => $prepend, len => $body_max_length});
    } elsif (length($body) + 1 + length($dots) < $body_max_length) {
        my $length_for_description = $body_max_length - length($body) - 1;
        my $path_of_description = $self->proj->dse_tools->truncate_title($description, $length_for_description);
        if ($path_of_description ne $dots) {
            return $self->add_string_to_body({body => $body, str => $path_of_description, prepend => $prepend, len => $body_max_length});
        }
    }
    return $body;
}

sub add_string_to_body {
    my $self = shift;
    my $args = shift // {};

    my $body = $args->{body} // '';
    my $str = $args->{str} // '';
    my $prepend = $args->{prepend} // '';
    my $length = $args->{len} // $AD_BODY_LENGTH;
    $str = $self->proj->make_bs_compatible_or_empty($str);
    return $body if !$str || (length($body) + length($str) + 1) > $length;
    if ($prepend || length($body) == 0) {
        $str = (uc substr($str, 0, 1)) . substr($str, 1); # Первый символ заглавный
    }
    return $str unless $body;

    my $str_norm = $self->proj->phrase($str)->normalize(norm => 1, join => 1);
    my $body_norm = $self->proj->phrase($body)->normalize(norm => 1, join => 1);
    if (index($body_norm, $str_norm) != -1) {
        return $body;
    }
    return "$str $body" if ($prepend);
    return "$body $str";
}

sub add_strlist_to_body {
    my $self = shift;
    my $args = shift // {};

    my $body = $args->{body} // '';
    my $str_list = $args->{str_list} // [];
    my $prepend = $args->{prepend} // '';
    my $length = $args->{len} // $AD_BODY_LENGTH;

    for my $el (@{$str_list}) {
        if ($el) {
            $el = (uc substr($el, 0, 1)) . substr($el, 1); # Первый символ заглавный
            $el .= '.' if !($el =~ /\.$/); # Точка в конце

            if (length($body) + length($el) + 1 <= $length) {
                $body = $self->add_string_to_body({body => $body, str => $el, prepend => $prepend});
            }
        }
    }
    return $body;
}
1;
