package BM::BannersMaker::FeedDataSourceTravelBooking;

use utf8;
use open ':utf8';

use base qw(BM::BannersMaker::FeedDataSource);

use Data::Dumper;
use Encode qw{ _utf8_on _utf8_off };

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
));


sub init {
    my ($self) = @_;

    ($self->{tskvmap}, $self->{additional_data}, $self->{offer_tag}) = $self->proj->fdm->travel_booking_mapping;
    $self->SUPER::init;
}

#####
# Перегруженный метод для букинга
#
sub tskv2arr {
    my ($self, $tskv_text ) = @_;
    return [] unless $tskv_text;
    my @res = ();
    for my $line ( ( split /\n/, $tskv_text ) ){
        my %hline = ();
        $hline{OfferID} = $1 if $line =~ /\tid\=(.+?)\t/;
        $hline{name} = $1 if $line =~ /\tlisting\-\>name\=(.+?)\t/;
        $hline{Address} = $1 if $line =~ /addr1\tcomponent\=(.+?)\t/;
        $hline{location} = $1 if $line =~ /ru\tcomponent\:name\=city\tcomponent\=(.+?)\t/;
        $hline{country} = $self->_FUNC_COUNTRY_BY_2CODE_($1) if $line =~ /\tcountry\=(.+?)\t/;
        $hline{url} = $1 if $line =~ /lang=ru\tlink\=(.+?)\t/;
        $hline{picture} = $1 if $line =~ /main\timage\:url\=(.+?)\t/;
        $hline{type} = $1 if $line =~ /category\:type\=(.+?)\t/;
        $hline{class} = $1 if $line =~ /class\tattr\=(.+?)\t/;
        $hline{product_type} = "Отели, гостиницы";
        push @res, \%hline; 
    }
    return \@res;
}

1;
