package BM::BannersMaker::Options;
use strict;
use warnings;
use utf8;

use Utils::LightCommon;

use base qw(Exporter);

my $dirs = $Utils::LightCommon::dirs;
my $BM_MDB_HOSTS = ['c-mdbdl4e1lh1lqge3t0h3.rw.db.yandex.net', 'sas-6ant1ybleuvfhsdy.db.yandex.net', 'vla-gj2vrppbvhaosczx.db.yandex.net'];

my $BM_MDB_PASSPATH = $dirs->{secrets}. "/passwords/mysql-prod-mdb_password";

my $options = {
    mirror_data => {
        domain_to_orig => {
            # SUPBL-1683 - radissonhotels.com
            'www.radissonhotels.com' => 'radissonhotels.com',
            'radissonhotels.com' => 'radissonhotels.com',
        },
        orig_to_mirror => {
            # SUPBL-1683 - radissonhotels.com
            'radissonhotels.com' => 'radissonhotels.com',
        },
        domain_to_id => {
        },
    },

    banned_domains => {
        'svetlov.com'     => 1,
        'designstore.ru'  => 1,
        'zeodetox.ru'     => 1,
        'garshinka.ru'    => 1,
        'v-meha.ru'       => 1,
        'tsvet-ryad.ru'   => 1,
        'cantra.ru'       => 1,
        'asg-mining.ru'   => 1, # cpa fraud
    },

    use_product_page_visit_orderids => [
        17635067,  # оставляем сберу только офферные фразы
        22091136,  # https://st.yandex-team.ru/SUPBL-448, запрет текстовых привязок для ретаргетинга
    ], # для остальных заказов поведение target_funnel='product_page_visit' как для 'same_products'

    # для отдельных клиентов хотим банить симдистансы
    # единый конфиг для смартов и динамиков
    simdistance_filter => {
        ban_by_task_id    => {
            # TODO (danila-eremin) DYNSMART-1538 delete later 700070
            '27492669_7127970517' => [700050, 700070],  # https://st.yandex-team.ru/SUPBL-844
            '29288132_7364906182' => [700001],  # https://st.yandex-team.ru/SUPBL-1419
            '161455929_72057604701255727' => [700001],  # https://st.yandex-team.ru/SUPBL-2011

            # dyn
            # perf
        },
        ban_by_order_id  => {
            # TODO (danila-eremin) DYNSMART-1538 delete later 700070, 700333
            25770442 => [700050, 700070],  # https://st.yandex-team.ru/SUPBL-848
            27414203 => [700050, 700070],  # https://st.yandex-team.ru/SUPBL-849
            25819134 => [700050, 700070],  # https://st.yandex-team.ru/SUPBL-849
            28831384 => [700050],  # https://st.yandex-team.ru/SUPBL-954
            16547550 => [700333, 700070],
            16914031 => [700333],
            16917665 => [700333, 700070],
            28129283 => [700333],           # https://st.yandex-team.ru/SUPBL-1528
            # dyn
            # perf
        },
    },

    # для отдельных клиентов хотим ограничивать кол-во офферов на таску
    # ключ директовый ClientID
    client_offers_in_task_limit => {
        # Али принёс фиды 900к
        94921826 => 500_000,
        95756147 => 500_000,
        94921877 => 500_000,
        94921851 => 500_000,
        94921241 => 500_000,
        94958654 => 500_000,
        94921310 => 500_000,
        94921902 => 500_000,
        94921165 => 500_000,
        94921924 => 500_000,
    },

    # для отдельных клиентов хотим банить заголвки по источникам (title_source)
    # order => {title_source => 1}
    order_banned_title_source => {
        26952157  => { dse => 1 },  # divan.ru
        32739202  => { dse => 1 },  # divan.ru
        157614217 => { dse => 1 },  # eda1.ru (SUPBL-1428)
        161138467 => { dse => 1 },  # esh-derevenskoe.ru (SUPBL-1892)
        162432389 => { dse => 1 },  # esh-derevenskoe.ru (SUPBL-1892)
        162432601 => { dse => 1 },  # esh-derevenskoe.ru (SUPBL-1892)
        162436659 => { dse => 1 },  # esh-derevenskoe.ru (SUPBL-1892)
        162436760 => { dse => 1 },  # esh-derevenskoe.ru (SUPBL-1892)
        159757429 => { dse => 1 },  # kristall-shop.ru (SUPBL-2339)
    },

    currency_re => join('|',
        'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AUD', 'AWG', 'AZN',
        'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV',
        'BRL', 'BSD', 'BTN', 'BWP', 'BYN', 'BZD', 'CAD', 'CDF', 'CHE', 'CHF',
        'CHW', 'CLF', 'CLP', 'CNY', 'COP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE',
        'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'EUR', 'FJD',
        'FKP', 'GBP', 'GEL', 'GHS', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD',
        'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'INR', 'IQD', 'IRR', 'ISK',
        'JMD', 'JOD', 'JPY', 'KES', 'KGS', 'KHR', 'KMF', 'KPW', 'KRW', 'KWD',
        'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'LTL', 'LYD', 'MAD',
        'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRU', 'MUR', 'MVR', 'MWK',
        'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD',
        'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON',
        'RSD', 'RUB', 'RUR', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK', 'SGD',
        'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STN', 'SVC', 'SYP', 'SZL', 'THB',
        'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX',
        'USD', 'USN', 'USS', 'UYI', 'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST',
        'XAF', 'XAG', 'XAU', 'XBA', 'XBB', 'XBC', 'XBD', 'XCD', 'XDR', 'XFU',
        'XOF', 'XPD', 'XPF', 'XPT', 'XSU', 'XTS', 'XUA', 'XXX', 'YER', 'ZAR',
        'ZMW', 'ZWL'
    ),
    # domain => {title_source => 1}
    domain_banned_title_source => {
        'renault-petrovskiy-spb.ru' => {dse => 1},
        'lamoda.ru' => { dse => 1 }, # (SUPBL-2608)
        'mrdoors.ru' => { dse => 1 }, # (SUPBL-2645)
    },

    # в ДО обрабатываем таск не чаще, чем раз в 24 часа, тут список исключений на домены
    dyn_custom_cycle_time_domains => {
        'www.mvideo.ru' => 6 * 3600,  # DYNSMART-1158
        'www.komus.ru' => 3600, # SUPBL-1179
    },

    # Список OrderID с увеличенным таймаутом атомарных дин тасок
    dyn_timeout_hours_by_order_id => {
        8593839 => 80, 14958886 => 80,
        19477113 => 120,  # booking.com - см. https://st.yandex-team.ru/SUPBL-338

        8443152 => 100,  # litres.ru - см. https://st.yandex-team.ru/SUPBL-560
        27207545 => 120, # iherb - см. https://st.yandex-team.ru/SUPBL-746
        17240807 => 110, # ru.aliexpress.com (alibaba) - см. DYNSMART-1051
    },
    wide_phrase_search_count_limit => 1000,

    # Домены, у которых при матчинге по урлам не будут учитываться get-параметры
    # TODO: сделать единую настройку для ДО и Смарта через интерфейс
    domains_remove_get_params => {
        dyn => {
            'booking.com'              => 1,
            'www.booking.com'          => 1,
            'feeds-yandex.booking.com' => 1,
            'mvideo.ru'                => 1,
            'www.mvideo.ru'            => 1,
            'topshouse.ru'             => 1,
            'www.topshouse.ru'         => 1,
            'ru.iherb.com'             => 1,
            'www.bonprix.ru'           => 1,
            'zakupka.com'              => 1,
        },

        perf => {
            'rabota.ru'                => 1,
            'www.rabota.ru'            => 1,
            'sferait.info'             => 1,
            'www.bonprix.ru'           => 1,
        }
    },


    #домены *второго* уровня, для которых отключена нативная генерация
    dyn_banners_dse_only => {
        'booking.com'       => 1,
        'ivi.ru'            => 1,
        'shutterstock.com'  => 1,
        'sbermegamarket.ru' => 1,
    },

    bannerland_db_inf => {
        hosts => $BM_MDB_HOSTS,
        database => 'bannerland',
        port => 3306,
        password_path=>$BM_MDB_PASSPATH,
        user => 'bannerland',
        utf8 => 1,
    },

    # маппинг minicategs -> product_type, увеличивающий масштаб категоризации
    dynbanners_categs_mapping => $dirs->{dicts} . "dynbanners_categs_mapping",

    trie_matcher => {
        src_path => $dirs->{dicts} . '/trie_sources/',
        src_streets_path   => $dirs->{dicts} . '/trie_sources/dict_streets_trie_source',
        src_districts_path => $dirs->{dicts} . '/trie_sources/dict_districts_trie_source',
        streets_terminal   => 'T_STREET',
        districts_terminal => 'T_DISTRICT',
    },

    #Динамические и перфоманс баннеры

    hosts_for_bannerland => "https://qabs-bamboo.yandex-team.ru/orchman/hosts-for-bannerland.json",

    dyn_banners_dirs => {
        temp_dir        =>  $dirs->{temp}.'/dyn_banners',
        work_dir        =>  $dirs->{work}.'/dyn_banners',
    },
    perf_banners_dirs => {
        temp_dir        =>  $dirs->{temp}.'/perf_banners',
        work_dir        =>  $dirs->{work}.'/perf_banners',
    },

    dyn_export_offers_dir => $dirs->{temp}.'/dyn_export_offers',
    perf_export_offers_dir => $dirs->{temp}.'/perf_export_offers',

    dyn_svn_revision_file  => $dirs->{scripts}.'/dyn-smart-banners/dyn-svn_revision.json',
    perf_svn_revision_file => $dirs->{scripts}.'/dyn-smart-banners/perf-svn_revision.json',

    # эти опции перенесены в scripts/pylib/bm/bannerland_options.py:
    # PerfSources, DynSources
    # DSE_Banners_params

    # статистика bssoap по ДО и Смартам
    dynstat => $dirs->{'work'}.'/dynstat',
    perfstat => $dirs->{'work'}.'/perfstat',

    # данные для банщика
    dyn_stat_params => {
        file_bad_dyn_phrases => $dirs->{'work'}.'/dynstat/bad_dyn_phrases',
    },

    # Поля для каждого типа вида в соответствии с документацией
    feed_fields_by_type => {
        AutoRu => {
            main_format => [
                "unique_id", "vin", "url", "images", "images:image", "price", "currency", "mark_id", "folder_id", "modification_id",
                "body_type", "year", "availability", "description",
            ],
        },
        # Документация Google https://support.google.com/google-ads/answer/6053288?hl=en
        GoogleCustom => {
            main_format   => [
                "Destination URL", "Final URL", "ID", "ID2", "Image URL", "Item Category", "Item description", "Item title", "Price", "Sale Price", "Contextual keywords",
            ],
            custom_fields => ["phrases",],
        },
        GoogleFlights => {
            main_format => [
                "Destination ID", "Destination URL", "Destination name", "Final URL", "Flight description", "Flight price", "Flight sale price", "Image URL",
                "Origin ID", "Origin name", "Contextual keywords",
            ],
            custom_fields => ["phrases",],
        },
        GoogleHotels => {
            main_format => [
                "Destination URL", "Description", "Destination name", "Final URL", "Image URL", "Price", "Property ID",
                "Property name", "Star rating", "Contextual keywords", "Sale price",
            ],
            custom_fields => ["phrases",],
            customer_mistakes => ["Score", "Max score", "Facilities",]
        },
        # Документация GoogleMerchant https://support.google.com/merchants/answer/7052112?visit_id=637092414338809113-2332316674&rd=1
        GoogleMerchant => {
            # xml
            main_format       => [ "g:id", "g:title", "g:description", "g:availability", "g:link", "g:image_link", "g:price", "g:sale_price", "g:brand", "g:product_type",],
            custom_fields => ["phrases",],
            # csv
            secondary_format => ["id", "title", "description", "availability", "link", "image_link", "price", "sale_price", "brand", "product_type",]
        },
        GoogleTravel => {
            main_format   => [
                "Final URL", "Destination URL", "Property ID", "Destination name", "Image URL", "Star Rating", "Price",
                "Rating", "Country", "Facilities", "Contextual keywords",  "Sale price", "Destination ID", "Title",
            ],
            custom_fields => ["phrases",],
        },
        TravelBooking => {
            main_format   => [
                "Country", "Destination Name", "Facilities", "Final URL", "Image URL", "Property ID", "Property Name", "Property Type", "Rating"
            ],
        },
        # Документация Yandex https://yandex.ru/support/direct/smart-banners/feeds.html
        YandexCustom => {
            main_format => [ "Currency", "Description", "ID", "Image", "Old Price", "Price", "Title", "URL" ],
            custom_fields => ["phrases",],
        },
        YandexMarket => {
            # YandexMarket
            main_format      => [
                "id", "type", "available", "url", "picture", "price", "currencyId", "model", "vendor", "vendorCode", "description", "typePrefix", "categoryId",
                "market_category", "store", "pickup", "delivery", "oldprice", "sales_notes", "manufacturer_warranty", "country_of_origin", "adult", "age", "downloadable",
            ],
            # YandexMarket_light
            secondary_format => [
                "id", "available", "name", "url", "picture", "price", "currencyId", "model", "vendor", "vendorCode", "description", "categoryId", "market_category", "store", "pickup",
                "delivery", "oldprice", "sales_notes", "manufacturer_warranty", "country_of_origin", "adult", "age", "downloadable"
            ],
        },
        DatacampYandexMarket => { # need only for case normalize UseAsName and UseAsBody
            # YandexMarket
            main_format      => [
                "id", "type", "available", "url", "picture", "price", "currencyId", "model", "vendor", "vendorCode", "description", "typePrefix", "categoryId",
                "market_category", "store", "pickup", "delivery", "oldprice", "sales_notes", "manufacturer_warranty", "country_of_origin", "adult", "age", "downloadable",
            ],
            # YandexMarket_light
            secondary_format => [
                "id", "available", "name", "url", "picture", "price", "currencyId", "model", "vendor", "vendorCode", "description", "categoryId", "market_category", "store", "pickup",
                "delivery", "oldprice", "sales_notes", "manufacturer_warranty", "country_of_origin", "adult", "age", "downloadable"
            ],
        },
        YandexRealty => {
            # через двоеточие указываем вложенные теги
            main_format => [
                "internal-id", "type", "property-type", "category", "url", "creation-date",
                "location", "location:country", "location:locality-name", "location:sub-locality-name", "location:address", "location:metro:name", "location:metro:time-on-foot", "location:metro:time-on-transport",
                "price:value", "price:currency", "sales-agent", "sales-agent:organization", "floor", "floors-total", "area:value", "area:unit", "building-name", "image",
            ],
        },
    },

    # Моно-тематики: тематики, которые взаимно однозначно мапятся в тип фида.
    # Product-ам из типов фидов, не мапящихся в тематику, не может быть присвоена эта тематика: работает фильтр по категориям
    # Product-ам из типов фидов, которые мапятся, жестко присваивается соответствующая тематика
    # категории берутся по ключам в bannerland_categs
    # product_type проставляется первой категорией из списка по ключу
    bannerland_mono_feed_types => {
        AutoRu         => 'cars',
        YandexRealty   => 'realty',
        GoogleFlights  => 'aviatickets',
        GoogleHotels   => 'hotel',
        GoogleTravel   => 'travel',
    },

    # категории для стартера классов-наследников Product по тематикам
    bannerland_categs => {
        clothes            =>   [
                                    'Одежда',
                                    'Одежда, обувь и аксессуары',
                                ],
        hotel          =>       [
                                    'Отели, гостиницы',
                                ],
        furniture       =>      [
                                    'Мебель',
                                    'Мебель для дома',
                                ],
        cars       =>           [
                                    'Автомобили',
                                    'Грузовые машины',
                                ],
        childrens_goods  =>      [
                                    'Товары для детей',
                                    'Игрушки',
                                ],
        building_materials =>   [
                                    'Строительные материалы',
                                ],
        realty =>               [
                                    'Недвижимость',
                                ],

        sports =>               [
                                    'Спортивные товары',
                                ],
        tires_disks     =>      [
                                    'Автомобильные шины',
                                    'Колесные диски',
                                ],
        beauty_health   =>      [
                                    'Товары для красоты и здоровья',
                                ],
        auto_accessories   =>   [
                                    'Запчасти для авто- и мототехники',
                                    'Аксессуары для автомобилей',
                                ],
        aviatickets     =>      [
                                    'Авиабилеты'
                                ],
        games           =>      [
                                    'Игры'
                                ],
        promocodes      =>      [
                                    'Promocodes',
                                ],
        dse             =>      [
                                    'dse',
        ],
        external        =>      [
                                    '__external__',
                                ],
        travel          =>      [
                                    'Путешествия'
                                ],
        books           =>      [
                                    'Книги'
                                ],
    },

    # модели маркета
    subphraser_market => {
        init_data_file          => $dirs->{temp}."/subphraser_market_data",
    },

    # число воркеров на групповую динамическую таску для крупных клиентов ДО
    dyn_domain_workers_number => {
        'russian.alibaba.com'        => 10,
        'ru.aliexpress.com'          => 6,
        'storage-int.mds.yandex.net' => 8,
        'goods.ru'                   => 5,
        'citilink.ru'                => 10,
        'price41.procontext.ru'      => 3,
        'mrkt21.procontext.ru'       => 3,
        'mrkt22.procontext.ru'       => 3,
        'vseinstrumenti.ru'          => 12, # fix banners delay IRTDUTY-128
        'sbermarket.ru'              => 5,
        'sbermegamarket.ru'          => 10,
        'hoff.ru'                    => 10,
        'bestmebelshop.ru'           => 5,
        'afonya-spb.ru'              => 3,
        'randewoo.ru'                => 3,

        # Increase workers for BSSERVER-19269
        '100sp.ru' => 3,
        'algroup-spb.ru' => 6, # fix banners delay IRTDUTY-128
        'aquaprom-sz.ru' => 3,
        'asseenontv.by' => 3,
        'asutpro.ru' => 3,
        'atyraucable.kz' => 3,
        'avtokosmetics.ru' => 3,
        'beatberry.ru' => 3,
        'bestblades.ru' => 3,
        'biomedgroup.ru' => 3,
        'blumart.ru' => 3,
        'bonbon.com.ru' => 3,
        'book24.ru' => 5, # fix banners delay IRTDUTY-128
        'center-vologda.ru' => 3,
        'centrsfp.ru' => 3,
        'cyber-pulse.online' => 3,
        'daishin-rus.su' => 3,
        'dv-expert.org' => 6, # fix banners delay IRTDUTY-128
        'euro-diski.ru' => 3, # fix banners delay IRTDUTY-128
        'expocar.biz' => 3,
        'eldorado.ru' => 3,
        'fmg-parts.ru' => 3,
        'fotoskupka.ru' => 3,
        'gentelement.ru' => 3,
        'gracy.ru' => 3,
        'gvendelin.ru' => 3,
        'hands-master.com' => 3,
        'hit-vanna.ru' => 3,
        'hiwatch-msk.ru' => 3,
        'jobeka.com' => 3,
        'jobsora.com' => 3,
        'karusel-ka.ru' => 3,
        'komus.ru' => 3,
        'kraski.ru' => 3,
        'krasotkapro.ru' => 3, # fix banners delay IRTDUTY-128
        'krym-lakrostgeo.ru' => 3,
        'leomax.ru' => 3,
        'level.travel' => 3,
        'linia-market.ru' => 3,
        'machineryline-kz.com' => 3,
        'machineryline.com.ua' => 6, # fix banners delay IRTDUTY-128
        'machineryline.ru' => 6, # fix banners delay IRTDUTY-128
        'maxipro.ru' => 3, # fix banners delay IRTDUTY-128
        'mebelion.ru' => 3, # fix banners delay IRTDUTY-128
        'megafon.ru' => 3,
        'moedelo.org' => 3,
        'mvideo.ru' => 10, # fix banners delay IRTDUTY-128
        'oe.kz' => 3,
        'ozon.ru' => 10, # fix banners delay IRTDUTY-128
        'petrovich.market' => 3,
        'pulsar-msk.ru' => 3,
        'ranjo.ru' => 3,
        'repetitors.info' => 3,
        'satu.kz' => 3,
        'sborka-kuhni.pro' => 3,
        'sdvor.com' => 3,
        'shopenko.pro' => 3,
        'steel-pro.ru' => 3, # fix banners delay IRTDUTY-128
        'stenmat.ru' => 3,
        'stolplit.ru' => 3, # fix banners delay IRTDUTY-128
        'svoy-elektrik.ru' => 3,
        'svyaznoy.ru' => 3,
        'technopark.ru' => 5, # fix banners delay IRTDUTY-128
        'techport.ru' => 4, # fix banners delay IRTDUTY-128
        'teplomash.su' => 3,
        'termokit.ru' => 6, # fix banners delay IRTDUTY-128
        'tiu.ru' => 3,
        'topcomputer.ru' => 3,
        'toy.ru' => 3,
        'trustdoit.ru' => 3,
        'utkonos.ru' => 6, # fix banners delay IRTDUTY-128
        'vzyalstiralku.com' => 3,
    },

    #
    # Тесты
    #

    # конфиг для тестирования генерации по фидам
    tests_banners_generation => {
        thematics => [ 'auto_accessories', 'beauty_health',
                       'building_materials', 'cars', 'children_goods', 'furniture', 'games', 'hotels',
                       'realty', 'sports', 'tires_disks', 'wear' ], #TODO 'aviasales',
        formats => ['xml', 'csv', 'tskv', 'xls', 'xlsx'],
        bmapi_url => 'http://bmapi.yandex.ru/fcgi-bin/?cmd=get_feed&feed_path=',
        bmapi_yml2directinf_simple_url => 'http://bmapi.yandex.ru/fcgi-bin/?cmd=yml2directinf',
        bmapi_yml2directinf_url => 'http://bmapi.yandex.ru/fcgi-bin/?business_type=retail&cmd=yml2directinf&max_file_size=536870912&max_file_size_type=bytes&url=',
    },

    # конфиг для тестирования маппинга фидов
    # в массивах - поля, которые нужно проверять на равенство с эталоном
    test_feed_mapping => {
        'AutoRu' => [   qw(vin OfferID unique_id currency currencyId folder_id model mark_id vendor images picture additional_data) ],
        'GoogleFlights' => ["Destination ID", "OfferID", "Origin name", "Origin Name", "Origin ID", "Origin Name", "Destination Name", "Destination name", "name", "origin", "location", "destination", "url", "Final URL", "Destination URL", "Image URL", "picture", "Flight price", "currencyId", "product_type", "additional_data"],
        'GoogleHotels' => [ "product_type", "Property name", "Property Name", "name", "Final URL", "Destination URL", "url", "Property ID", "OfferID", "Destination name", "Destination Name", "location", "Image URL", "picture", "Star rating", "Star Rating", "class", "Price", "price", "currencyId"],
        'GoogleMerchant' => [   "g:id", "OfferID", "g:title", "title", "name", "g:link", "link", "url", "g:image_link", "picture", "g:price", "price", "currencyId", "g:brand", "vendor", "product_type", "country" , "currencyId"],
        'YandexRealty' => [     qw(area:value area:unit rooms location:metro:name building-name name internal-id OfferID location:locality-name location location:sub-locality-name sub_location image picture price:value price price:currency currencyId product_type location:address address location:metro:name metro location:metro:time-on-foot time-on-foot location:metro:time-on-transport time-on-transport area:value area additional_data) ],
    },

    test_required_fields => [qw { GoogleFlights YandexRealty AutoRu }],

    test_filters => {
        file => 'test_data',
        empty_filter => {
            filter => { 111 => {}, },
        },
        nonempty_filter => {
            filter => { 111 => {
                'url NOT like' =>   [
                                        'http://trade-in.tehno-temp.ru/',
                                    ],
                }, },
        },
    },

    # хеш соответствия id региона и наименований его валют
    # Используется, когда клиент не указывает валюту самостоятельно и мы пробуем сделать это за него (по георегиону).
    # Использовался ранее для проверки строгого соответствия валюты и региона в смартах, но позже отказались от этого (см. SUPBL-2427).
    strict_geo_currency => {
        225 => {"country_name" => "Russia", "currencies" => {"RUR" => 1, "RUB" => 1} },
        159 => {"country_name" => "Kazakhstan", "currencies" => {"KZT" => 1} },
        149 => {"country_name" => "Belarus", "currencies" => {"BYN" => 1} },
        983 => {"country_name" => "Turkey", "currencies" => {"TRY" => 1, "TL" => 1} },
        102 => {"country_name" => "United Kingdom", "currencies" => {"GBP" => 1} },
    },

    # ограничиваем кол-во картинок DYNSMART-1014
    max_feed_images => 20,

    # Кастомные куки при скачивании урлов для заданных доменов (например, для проброса геокуки)
    custom_cookies => [
        {   # SUPBL-1220
            domain => "korablik.ru",
            cookie_key => "BITRIX_SM_USER_CITY_ID",
            cookie_value => 1,
            path => "/",
        },
    ],
};

sub get_options {
    return $options;
}

1;
