package BM::BannersMaker::ProductAviaTickets;
use utf8;
use strict;

use base qw(BM::BannersMaker::Product);
use utf8;
use Data::Dumper;

my @offer_fields = qw{name url location picture price currencyId origin destination offerfilters
                     images additional_data bad_flags
                     custom_phrases merge_key};

our $dict_city_name_ru2en;
our $dict_city_name_en2ru;

sub init {
    my ($self) = @_;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields, $self->get_common_offer_fields;
    }
    $self->class_init(proj => $self->proj);
}

sub class_init :RUN_ONCE {
    my $class = shift;
    my %par = @_;
    my $proj = $par{proj};

    # грузим словарь названий городов на русском и английском
    $dict_city_name_ru2en = {};
    $dict_city_name_en2ru = {};
    for my $line ($proj->file($proj->options->{dicts}.'dict_city_names_ru_en')->lines) {
        chomp $line;
        my ($rus, $eng) = map { lc $_ } split("\t", $line);
        $dict_city_name_ru2en->{$rus} = $eng;
        $dict_city_name_en2ru->{$eng} = $rus;
    }
}


sub ad_type {
    return 'flights';
}

sub match_type {
    return 'norm';
}

sub parse :CACHE {
	my ($self) = @_;
	my $h = {};
    $h->{$_} = $self->{$_} for @offer_fields;
    $h->{add_words} = '[Билеты:Авиабилеты:Самолет:Рейс:Авиарейс:Перелет:Трансфер:Путешествие:Полететь:Полет:Авиакомпания:Авиа:Слетать:Расписание:Прямой:Аэрофлот:Лететь:Авиаперелет]';

    # https://st.yandex-team.ru/DYNSMART-31, города на русском и английском
    if ($h->{origin} && $h->{destination}) {
        if ($h->{origin} =~ m/a-z/i) {
            if ($dict_city_name_en2ru->{lc $h->{origin}} && $dict_city_name_en2ru->{lc $h->{destination}}) {
                $h->{destination_2} = $dict_city_name_en2ru->{lc $h->{destination}};
                $h->{location_2} = $dict_city_name_en2ru->{lc $h->{origin}} .' '. $h->{destination_2};
            }
        } else {
            if ($dict_city_name_ru2en->{lc $h->{origin}} && $dict_city_name_ru2en->{lc $h->{destination}}) {
                $h->{destination_2} = $dict_city_name_ru2en->{lc $h->{destination}};
                $h->{location_2} = $dict_city_name_ru2en->{lc $h->{origin}} .' '. $h->{destination_2};
            }
        }
    }
    return $h;
}

sub dyn_templates_text :GLOBALCACHE {
	return "
		[location/location_2] {___MULT_PHRASE} {_SAVE_ORDER} {_LC} => <Авиабилеты> name, name
		add_words [location/location_2] {___MULT_PHRASE} {_SAVE_ORDER_1} {_LC} => <Авиабилеты> name, name
		add_words <+в> [destination/destination_2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} => <Авиабилеты.> destination, <Билеты.> destination
		add_words <+до> [destination/destination_2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} => <Авиабилеты.> destination, <Билеты.> destination
	";
}

sub perf_templates_text :GLOBALCACHE {
    my $self = shift;
    return $self->dyn_templates_text;
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        # get_wide_filtered                       flights
        get_search_filtered50k                  flights
        # pack_phr_lite                           flights
        # pack_list_safe                          flights
        set_exclamations_before_stops_safe      flights
        set_exclamations_before_bsstops         flights
        # norm_phrase_list_safe                   flights
        add_minus_words_flights                 flights
        replace_exclamations_with_pluses        flights
    ';
    return @res;
}

sub perf_banners_single {
    my ($self, %params) = @_;
    # первый попавшийся баннер из сгенерившихся
    my ($arr) = $self->banners_data(
        templates_text => $self->perf_templates_text,
        methods_arr => [ 'pack_list', ],
        max_count => 1,
        title_template_type => 'single',
        assert_no_rpc => 1,
        %params,  # ctx
    );

    $arr = $self->single_banner_default('perf', %params) unless @$arr;
    return @$arr ? [ $arr->[0] ] : [];
}

1;
