use strict;
use utf8;
use warnings;
package BM::BannersMaker::ProductBeautyHealth;

use base qw(BM::BannersMaker::Product);
use Utils::Array;
use Data::Dumper;
use List::Util qw(min max);

__PACKAGE__->mk_accessors(qw(
    type
    brand
));

my @offer_fields = qw(model);

sub get_offer_fields {
    return @offer_fields;
}

sub init {
    my ($self) = @_;
    $self->SUPER::init;
    my $data = $self->{data}; 
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

########################################################
#Доступ к полям
########################################################

sub ad_type {
    return 'beauty_health';
}

sub match_type {
    return 'norm';
}

sub txtsource :CACHE {
    my ($self) = @_;
    my $txtsource = $self->SUPER::txtsource;
    return $txtsource unless $txtsource;

    $txtsource =~ s/\bд\/окр\.?\b/ для окрашивания /i;
    $txtsource =~ s/\bд\/([а-яё]{3,})\b/ для $1 /ig; #Лак д/волос

    my $brand = $self->vendor || '';
    $brand =~ s/\(.*?\)/ /ig;
    $brand =~ s/\s+/ /g;
    $brand =~ s/(^\s+|\s+$)//g;

    #добавляем vendor в txtsource
    if ($txtsource =~ /[a-z]/i and $brand =~ /^[a-z]+$/i and $txtsource !~ /\Q$brand\E/i) {
        $txtsource = "$brand, $txtsource";
    }

    $txtsource =~ s/\s+/ /g;
    $txtsource =~ s/(^\s+|\s+$)//g;
    return $txtsource;
}


sub parse :CACHE {
    my ($self) = @_;
    my $dbg = 0;

    my $h = $self->SUPER::parse;
    print STDERR "h: \n", Dumper($h) if $dbg;

    my $txtsource = $self->txtsource || '';
    print STDERR "txtsource: $txtsource\n" if $dbg;

    $h->{$_} ||= '' for qw(model type brand);

    my $rest = $txtsource;
    $rest =~ s/[,;\(\)]/ /g;


    #проверяем поля найденные родительским parse
    ($rest, my $values) = $self->check_values($rest, {map {$_ => $h->{$_}} qw(type model vol brand)}, $dbg);
    $h->{$_} = $values->{$_} for grep {defined $values->{$_}} qw(type model vol brand sex other_type);

    my $brand_h = $self->get_brand([$h->{brand}, $rest, $self->{vendor}], $dbg);
    $h->{$_} = $brand_h->{$_} for grep {$brand_h->{$_}} qw(brand country_adj);
    $h->{brand} =~ s/\((.*)\)/ /;
    delete $h->{brand} if ($self->proj->phrase($h->{brand})->norm_phr eq '');
   

    #ищем в txtsource поля body_part skin_type cosmetics_property
    ($rest, my $body_part_h) = $self->get_body_part($rest, $h->{type}, $dbg);
    $h->{$_} = $body_part_h->{$_} for grep {$body_part_h->{$_}} qw(body_part skin_type);

    ($rest, my $cosmetics_property) = $self->get_cosmetics_property($rest, $dbg);


    #ищем в description поле cosmetics_property
    if (my $description = $self->{description}) {
        ($description, my $cosmetics_property_from_description) = $self->get_cosmetics_property($description, $dbg);
        my $seen = {map {lc($_) => 1} @$cosmetics_property};
        push @$cosmetics_property, grep {$_ and !$seen->{lc($_)}} @$cosmetics_property_from_description;
    }


    #ищем в params поля age sex body_part skin_type cosmetics_property
    if ($self->{params}) {
        my $params = $self->get_params($self->{params}, $h->{type}, $cosmetics_property, $dbg);
        $h->{$_} = $params->{$_} for grep {!$h->{$_} and $params->{$_}} qw(age sex body_part skin_type);
        $h->{type} = $params->{type} if $params->{type};
    }


    #вырезаем из type найденные поля, чтобы получить short_type
    if ($h->{type}) {
        my $types = $self->get_types({map {$_ => $h->{$_}} qw(type skin_type body_part brand)}, $cosmetics_property, $dbg);
        $h->{$_} = $types->{$_} for qw(type short_type);
        $h->{other_type} = $types->{other_type} if $types->{other_type};
    }

    #объединяем найденные значения @$cosmetics_property в [:::]
    if (@$cosmetics_property) {
        $h->{cosmetics_property} = $self->get_cosmetics_property_template($cosmetics_property, $dbg);
    }

    #вырезаем из model найденные поля
    if ($h->{model}) {
        $h->{model} = $self->clear_model($h->{model}, [$h->{color}, $h->{brand}, @$cosmetics_property]);
    }



    foreach my $field (grep {$h->{$_}} keys %$h) {
        $h->{$field} =~ s/\s+/ /g;
        $h->{$field} =~ s/(^\s+|\s+$)//g;
    }
    delete $h->{model} if length($h->{model}) < 2; # режем однобуквенные модели
    delete $h->{$_} for grep {!$h->{$_}} keys %$h;

    print STDERR join('', map {"stat: $_: $h->{$_}\n"} sort grep {$_ !~ /^(src|class)$/} keys %$h) if $dbg;
    print STDERR Dumper(['h:', $h]) if $dbg;
    return $h;
}


sub check_values {
    my ($self, $text, $res, $dbg) = @_;

    #дух -> духи, тень -> тени
    if ($text =~ s/(?:^|\s+)(парфюмерная|парфюмированная|туалетная)\s+(вода)(?=\s+|$)/ /i) {
        $res->{type} = "$1 $2";
        $res->{other_type} = "духи";
    } elsif ($text =~ s/(?:^|\s+)(духи)(?=\s+|$)/ /i) {
        $res->{type} = "$1";
    } elsif ($text =~ s/(?:^|\s+)(тени)(?=\s+|$)/ /i) {
        $res->{type} =~ s/(?:^|\s+)(тень)(?=\s+|$)/ тени /i;
    } elsif ($text =~ s/\b((?:корректирующее\s+|утягивающее\s+)+белье)\b/ /i) {
        $res->{type} = $1;
    }
    $res->{type} = '' if lc($res->{type}) eq 'вес';

    if ($res->{type} =~ /\b(снятия)\s*$/i and $text =~ /$1\s+(лака|макияжа|гель-лака|шеллака|биогеля|акрила|типсов)\b/i) {
        $res->{type} .= " $1";
    }
    if ($res->{type} =~ s/для\s+кожи\s*$//i) {
        if ($text =~ /\b(для)\s+кожи\s+(лица|тела|рук)\b/i or $text =~ /\b(для)\s+(кожи\s+вокруг\s+глаз)\b/i) {
            $res->{type} .= " $1 $2";
        }
    }

    my $for_re = 'рук|ног|тела|кожи|волос|ногтей|губ|век|ресниц|бровей|глаз|шеи|бороды|зубов|душа|ванны';
    if ($res->{type} !~ /\bдля\b/i) {
#        $res->{type} =~ s/\b(волос|тела)\s*$//i;
        $res->{type} =~ s/\b(\Q$for_re\E)\b/ для $1 /gi;
        $res->{type} =~ s/^\s+|\s+$//g;
   }

    my $correct_adjs = { 'антивозрастный' => 'антивозрастной', 'дневный' => 'дневной', 'увлажняемая' => 'увлажняющая', 'увлажненное' => 'увлажняющее', 'увлажненная' => 'увлажняющая', 'очищенное' => 'очищающее', 'очищавший' => 'очищающий', 'очищавшая' => 'очищающая', 'очистившее' => 'очищающее', 'омолодившая' => 'омолаживающая', 'омолодивший' => 'омолаживающий', 'омолаживаемый' => 'омолаживающий', 'маскированный' => 'маскирующий', 'корректируемый' => 'корректирующий', 'корректировавшее' => 'корректирующее', 'текстурировавший' => 'текстурирующий', 'регенерированный' => 'регенерирующий', 'разглаживавший' => 'разглаживающий', 'разгладивший' => 'разглаживающий'
    };
    foreach my $word (grep {$correct_adjs->{lc($_)} and $text =~ /\b\Q$correct_adjs->{$_}\E\b/i} split /\s+/, $res->{type}) {
        $res->{type} =~ s/\b\Q$word\E\b/ $correct_adjs->{$word} /i;
    }

    if (grep {$_ and $text =~ /Цвет\b.*\b\Q$_\E\b/i} split/\s+/, $res->{type}) {
        $res->{type} = $self->{typePrefix} || '';
    }
    $res->{type} = '' unless $self->proj->phrase( $res->{type} )->get_goods;

    if (lc($res->{brand}) eq 'воск') {
        $res->{brand} = '';
        $res->{type} .= ' воск';
    }

    if ($text =~ s/\b(for\s+)?(woman|women|man|men)\b/ /i) {
        $res->{sex} = ($2 =~ /wo/i) ? "женский" : "мужской";
        $res->{model} = "$1 $2" if ($1 and length($res->{model}) < 10);
    }

    #оставляем только ml в vol
    if ($res->{vol}) {
         $res->{vol} = ($res->{vol} =~ /(?:^|\s+)(\d+)\s*(ml|мл)(?:\s+|$)/i) ? "[$1 ml:$1 мл:$1ml:$1мл]" : '';
    }
    return ($text, $res);
}


sub get_brand {
    my ($self, $sources, $dbg) = @_;
    my @brands_list = $self->get_brands_list;
    my $res = {};

    #Kodi Professional (США)
    my $brands_re = join('|', map {quotemeta($_)} @brands_list);
    my $country_re = '\((Корея|США|Россия|Китай|Великобритания|Украина|Австрия|Франция)\)';

    foreach my $txt (@$sources) {
        if ($txt and $txt =~ /(?:^|\s+)($brands_re)(?:\s*$country_re)?(?:\s+|$)/i) {
            ($res->{brand}, $res->{country_adj}) = ($1, $2);
            print STDERR "found brand: $res->{brand}\n" if $dbg;
            last;
        } 
    }
    return $res;
}


sub get_brands_list :GLOBALCACHE {
    return (
#Летуаль
"l'oreal paris", 'pupa', 'garnier', 'max factor', 'artdeco', 'rimmel', "l'oreal professionnel", 'wella', 'yllozure', 'chanel', 'natura siberica', 'guerlain', 'givenchy', 'nivea', 'korres', 'hugo boss', 'gucci', 'lancome', 'giorgio armani', 'vivienne sabo', 'sally hansen', 'yves saint laurent', 'bvlgari', 'calvin klein', 'revlon', 'payot', 'nina ricci', 'dolce & gabbana', 'burberry', 'versace', 'lacoste', 'tangle teezer', 'paco rabanne', 'sexy hair', 'carolina herrera', 'kenzo', 'estee lauder', 'escada', 'syoss', 'trussardi', 'cacharel', 'salvatore ferragamo', 'lanvin', 'matrix', 'van cleef', 'sergio tacchini', 'moschino', 'green mama', 'gillette', 'elizabeth arden', 'chloe', 'bond no 9', 'la perla', 'splat', 'azzaro', 'yohji yamamoto', 'macadamia', 'loewe', 'thalgo', 'bruno banani', 'lalique', 'marc jacobs', 'axe', 'valentino', 'baldessarini', 'balenciaga', 'rexona', 'christina aguilera', 'armand basi', 'boucheron', 'palette', "johnson's baby", 'palmolive', 'prada', 'head&shoulders', 'bosley', 'bottega veneta', 'gliss kur', 'clinique', 'eisenberg', 'britney spears', 'dolce&gabbana', 'taft', 'antonio banderas', 'jimmy choo', 'dsquared2', 'biore', 'john galliano', 'alfred dunhill', 'goti', 'olay', 'blumarine', 'agent provocateur', 'dessange', 'adidas', 'biotherm', 'john varvatos', 'scholl', 'balmain', 'bonacure', 'kamill', 'jacques bogart',

#Рив Гош
'opi', 'orly', 'montale', 'victorinox', 'amouage', 'beyu', 'essie', 'weleda', 'lumene', 'hermes', 'bourjois', 'nouba', 'dove', 'janeke', 'byredo', 'swarovski', 'schwarzkopf', 'japan gals', 'serge lutens', 'nesti dante', 'ajmal', 'mexx', 'eva mosaic', 'estel', 'davidoff', 'xerjoff', 'teana', 'egomania', 'john frieda', 'mancera', 'guam', 'tom ford', 'lancaster', 'atelier cologne', 'masaki matsushima', 'pantene pro-v', 'comme des garcons', 'tommy hilfiger', 'avalon organics', 'planeta organica', 'acqua di parma', 'marlies moller', 'roberto cavalli', 'caudalie', 'cerruti', 'iceberg', 'jean paul gaultier', 'guess', 'lee stafford', 'ermenegildo zegna', 'isadora', 'escentric molecules', 'swiss line', 'angel schlesser', 'le petit marseillais', 'vera wang', 'jacques fath', 'mades cosmetics', 'helena rubinstein', 'agonist', 'sosu', 'leonor greyl', 'sisley', 'toni&guy', 'melvita', 'ahava', 'molinard', 'shakira', 'diesel', 'diademine', 'talika', 'redken',

#ИЛЬ ДЕ БОТЭ
'mavala', 'diptyque', 'alterna', 'matis', 'rouge bunny rouge', 'cartier', 'rene furterer', 'anny', "l'occitane", 'erborian', 'beautyblender', 'rance', 'invisibobble', 'michael kors', 'laura mercier', 'juliette has a gun', 'richenna', 'ainhoa', 'dr. brandt',

'maybelline new york', 'cnd', 'seventeen', 'isa dora', 'aroma jazz', 'roja dove', 'nyx', 'the face shop', 'sophin', 'tony moly', 'naillook', 'gezatone', 'kodi professional', 'kodi', 'runail', 'tnl professional', 'masura', 'bluesky', 'konad', 'essence', 'catrice', 'holy land', 'mertz', 'chantecaille', 'manly pro', 'the skin house', 'muehle', 'logona', 'nuxe', 'lime crime', 'entity', 'ezflow', 'kativa', 'aravia', 'holika holika', 'holika', 'dance legend', 'allshellac premiere',
    );
}


sub get_body_part {
    my ($self, $text, $type, $dbg) = @_;
    my $res = {};

    my $body_parts_re = 'рук|ног|тела|кожи|волос|ногтей|губ|век|ресниц|бровей|глаз|шеи|бороды|зубов'; 

    if ($text =~ s/(?:^|\s+)(для)\s+(.*)($body_parts_re)(?=\s+|$)/ /i 
        or $type and $type =~ /(?:^|\s+)(для)\s+(.*)($body_parts_re)(?=\s+|$)/i) {

        $res->{body_part} = "$1 $3";
        my $skin_type = $2;

        if ($res->{body_part} =~ /кожи/  and $skin_type =~ /(сухой|чувствительной|нормальной|комбинированной|жирной|проблемной|зрелой)/ 
         or $res->{body_part} =~ /волос/ and $skin_type =~ /(сухих|нормальных|жирных|вьющихся|седых|окрашенных|поврежденных|тонких|ослабленных)/){
            $res->{skin_type} = $1;
            print STDERR "found skin_type: $res->{skin_type}\n" if $dbg;
        }
    }
    return ($text, $res);
}


sub get_cosmetics_property {
    my ($self, $text, $dbg) = @_;
    my $cosmetics_property = [];

    if ($text =~ s/(?:^|\s+)(профессиональный|professional)(?:\s+|$)/ /i) {
        push @$cosmetics_property, $1;
    }

    my @cosmetics_for_list = qw(
        увлажняющий очищающий восстанавливающий питательный укрепляющий тонизирующий
        успокаивающий смягчающий разглаживающий выравнивающий матирующий
        освежающий охлаждающий согревающий 
        антицеллюлитный антивозрастной омолаживающий лифтинговый
        дневной ночной
        солнцезащитный несмываемый водостойкий стойкий дорожный
        легкий интенсивный многофункциональный универсальный
        трехфазный двухфазный однофазный
        отшелушивающий антибактериальный гипоаллергенный
        миндальный кокосовый оливковый
    );
    my $cosmetics_for_re = join('|', map {"$_(?:ий|ый|ой|яя|ая|ее|ое)"} map {/^([а-яё]+)(?:ий|ый|ой)$/} @cosmetics_for_list);

    if (my @found = $text =~ /(?:^|\s+)($cosmetics_for_re)(?=\s+|,|$)/ig) {
        print STDERR "found cosmetics_for: @found\n" if $dbg;
        push @$cosmetics_property, @found;
        $text =~ s/(^|\s+)\Q$_\E(\s+|$)/ /i for grep {$_} @found;
    }


    if ($text =~ s/(?:^|\s+|\(|,)(от|против)\s+(перхоти|морщин|прыщей|акне|пигментации|целлюлита|растяжек|кариеса|преждевременного старения|фотостарения|старения|темных кругов под глазами|черных точек|покраснений|раздражения|выпадения волос|вросших волос|секущихся концов|ломкости|вымывания цвета)(?:\s+|\)|,|$)/ /i) { 
        push @$cosmetics_property, "$1 $2";
    }


    if ($text =~ s/(?:^|\s+|\(|,)с\s+(ромашкой|лавандой|ментолом|календулой|морскими водорослями|маслом какао|маслом арганы|маслом ши|маслом макадамии|маслом чайного дерева|маслом жожоба|аргановым маслом|оливковым маслом|эфирными маслами|экстрактом ромашки|экстрактом розы|экстрактом бамбука|экстрактом лаванды|экстрактом алоэ|пчелиным маточным молочком|витамином е|гиалуроновой кислотой|салициловой кислотой|коллагеном|кератином)(?:\s+|\)|,|$)/ /i) { 
        push @$cosmetics_property, "с $1";
    }


    if ($text =~ s/(?:^|\s+|\(|,)без\s+(парабенов|аммиака|спирта|ацетона|фтора|сульфатов|силиконов|силикона|минеральных масел|отдушек|ароматизаторов|красителей|консервантов)(?:\s+|\)|,|$)/ /i) { 
        push @$cosmetics_property, "без $1";
    }

    if ($text =~ s/\b(spf)\s*(\d+)\b/ /i) {
        push @$cosmetics_property, "$1$2", "$1 $2";
    }
    return ($text, $cosmetics_property);
}


sub get_cosmetics_property_template {
    my ($self, $cosmetics_property, $dbg) = @_;
    my $template_value;

    if (@$cosmetics_property == 1) {
        $template_value = $cosmetics_property->[0]; 
    } elsif (@$cosmetics_property > 1) {
        my $indexes = array_subsets_ordered([1..@$cosmetics_property]); # все комбинации
        my @res = ();
        foreach my $selected ( @$indexes ){
            push @res, join(' ', @$cosmetics_property[map {$_ - 1} split /\s+/, $selected]);
        }
        #print STDERR Dumper (['res: ', \@res]) if $dbg;
        $template_value = '[' . join(':', @res) . ']';
    }
    return $template_value;
}


sub get_params {
    my ($self, $text, $type, $cosmetics_property, $dbg) = @_;
    my $res = {};

    my $params = $self->get_params_list($text, $dbg);
    print STDERR "params:", Dumper($params) if $dbg;

    #все найденные значения
    push @$cosmetics_property, map {@{ $params->{$_} }} grep {$params->{$_}} 
                               qw(cosmetics_for cosmetics_against cosmetics_without aroma_type color);

    #первое найденное значение
    my @fields = qw(age sex body_part skin_type);
    my $params_fv = {map {$_ => $params->{$_}->[0]} grep {$params->{$_} and @{ $params->{$_} }} ('type', @fields)};
    $res->{$_} = $params_fv->{$_} for grep {$params_fv->{$_}} @fields;

    if ($type !~ /(маникюрный набор|расческа|пилочка)/ and $params_fv->{type} and $type !~ /\Q$params_fv->{type}\E/i) {
        print STDERR "type changed: $type -> $params_fv->{type}\n" if $dbg;
        $res->{type} = $params_fv->{type};
    }
    return $res;
}


sub get_params_list {
    my ($self, $text, $dbg) = @_;
    return {} unless $text;
    my $res = {};

    $text =~ s/(\d+),(\d+)/$1\.$2/g;
    $text =~ s/,\s+/ /g;
    print STDERR "params_text: $text\n" if $dbg;

    my $params = {map {$_ =~ /^(.*):(.*)$/} split /,/, $text};
    #print STDERR "params:", Dumper($params) if $dbg;


    my $fields_map = [
        {fields => ['пол'], name => 'sex', values => ['мужские']},

        {fields => ['возраст'], name => 'age', values => ['детская']},

        {fields => ['область использования', 'зона нанесения'], name => 'body_part', 
         values => ['губы', 'глаза', 'брови', 'ресницы', 'волосы', 'тело', 'руки', 'ноги', 'ногти']},

        {fields => ['тип кожи'], name => 'skin_type', 
         values => ['сухая', 'чувствительная', 'нормальная', 'комбинированная', 'жирная', 'проблемная', 'зрелая']},

        {fields => ['тип волос'], name => 'skin_type', 
         values => ['сухие', 'нормальные', 'жирные', 'вьющиеся', 'седые', 'окрашенные', 'поврежденные', 'тонкие', 'ослабленные']},

        {fields => ['эффект', 'эффект от использования'], name => 'cosmetics_for', 
         values => ['увлажнение', 'очищение', 'восстановление', 'окрашивание', 'питание', 'уход', 'укрепление', 'объем', 'защита', 'фиксация', 'лифтинг', 'омоложение', 'разглаживание', 'антивозрастной', 'против выпадения волос', 'защита от солнца', 'от перхоти', 'тонизирование', 'антицеллюлитный', 'смягчение', 'отшелушивание', 'тонирование', 'отбеливание', 'противовоспалительный', 'матирование']},

        {fields => ['проблемы'], name => 'cosmetics_against', 
         values => ['темные круги', 'пигментация', 'сухость', 'жирность']},

        {fields => ['особенности состава'], name => 'cosmetics_without', 
         values => ['без парабенов', 'без минеральных масел', 'без аммиака', 'без сульфатов', 'без отдушек', 'без спирта', 'не комедогенна']},

        {fields => ['цвет'], name => 'color', 
         values => ['розовый', 'фиолетовый', 'зеленый', 'красный', 'коричневый', 'оранжевый', 'синий', 'черный', 'белый', 'золотой', 'серебряный', 'бежевый']},

        {fields => ['классификация аромата', 'аромат'], name => 'aroma_type', 
         values => ['цветочный', 'древесный', 'фруктовый', 'цитрусовый', 'восточный', 'цветочно-фруктовый']},

        {fields => ['тип'], name => 'type', 
         values => ['крем', 'лак для ногтей', 'шампунь', 'маска', 'контактные линзы', 'гель', 'туалетная вода', 'краска', 'масло', 'помада для губ', 'мыло', 'парфюмерная вода', 'тени для век', 'мочалка', 'бальзам', 'кондиционер', 'сыворотка', 'дезодорант', 'лосьон', 'блеск для губ', 'зубная паста', 'тональный крем', 'зубная щетка', 'пудра', 'гель-лак', 'карандаш для глаз', 'спрей', 'молочко', 'тушь для ресниц', 'скраб', 'щетка для волос', 'тоник', 'пенка', 'эфирное масло', 'косметический набор', 'румяна', 'бальзам для губ', 'лак', 'мусс', 'карандаш для губ', 'прокладки', 'маникюрная пилка', 'духи', 'косметическая кисть', 'корректор косметический', 'лечебное средство для ногтей и кутикулы', 'соль для ванны', 'набор инструментов для маникюра', 'концентрат', 'массажер', 'основа под лак', 'зеркало косметическое', 'эмульсия', 'средство для снятия лака', 'карандаш для бровей', 'тонометр', 'гигиеническая помада', 'пилинг', 'защитный лак', 'bb-средство', 'ополаскиватель для полости рта', 'парфюмированный набор', 'электрическая зубная щетка', 'спонж', 'вода', 'основа под макияж', 'средство для лечения кожи головы и волос', 'косметический набор для волос', 'средство для снятия макияжа', 'пена для ванны', 'флюид', 'расческа-гребень', 'средство для окраски', 'аппарат для маникюра и педикюра', 'пластины для стемпинга', 'набор декоративной косметики', 'влажные салфетки', 'маникюрные ножницы', 'средство для быстрого высыхания лака', 'набор для нейл-арта']},
    ];

    my %additional_mapping = (
        'увлажнение'        => ['увлажняющий', 'для увлажнения'], 
        'очищение'          => ['очищающий', 'для очищения'], 
        'восстановление'    => ['восстанавливающий', 'для восстановления'], 
        'окрашивание'       => ['окрашивающий', 'для окраски', 'для окрашивания'], 
        'питание'           => ['питающий', 'для питания'], 
        'уход'              => ['для ухода'],
        'укрепление'        => ['укрепляющий', 'для укрепления'],
        'объем'             => ['для придания объема', 'придающий объем', 'для объема'], 
        'защита'            => ['защищающий', 'для защиты'], 
        'фиксация'          => ['фиксирующий', 'для фиксации'], 
        'омоложение'        => ['омолаживающий', 'для омоложения'], 
        'разглаживание'     => ['разглаживающий', 'для разглаживания морщин'], 
        'защита от солнца'  => ['солнцезащитный', 'для защиты от солнца'], 
        'тонизирование'     => ['тонизирующий'], 
        'смягчение'         => ['смягчающий', 'для смягчения'], 
        'отшелушивание'     => ['отшелушивающий', 'для отшелушивания'], 
        'тонирование'       => ['тонирующий'], 
        'отбеливание'       => ['отбеливающий', 'для отбеливания'], 
        'матирование'       => ['матирующий', 'для матирования'],

        'темные круги'      => ['от темных кругов', 'против темных кругов'],
        'пигментация'       => ['от пигментации', 'против пигментации'],
        'сухость'           => ['от сухости', 'против сухости'],
        'жирность'          => ['от жирности', 'против жирности'],
    );



    foreach my $d (@$fields_map) {
        foreach my $f (grep {$params->{$_}} @{ $d->{fields} }) {
            push @{ $res->{ $d->{name} } }, map {( $additional_mapping{$_} ? @{ $additional_mapping{$_} }: ($_) ) }  grep {$params->{$f} =~ /^\s*\Q$_\E/i} @{ $d->{values}};
        }
    }



    if ($res->{type} and $res->{type}->[0] and $params->{'применение'} and $params->{'применение'} =~ /^\s*(для)\s+([а-яё]+)\s*$/i) {
        $res->{type}->[0] .= " $1 $2";
    }
    delete $res->{$_} for grep {!($res->{$_} and @{ $res->{$_} })} keys %$res; 
    return $res;
}


sub get_types {
    my ($self, $data, $cosmetics_property, $dbg) = @_;
    my $res = {}; 

    my $type = lc($data->{type});

    if ($type =~ s/\bдля\s+([а-яё]+ых)\s*$//i) {
        push @$cosmetics_property, $1;
    }
    $type =~ s/\bдля\s+типов\s*$//i;

    if ($type =~ /зубн/i and $data->{body_part} and $data->{body_part} eq 'для зубов') {
        $type =~ s/(^|\s+)\Q$data->{body_part}\E(\s+|$)/ /i;
    }

    #вырезаем предлоги и прилагательные в конце
    my $prepositions_re = 'в|к|у|с|а|на|от|со|до|за|но|для|или|под|подо|над|без|и';
    my $adjectives_re = '[а-яё]+(?:ый|ий|ой|ая|яя|ое|ее)';
    if ($type =~ s/\s+($prepositions_re)(\s+($prepositions_re|$adjectives_re))*\s*$//i) {
        print STDERR "text after cut prepositions and adjectives: $type\n" if $dbg;
    }

    #вырезаем наречия в начале
    $type =~ s/^\s*(нежно|мягко|интенсивно)\b//i;


    my $short_type = $type;
    my @short_types = ($short_type);

    $short_type =~ s/(^|\s+)\Q$_\E(\s+|$)/ /i for grep {$_} map {split /\s+/, $_} grep {$_} @$cosmetics_property;
    push @short_types, $short_type;

    $short_type =~ s/(^|\s+)\Q$_\E(\s+|$)/ /i for grep {$_} map {$data->{$_}} qw(skin_type body_part);
    push @short_types, $short_type;

    if (my @adjectives = $short_type =~ /\b($adjectives_re)\b/ig) {
        if (@adjectives >= 2) {
            print STDERR "found adjectives: @adjectives\n" if $dbg;
            pop @adjectives;
            $short_type =~ s/\b\Q$_\E\b/ /i for @adjectives;
            push @short_types, $short_type;
            push @$cosmetics_property, @adjectives;
        }
    }
    #print STDERR "short types: " . join('', map {$_ . ": " . length($_) . "\n"} @short_types) if $dbg;

    my $max_title_length = 33;
    my $type_for_title = (grep {length($_) + length($data->{brand} || '') <= $max_title_length} @short_types)[0] 
                      || (grep {length($_) <= $max_title_length} @short_types)[0];
    $type = $type_for_title || $type;
    $type =~ s/\s+($prepositions_re)(\s+($prepositions_re|$adjectives_re))*\s*$//i;

    $res->{type} = $self->harmonize_adjectives($type, $short_type, $dbg);
    $res->{short_type} = $short_type;

    if ($res->{short_type} =~ s/\bдля лица\b/ /i) {
        $res->{other_type} = $short_type;
    }
    print STDERR "type: $res->{type}\n" if $dbg;

    return $res;
}


sub harmonize_adjectives {
    my ($self, $type_to_harmonize, $type, $dbg) = @_;

    if (my @adjectives = $type =~ /\b([а-яё]+(?:ый|ий|ой|ая|яя|ое|ее))\b/ig) {
        my $short_type = $type;
        $short_type =~ s/\b\Q$_\E\b/ /i for @adjectives;

        #согласование если осталось одно слово (иначе крем для жирной кожи -> жирный)
        if ($short_type =~ /^\s*([а-яё]+)\s*$/i) {
            foreach my $adj (@adjectives) {
                my $harmonized = $self->proj->phrase($short_type)->harmonize($adj);
                next if $adj eq $harmonized;
                print STDERR "unharmonized: adj: $adj, harm: $harmonized\n" if $dbg;
                $type_to_harmonize =~ s/\b\Q$adj\E\b/ $harmonized /;
            }
        }
    }
    return $type_to_harmonize;
}


sub clear_model {
    my ($self, $model, $fields) = @_;

    $model =~ s/(^|\s+)\Q$_\E(\s+|$)/ /i for grep {$_} map {split /\s+/, $_} grep {$_} @$fields; 
    $model = join(' ', grep {$_ !~ /^\d+$/} split /\s+/, $model);
    $model = '' if $model !~ /[a-z]+/i;
    return $model;
}


sub _SHORT_MDL { 
    my ( $self, $txt ) = @_;
    my $t = $self->SUPER::_SHORT_MDL($txt);
    return $t eq 'for' ? '' : $t;
}

our $_MDL = 'model:_DEMULT';
our $_TYPE = 'type:_DEMULT';
our $_BRND = 'brand:_DEMULT';

sub perf_title_templ {
    return "[$_TYPE] $_BRND [$_MDL] (vol:_DEMULT), [$_TYPE] $_BRND (vol:_DEMULT), $_BRND [$_MDL] (vol:_DEMULT), [$_TYPE] [$_MDL] (vol:_DEMULT)";
}

sub common_templates_text {
    my ($self, %opts) = @_;
    my $title_type = "type";
    my $title;
    if ( $opts{templates_type} eq 'dyn' ) {
        $title = "$title_type brand model vol:_DEMULT, $title_type brand model, $title_type brand vol:_DEMULT, $title_type brand, brand model, type:_DEL_ADJ brand, type model, $title_type, brand";
    }
    else {
        $title = $self->perf_title_templ;
    }
    my $type = '[short_type/short_type:_DEL_ADJ/short_type:_MAINWORDS/other_type]';
    my $model = "[model/model:_SHORT_MDL]";

    my $res = "
        brand $type                                     {___MULT_PHRASE} => $title
        body_part brand $type                           {___MULT_PHRASE} => $title
        country_adj $type                               {___MULT_PHRASE} => $title
        brand $model $type                              {___MULT_PHRASE} => $title
        brand sex $type                                 {___MULT_PHRASE} => $title
#           body_part brand                                 {___MULT_PHRASE} => $title
        brand cosmetics_property $type                  {___MULT_PHRASE} => $title
        brand sex                                       {___MULT_PHRASE} {___MAX_5000} => $title
        brand cosmetics_property                        {___MULT_PHRASE} {___MAX_5000} => $title
        $model $type                                    {___MULT_PHRASE} {___MAX_5000} => $title
        body_part country_adj $type                     {___MULT_PHRASE} => $title
        body_part brand $model $type                    {___MULT_PHRASE} => $title
        body_part brand cosmetics_property $type        {___MULT_PHRASE} => $title
        brand country_adj $type                         {___MULT_PHRASE} => $title
        body_part brand cosmetics_property              {___MULT_PHRASE} => $title
        body_part sex $type                             {___MULT_PHRASE} => $title
#          $type vol                                       {___MULT_PHRASE} => $title
        brand $model sex                                {___MULT_PHRASE} => $title
        brand cosmetics_property $model                 {___MULT_PHRASE} => $title
        cosmetics_property country_adj $type            {___MULT_PHRASE} => $title
        body_part brand $model                          {___MULT_PHRASE} => $title
        cosmetics_property sex $type                    {___MULT_PHRASE} => $title
        brand $model vol                                {___MULT_PHRASE} => $title
        body_part cosmetics_property sex $type          {___MULT_PHRASE} => $title
        brand $model sex $type                          {___MULT_PHRASE} => $title
        country_adj sex $type                           {___MULT_PHRASE} => $title
        age brand $type                                 {___MULT_PHRASE} => $title
        body_part brand skin_type                       {___MULT_PHRASE} => $title
        age brand                                       {___MULT_PHRASE} => $title
        body_part $model $type                          {___MULT_PHRASE} => $title
        body_part $type vol                             {___MULT_PHRASE} => $title
        age sex $type                                   {___MULT_PHRASE} => $title
        $model sex $type                                {___MULT_PHRASE} => $title
        brand vol                                       {___MULT_PHRASE} => $title
        brand country_adj $model $type                  {___MULT_PHRASE} => $title
        body_part cosmetics_property country_adj $type  {___MULT_PHRASE} => $title
        brand cosmetics_property country_adj $type      {___MULT_PHRASE} => $title
        body_part $model                                {___MULT_PHRASE} {___MAX_10000} => $title
        brand $type vol                                 {___MULT_PHRASE} => $title
        #$model sex                                                       => $title
        brand country_adj $model                        {___MULT_PHRASE} => $title
        body_part brand country_adj $type               {___MULT_PHRASE} => $title
        body_part cosmetics_property $model $type       {___MULT_PHRASE} => $title
        age body_part brand $type                       {___MULT_PHRASE} => $title
        body_part brand sex $type                       {___MULT_PHRASE} => $title
        age $type vol                                   {___MULT_PHRASE} => $title
        brand $model $type vol                          {___MULT_PHRASE} => $title
        body_part sex skin_type $type                   {___MULT_PHRASE} => $title
        brand cosmetics_property sex $type              {___MULT_PHRASE} => $title
#не из статистики
        $type brand quotes                              {___MULT_PHRASE} => $title
        $type quotes                                    {___MULT_PHRASE} => $title
        brand quotes                                    {___MULT_PHRASE} => $title
        brand $model                                    {___MULT_PHRASE} => $title
        cosmetics_property $type                        {___MULT_PHRASE} {___MAX_10000} => $title
        body_part cosmetics_property $type              {___MULT_PHRASE} => $title
        body_part cosmetics_property skin_type $type    {___MULT_PHRASE} => $title
        cosmetics_property $type vol                    {___MULT_PHRASE} => $title
        body_part cosmetics_property $type vol          {___MULT_PHRASE} => $title
        $type                             {___MULT_PHRASE} {___MAX_3000} => $title
#проверить
        body_part skin_type $type             {___MULT_PHRASE} {___MAX_3000} => $title
        body_part $type                       {___MULT_PHRASE} {___MAX_3000} => $title
        age $type                             {___MULT_PHRASE} {___MAX_3000} => $title
        sex $type                             {___MULT_PHRASE} {___MAX_3000} => $title
        brand cosmetics_property $model $type {___MULT_PHRASE} {___MAX_3000} => $title 
    ";                                                   
        
    return $res;
}

sub dyn_templates_text :GLOBALCACHE {
    return $_[0]->common_templates_text(templates_type => 'dyn');
}

sub perf_templates_text :GLOBALCACHE {
    return $_[0]->common_templates_text(templates_type => 'perf');
}

sub banner_single_templates_text :GLOBALCACHE {
    my $self = shift;
    my $title = $self->perf_title_templ;
    my $result = "
        short_type => $title
        model      => $title
        brand      => $title
    ";
    return $result;
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        modellike_product                       goods accessory P
        get_search_filtered15k                  goods accessory
        add_dynamic_homonymy_words              goods accessory P
        #context_syns_extend                     goods accessory S
        get_search_filtered15k                  goods accessory
        #postfilter_product                         goods accessory P
        get_wide_filtered                       goods accessory
        #postfilter_product                      goods accessory P
        snorm_phrase_list                       goods accessory
        pack_phr_lite                           goods accessory
        pack_list                               goods accessory
        get_search_filtered15k                  goods accessory
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}

1;
