package BM::BannersMaker::ProductBooks;
use utf8;
use strict;
use base qw(BM::BannersMaker::Product);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    author
));


my @offer_fields = qw{author};

sub get_offer_fields {
    return @offer_fields;
}


sub init {
    my ($self) = @_;
    $self->SUPER::init;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH') {
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

sub parse :CACHE {
    my ($self) = @_;

    my $h = $self->SUPER::parse;

    my $authors_from_feed = $self->author;
    $authors_from_feed = '' unless $authors_from_feed =~ m/\w/;

    my @authors = split(/\s*\,\s*/, $authors_from_feed);
    my @short_author_names = map {_author_short($_)} @authors;
    $h->{'authors'} = join(' ', @short_author_names);
    $h->{'first_author'} = $short_author_names[0];

    my $book_name = $self->name;
    $h->{'book_name_with_authors'} = undef;
    $h->{'book_name'} = undef;
    if ($self->_is_authors_in_book_name($book_name, \@authors)) {
        $h->{'book_name_with_authors'} = $book_name;
    } else {
        $h->{'book_name'} = $book_name;
    }

    my $source_text = '';
    $source_text = join (' ', map { $_ || () } ( $self->name, $self->proj->phrase( $self->description )->head(10), $self->categpath, $self->minicategs ) );
    $source_text = join (' ', $self->proj->phrase( $source_text )->words );
    $h->{book_prefix} = undef;
    if ($h->{type} eq 'книга' || $source_text =~ /книг/i) {
        $h->{book_prefix} = 'книга:';
    }
    return $h;
}

sub _author_short {
    my $author_full_name = shift;
    my ($author_surname, $author_name, undef) = split('\s+', $author_full_name, 3);
    my $result = ucfirst($author_surname);
    if ($author_name) {
        $result .= " " . uc(substr($author_name, 0, 1)) . ".";
    }
    return $result
}

sub _is_authors_in_book_name {
    my $self = shift;
    my $book_name = shift;
    my $authors = shift;

    my @authors_surnames = map {my ($s, undef) = split('\s+', $_, 2); $s} @$authors;
    my $book_name_phr = $self->proj->phrase($book_name)->pnorm_phr();
    my $surnames_phr =  $self->proj->phrase(join(' ', @authors_surnames))->pnorm_phr();
    return (length($book_name_phr) > length($book_name_phr % $surnames_phr));
}

sub templates_text {
    return "
		type first_author book_name => book_prefix book_name <-> first_author
		type book_name => book_prefix book_name
		first_author book_name => book_name <-> first_author
		type book_name_with_author => book_name_with_author
		book_name_with_author => book_name_with_author
		book_name => book_name
	";
}

sub dyn_templates_text :GLOBALCACHE {
	return templates_text();
}

sub perf_templates_text :GLOBALCACHE {
    return templates_text();
}

sub banner_single_templates_text :GLOBALCACHE {
    return templates_text();
}
1;
