package BM::BannersMaker::ProductBuildingMaterials;
use utf8;
use base qw(BM::BannersMaker::Product);
use Utils::Array;
use Data::Dumper;
use utf8;
 
use open ":utf8";
no warnings "utf8";


__PACKAGE__->mk_accessors(qw(
    mark
    model
    color
    type
    name 
    description
    typePrefix
)); # ключи метода 

### Static dict's phrase lists
my $material_phrase_list = ();
my $target_phrase_list = ();
my $isores_phrase_list = ();;

sub init {
    my ($self) = @_;
    $self->SUPER::init;
    $self->class_init(proj => $self->proj);
}

sub class_init :RUN_ONCE {
    my $class = shift;
    my %par = @_;
    my $proj = $par{proj};

    $material_phrase_list = $proj->dict_manager->get_dict("dict_materials", '')->phrase_list;
    $target_phrase_list   = $proj->dict_manager->get_dict("dict_target", '')->phrase_list;
    $isores_phrase_list   = $proj->dict_manager->get_dict("dict_isores", '')->phrase_list;
}

########################################################
#Доступ к полям
########################################################

sub ad_type {
    return 'building_materials';
} # banner router

sub match_type {
    return 'norm';
} # matching query


sub get_tail { 
     my ($self, $txtsource, $h) = @_;
     my @phrase_words = $self->proj->phrase($self->proj->phrase($txtsource)->norm_phr)->words;
     my %words_to_delete = ();
     my @restricted = qw/minicategs src/;
     for my $key(keys %$h) { 
	   if ( !($key ~~ @restricted)) {
          my @used_words = $self->proj->phrase($h->{$key})->words;
          for my $del_word(@used_words) {
              $words_to_delete{$del_word} = 1;
          }
        }                   
     }
     #print STDERR "USED: ", join(" | ", keys %words_to_delete), "\n";
     my %uniq_words = ();
     for my $cand_word(@phrase_words) { 
         $uniq_words{$cand_word} = 1 if not exists $words_to_delete{$cand_word};
     }
     return join(' ', keys %uniq_words);
}

sub del_subwords {
     my ($self, $phr, $words) = @_;
     my $res2 = join(" ", @$words); 
     my $res = (($self->proj->phrase($phr))^($self->proj->phrase($res2)))->text;   
     return $res;
}

sub filter_type {
    my ($self, $h) = @_;
    return unless $h->{type};
    $h->{type} =~ s/\,.*//i;
    #$h->{type} = '' unless $self->proj->phrase( $self->proj->phrase($self->SUPER::txtsource.' '.$h->{type})->norm_phr)->get_goods;
    if ($h->{type} =~ /(\(|\)|\/)/i) {
        $h->{type} = '';
        return;
    }
    $h->{type} =~ s/(^|\s)(магазин|интернет|товар|каталог|цена|интернет-магазин|акци|размер|промо|заказ|купить)(\s|$)//g;
    $h->{type} =~ s/электрические кабели/кабели/i;
    $h->{type} =~ s/\s+/ /g;
    $h->{type} =~ s/(^\s|\s$)//g;
}

sub filter_model {
    my ($self, $h) = @_;
    return unless ($h->{model} && $h->{vol}) ;
    my $filter_reg = $h->{vol}; 
    $filter_reg =~ s/\:/\|/g;
    $filter_reg =~ s/\./\,/g;
    $h->{model} =~ s/($filter_reg)//g;
    $filter_reg =~ s/\,/\./g;
    $h->{model} =~ s/($filter_reg)//g;
    $h->{model} =~ s/\ \ /\ /g;
    $filter_reg =~ s/(\ кг|\ мм|\ мг|\ г|\ м|\ л|\ т)//g;
    $filter_reg =~ s/\./\,/g;
    $h->{model} =~ s/($filter_reg)//g;
    $filter_reg =~ s/\,/\./g;
    $h->{model} =~ s/($filter_reg)//g;
    $h->{model} =~ s/\ \ /\ /g;
    delete $h->{model} if ($h->{model} eq '' || $h->{model} eq ' ');
}

sub is_adj {
    my ($self, $txt) = @_;
    return $txt =~ m/ий|ый|ой|вая|ная|мая|лая|кая|ые|ие|ое|ых|их|яя/i;
}


sub _del_adj_true {
    my ( $self, $txt ) = @_;
    my $src = $txt;
    return '' unless $txt;
    my $adj = "(ий|ый|ой|вая|ная|мая|лая|кая|ые|ие|ое|ых|их|яя)";
    my $excl = "(удобрен)";
    my $t = join (' ', grep { /$excl/ || ! /$adj$/ } split /\s+/, $txt );
    
    my $preps_re = $BM::PhraseParser::preps_re;
    if ($t =~ / ($preps_re)$/) {
        return $src;
    }
    
    return "$t" if length($txt) > length($t);
    return '';
}

sub get_metricalre {
    my $path = $Utils::LightCommon::dirs->{dicts}."/dict_metrical";
    (-f $path) or die('Cant load metrical_re!');
    
    open F, $path;
    my @metrical = <F>;
    close F;

    s/ =>.*$// for @metrical;
    return join '|', grep {/\S/} map { s/^\s+|\s+$//g; $_ } sort { length $b <=> length $a } @metrical; ##no critic
}

my $metrical_enum_re = get_metricalre;
my $metrical_re = qr/(\d+[\s\ ]*(?:${metrical_enum_re})[\s\/\ ]+(?:${metrical_enum_re}))/;

sub parse :CACHE {
    my ($self) = @_;
    my $h = $self->SUPER::parse;
 #   print STDERR "BASE:\n";print STDERR Dumper $h;
    #my $src = $h->{src};
    if ($h->{src} and $h->{brand}) {
        # в парсинге мы разрываем бренды с нижним подчёркиванием. здесь восстанавливаем бренд подчёркиванием из поля src
        my $re = '(?<res>(\b(?<lost1>\S+?)_'.(quotemeta $h->{brand}).')|('.(quotemeta $h->{brand}).'_(?<lost2>\S+?)\b))';
        if ($h->{src} =~ /$re/i) {
            $h->{brand} = $+{'res'};
            my $lost_part = $+{'lost1'} // $+{'lost2'};
            my $lost_re = '\b'.(quotemeta $lost_part).'\b';
            for my $f (grep { $_ =~ /model/i} (keys %$h)) {
                $h->{$f} =~ s/$lost_re//i;
                $h->{$f} =~ s/\s+/ /g;
            }
        }
    }

    $self->filter_type($h);
    $self->filter_model($h);
    
    if ((not exists $h->{type}) || (length $h->{type}) == 0) {
        if (defined $self->{description}){
            my $goods = $self->proj->phrase( $description )->get_goods || '';     
            $h->{type} = $goods if $goods;
        }
        $self->filter_type($h);
        $self->remove_duplicates_from_stones($h);
    }
    if (exists $h->{toponyms} && $h->{toponyms} =~ /(росси|белару|белору|украин|казахст)/ ){
        $h->{toponyms} = '';
    }
    if ($h->{type}) {
        my @words = split(/\s+/, $h->{type});
        my $cnt_adj = 0;
        my $cnt_for = 0;
        for my $w(@words) {
            $cnt_adj++ if $self->is_adj($w);
            $cnt_for++ if $w eq 'для';
        }
        if ($cnt_adj + $cnt_for == scalar(@words) - 1) {
            $h->{type} =~ s/для\ //g;
        }
        $h->{type} =~ s/навесный/навесной/;
        $h->{type} =~ s/оцинковавший/оцинкованный/;
        $h->{type} =~ s/переходный/переходной/i if $h->{type} =~ m/тройник/i;
    }
    delete($h->{$_}) for grep { !defined($h->{$_}) || $h->{$_} eq '' } keys %$h;

    if ( (not exists $h->{model}) && exists $h->{quotes}) {
        $h->{model} = $h->{quotes};
    }
    if (exists $h->{qty}) {
        if (exists $h->{vol}) {
	        $h->{vol} .= ':'. $h->{qty};
	    } else {
	        $h->{vol} = $h->{qty};
	    }
 	    delete $h->{qty};
    }
    if (exists $h->{vol}) {
        $h->{vol} =~ s/\\\*/\*/g;
        my @tmp = split(":", $h->{vol});
        for my $i(0..scalar @tmp -1) {
            chomp $tmp[$i];
            $tmp[$i] =~ s/(^\*)|(\*$)//g;
            $tmp[$i] =~ s/(^\ *)|(\ *$)//g;
        }
        @tmp = sort {(length $b) <=> (length $a)} @tmp;
        $h->{vol} = join(':', @tmp);
    }
    if (not exists $h->{'model'} and exists $h->{'model_num'}) {
        $h->{'model'} = $h->{'model_num'};
        delete $h->{'model_num'};
    }
    $h->{color} = lc $h->{color} if $h->{color};
    my @field_hierarchy = qw/name model typePrefix description/;
    my $common_phr = '';
    for my $field_name(@field_hierarchy) {
	    $common_phr .= ' '.$self->proj->phrase($self->$field_name)->head(10);
    }
    #my $common_phrase = $self->proj->phrase($common_phr);
    my $type_no_adj = $self->_del_adj_true($h->{type});

    $h->{isores}   = $isores_phrase_list->search_subphrases_in_text($common_phr)->phrases2text(':');
    $h->{material} = $material_phrase_list->search_subphrases_in_text($common_phr)->phrases2text(':');
    $h->{target}   = $target_phrase_list->search_subphrases_in_text($common_phr)->phrases2text(':');
    
    #<metr> / <metr> constructions parsing
    $h->{src} =~ m/$metrical_re/i;
    if ( $h->{src} =~ m/$metrical_re/i ) {
        my $buf_metric = $1;
        $buf_metric =~ s/\ \ /\ /g;
        $buf_metric =~ s/([a-zа-я])\ ([a-zа-я])/$1\/$2/i;
        $buf_metric =~ s/^\D+|\W+$|\ //gi;
        $buf_metric =~ s/(\d)(\D)/$1\ $2/;
        if ($buf_metric) {
            my $filter = lc $buf_metric;
            $filter =~ s/\W//gi;
            $h->{vol} = join(':', grep { s/[^\d\w]//gi; index ($filter, $_) == -1 } split (':', $h->{vol} || '')); ##no critic
            $buf_metric =~ m/(\d+)/;
            my $number = $1;
            $h->{vol} = ($h->{vol} ? "$buf_metric:$number:".$h->{vol}: "$buf_metric:$number") ;
        }
    }

    $h->{material} = join(':', grep { index (lc $h->{type}, lc $_ ) == -1} split(':', $h->{material})) if $h->{material};

    if ( $h->{model} ) {
        my $tmp_model = $h->{model};
        $tmp_model =~ s/$h->{material}//gi;
        $tmp_model =~ s/\ //g;
        $tmp_model =~ s/^($metrical_enum_re)$//i;
        delete $h->{model} unless $tmp_model;
    }

    for my $text ( grep { $h->{$_} } qw/age color/ ){
            $h->{$text} = $self->proj->phrase($type_no_adj)->harmonize($h->{$text});
    }

    #$h->{'_TAIL_'} = $self->get_tail($src, $h);
    #$h->{'src'} = $src;

    delete($h->{$_}) for grep { !defined($h->{$_}) || $h->{$_} eq '' } keys %$h;

#    print STDERR "BUILDING:\n"; print STDERR Dumper $h, "\n";
    return $h;
}
#parse phrase
#returns phrase


sub title_templ :GLOBALCACHE {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL], [type/type:_DEL_ADJ] [model/model:_SHORT_MDL], [type/type:_DEL_ADJ/type:_MAINWORDS] brand, [type/type:_DEL_ADJ/type:_MAINWORDS]";
    return $res;
}

sub title_templ_combined {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL], [type/type:_DEL_ADJ] [model/model:_SHORT_MDL], [type/type:_DEL_ADJ/type:_MAINWORDS] brand vol:_FIRST_SIZE, [type/type:_DEL_ADJ/type:_MAINWORDS] vol:_FIRST_SIZE, color:_FIRST_SIZE [type/type:_DEL_ADJ] [model/model:_SHORT_MDL], color:_FIRST_SIZE [type/type:_DEL_ADJ], [type/type:_DEL_ADJ/type:_MAINWORDS] brand, [type/type:_DEL_ADJ/type:_MAINWORDS]";
    return $res;
}

sub title_weak_templ {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] brand model_weak, brand model_weak, [type/type:_DEL_ADJ/type:_MAINWORDS] model_weak, [type/type:_DEL_ADJ/type:_MAINWORDS] brand";
    return $res;
}

sub title_templ_vol {
    my $res =  "[type/type:_DEL_ADJ] brand [model/model:_SHORT_MDL] vol:_FIRST_SIZE, [type/type:_DEL_ADJ] [model/model:_SHORT_MDL] vol:_FIRST_SIZE, [type/type:_DEL_ADJ] brand vol:_FIRST_SIZE, [type/type:_DEL_ADJ] vol:_FIRST_SIZE"; 
    return $res;
}

sub title_templ_color {
    my $res = "color:_FIRST_SIZE [type/type:_DEL_ADJ] brand [model/model:_SHORT_MDL], color:_FIRST_SIZE [type/type:_DEL_ADJ] [model/model:_SHORT_MDL], color:_FIRST_SIZE [type/type:_DEL_ADJ] brand, color:_FIRST_SIZE [type/type:_DEL_ADJ]";
    return $res;
}

sub title_templ_vol_color {
    my $res =  "color:_FIRST_SIZE [type/type:_DEL_ADJ] brand [model/model:_SHORT_MDL] vol:_FIRST_SIZE, color:_FIRST_SIZE [type/type:_DEL_ADJ] [model/model:_SHORT_MDL] vol:_FIRST_SIZE, color:_FIRST_SIZE [type/type:_DEL_ADJ] brand vol:_FIRST_SIZE, color:_FIRST_SIZE [type/type:_DEL_ADJ] vol:_FIRST_SIZE"; 
    return $res;
}


sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title_templ = $class->title_templ;
    my $title_templ_combined = $class->title_templ_combined;
    my $title_templ_vol = $class->title_templ_vol.', '.$title_templ;
    my $title_templ_color = $class->title_templ_color.', '.$title_templ;
    my $title_templ_vol_color = $class->title_templ_vol_color.', '.$title_templ_vol.', '.$title_templ_color.', '.$title_templ;
    my $res = "
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand model => $title_templ_combined
        [type/type:_DEL_ADJ/type:_MAINWORDS] model => $title_templ_combined
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand {___MAX_3000} => $title_templ_combined
        brand model {___MAX_10000} => $title_templ_combined
        model {___MAX_10000} => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand brand_for model_for => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand brand_for model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model brand_for model_for => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model model_for => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model_for => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand_for model_for => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand_for model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model_for model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model_for => $title_templ_combined
        brand brand_for model_for => $title_templ_combined
        brand brand_for model {___MAX_10000} => $title_templ_combined
        model brand_for model_for => $title_templ_combined
        brand model model_for => $title_templ_combined
        brand_for model {___MAX_10000} => $title_templ_combined
        model_for model => $title_templ_combined
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand {___MAX_3000} => $title_templ_combined
        [type/type:_DEL_ADJ/type:_MAINWORDS] vol:_MULT_SIZE {___MULT_PHRASE} {___MAX_10000} => $title_templ_vol
        [model/model:_SHORT_MDL] vol:_MULT_SIZE {___MULT_PHRASE} {___MAX_10000} => $title_templ_vol
        isores:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        color:_MULT_DEFAULT model [type/type:_DEL_ADJ/type:_MAINWORDS]  vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol_color
        age [type/type:_DEL_ADJ/type:_MAINWORDS]  vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        age brand model [type/type:_DEL_ADJ/type:_MAINWORDS]  => $title_templ_combined
        model brand vol:_MULT_SIZE {___MULT_PHRASE}	=> $title_templ_vol
        age color:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} 	=> $title_templ_color
        age [type/type:_DEL_ADJ/type:_MAINWORDS] brand => $title_templ_combined
        [type/type:_DEL_ADJ/type:_MAINWORDS] model brand vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        color:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol_color
        color:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] brand {___MULT_PHRASE} => $title_templ_color
        color:_MULT_DEFAULT material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ_color
        material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] model {___MULT_PHRASE} => $title_templ_combined
        material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] model brand {___MULT_PHRASE} => $title_templ_combined
        age material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ_combined
        color:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  model brand {___MULT_PHRASE} => $title_templ_color
        brand vol:_MULT_SIZE {___MAX_10000} {___MULT_PHRASE} => $title_templ_vol
        isores:_MULT_DEFAULT material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ_combined
        [type/type:_DEL_ADJ/type:_MAINWORDS]  brand vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        [type/type:_DEL_ADJ/type:_MAINWORDS]  model vol:_MULT_SIZE {___MULT_PHRASE} => $title_templ_vol
        isores [type/type:_DEL_ADJ/type:_MAINWORDS]  model {___MULT_PHRASE} => $title_templ_combined
        color:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  model {___MULT_PHRASE} => $title_templ_color
        color:_MULT_DEFAULT model brand {___MULT_PHRASE} => $title_templ_color
        color:_MULT_DEFAULT isores:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  {___MULT_PHRASE} => $title_templ_color
        color:_MULT_DEFAULT material:_MULT_DEFAULT {___MULT_PHRASE} => $title_templ_color
        isores:_MULT_DEFAULT material:_MULT_DEFAULT {___MULT_PHRASE} => $title_templ_combined
        isores:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  brand {___MULT_PHRASE} => $title_templ_combined
        material:_MULT_DEFAULT model {___MULT_PHRASE} => $title_templ_combined
        age [type/type:_DEL_ADJ/type:_MAINWORDS] => $title_templ_combined
        material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS]  brand {___MULT_PHRASE} => $title_templ_combined
        isores:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ_combined
        material:_MULT_DEFAULT [type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ_combined
        color:_MULT_DEFAULT type {___MAX_10000} {___MULT_PHRASE} => $title_templ_combined
    ";
    return $res;
}

sub _MULT_DEFAULT {
    my ( $self, $txt ) = @_;
    $txt =~ s/\:.+?$//;
    return $txt;
}

sub perf_templates_text {
    my ( $self ) = @_;
    return $self->dyn_templates_text;
}
sub perf_methods_arr {
    my $self = shift;
    return $self->dyn_methods_arr;
}

sub banner_single_templates_text {
    my $self = shift;
    my $title_templ = $self->title_templ;
    return "[type/type:_DEL_ADJ/type:_MAINWORDS] {___MULT_PHRASE} => $title_templ\nmodel => $title_templ\nbrand model => $title_templ\n[type/type:_DEL_ADJ/type:_MAINWORDS] brand model {___MULT_PHRASE} => $title_templ\n brand => $title_templ";
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        modellike_product                       goods accessory P
        get_search_filtered50k                  goods accessory
        add_dynamic_homonymy_words              goods accessory P
        get_wide_filtered                       goods accessory
        postfilter_base                         goods accessory P
        snorm_phrase_list                       goods accessory
        pack_phr_lite                           goods accessory
        pack_list                               goods accessory
        get_search_filtered50k                  goods accessory
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}


=h
#add_dynamic homonymy_words -> add words frow category, derive new relevant phrases (key words)
#modellike_product -> учитывает все варианты записи МОДЕЛИ во фразе (максимально возможное число сочетаний)
#get_wide_filtered -> фильтрует широкие слова из фразы
#add_trade_phrases_dynamic_wear -> добавляет продающие добавки
#get_search_filtered50k -> фильтрует фразы, являющиеся широкими моделями (hight frequency)
#pack_phr_lite -> дубли слов чистит
#postfilter_base -> фильтрация ШУМНЫХ модельных фраз
#spec_pack_list -> удаляет дубли из списка фраз
#get_search_filtered -> фильтрует фразы с низкой чистотой
#set_exclamations_.. -> добавляем восклицательные знаки к предлогам и т.п.
=cut
1;
