package BM::BannersMaker::ProductChildrensGoods;
use strict;
use utf8;
use base qw(BM::BannersMaker::Product);
use Utils::Array;
use Data::Dumper;
use List::Util qw(min max);
use POSIX qw(ceil floor);

my $dbg = 1;

# поля хэша == методы

__PACKAGE__->mk_accessors(qw(
    age
    params
    age_from
    age_to
    age_unit
    full_description
    categpath
    full_model
    country
    sex
    name
    material
    color
    price
    original_type
));

# те поля фида, которые будут инициализированы, это поля tskv как они есть
my @offer_fields = ('возраст ребенка', 'params', 'возраст до', 'возраст от', 'unit', 'description', 'categpath', 'model', 'country_of_origin', 'sex', 'name', 'материал игрушек', 'color', 'price', 'тип', 'images', 'picture', 'bad_flags');

sub get_offer_fields {
    return @offer_fields;
}

my %fields_renaming = (
    'возраст' => 'age',
    'возраст ребенка' => 'age',
    'возраст до' => 'age_from',
    'возраст от' => 'age_to',
    'unit' => 'age_unit',
    'материал игрушек' => 'material',
    'description' => 'full_description',
    'model' => 'full_model',
    'country_of_origin' => 'country',
    'тип' => 'original_type'
);

my %country_to_adjective = (
    'Беларусь' => '!белорусский',
    'Белоруссия' => '!белорусский',
    'Бельгия' => '!бельгийский',
    'Вьетнам' => '!вьетнамский',
    'Германия' => '!немецкий',
    'Индия' => '!индийский',
    'Испания' => '!испанский',
    'Италия' => '!итальянский',
    'Канада' => '!канадский',
    'Китай' => '!китайский',
    'Корея' => '!корейский',
    'Латвия' => '!латвийский',
    'Литва' => '!литовский',
    'Норвегия' => '!норвежский',
    'Польша' => '!польский',
    'США' => 'американский',
    'Турция' => '!турецкий',
    'Украина' => '!украинский',
    'Финляндия' => '!финский',
    'Франция' => '!французский',
    'Чехия' => '!чешский',
    'Швейцария' => '!швейцарский',
    'Швеция' => '!швецкий',
    'Япония' => '!японский',
);

my %material_to_adjective = (
    'кожа' => 'кожаный',
    'пластик' => 'пластиковый',
    'дерево' => 'деревянный',
    'металл' => 'металлический',
    'хлопок' => 'хлопковый',
    'стекло' => 'стеклянный',
    'алюминий' => 'алюминиевый',
    'винил' => 'виниловый',
    'атлас' => 'атласный',
    'бумага' => 'бумажный',
    'резина' => 'резиновый',
    'глина' => 'глиняный',
    'каучук' => 'каучуковый',
    'картон' => 'картонный',
    'лен' => 'льняной',
    'латекс' => 'латексный',
    'металл' => 'металлический',
    'пластмасса' => 'пластмассовый',
    'плюш' => 'плюшевый',
    'полимер' => 'полимерный',
    'сатин' => 'сатиновый',
    'ткань' => 'тканевый',
    'силикон' => 'силиконовый',
    'флис' => 'флисовый',
);

my %years_to_words = (
   1 => 'годовалый',
   2 => 'два год',
   3 => 'три год',
   4 => 'четыре год',
   5 => 'пять год',
   6 => 'шесть год',
   7 => 'семь год',
   8 => 'восемь год',
   9 => 'девять год',
   10 => 'десять год',
   11 => 'одиннадцать год',
   12 => 'двеннадцать год',
);

my $ocasion_re = '(?<RES>((\bдля\h+(купани.+?|кормлени.+?|кормящ.+?\hмам.*?|творчесв.+?|развити.+?|рукодели.+?|вязани.+?|вышивани.+?|беремен.+?|выписк.+?|урок.*?))|(\bна\h+(выписк.+?|крещени.+?|выпускн.+?))))\b';
#|пеленани.+?| убрано, так как такие товары должны быть прописаны в dict_goods

my $two_in_one_re = '\b(?<RES>\d)\h?в\h?1\b';
my $twins_re =  '\b(?<RES>двойн.*?|тройн.*?)\b';
my $season_re =  '\b(?<RES>осенн.*?|зимн.*?|весенн.*?|летн.*?|демисезонн.*?)\b';
my $material_re = '(?:\v|^|\p{P})материал.*?:(?<RES>.*?)(?:\p{P}|$|\v)';
my $pregnant_re = '\b(?<RES>беремен.*?|будущ.*?\h+мам.*?)\b';
my $beginners_re = '\b(?<RES>новичк.*?|начинающ.*?)\b';

#my $epithet_phl;
my $kind_phl;
my $materials_phl;

sub get_age_name_by_digit {
    my $digit = $_[0];
    my @res = ();

    push @res, 'новорожденный' if ($digit == 1);
    push @res, 'грудничок' if ($digit == 1);
    push @res, 'младенец' if ($digit == 1);
    push @res, 'малыш' if ($digit < 6);
    push @res, 'ребёнок' if ($digit < 14);
    push @res, ('подросток', 'подростковый') if ($digit > 12);
    push @res, ('детский') if ($digit < 12);

    return @res;
}

sub init {
    my ($self) = @_;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        for my $param (@offer_fields, $self->get_common_offer_fields) {
            if (exists $fields_renaming{$param}) {
                $self->{$fields_renaming{$param}} = $data->[0]{$param};
            }
            else {
                $self->{$param} = $data->[0]{$param};
            }
        }
    }
    $self->SUPER::init;
    $self->class_init(proj => $self->proj);
}

sub class_init :RUN_ONCE {
    my $class = shift;
    my %par = @_;
    my $proj = $par{proj};

    #$epithet_phl = $proj->phrase_list([qw(красивый классный интересный занимательный стильный авторский надежный нарядный прикольный современный)]);

    $kind_phl = $proj->phrase_list([qw(пиратский историчесий новогодний космический мультяшный летающий мягкий плюшевый интерактивый музыкальный механический сборный говорящий кукольный радиоуправляемый бензиновый развивающий)]);

    $materials_phl = $proj->phrase_list(['дерево', 'дерева', 'деревянный',
        'металл', 'металлический',
        'флис', 'флисовый',
        'шерсть', 'шерстяной',
        'мех', 'меховой',
        'марля', 'марелвый',
        'железо', 'железный',
        'фатина',
        'органза',
        'кожа', 'кожаный',
        'пластик', 'пластиковый',
        'хлопок', 'хлопковый',
        'шёлк', 'шелк', 'шёлковый', 'шелковый',
        'вискоза',
        'лён', 'лен', 'льняной',
        'вискоза',
        'трикотаж', 'трикотажный',
        'лайкра',
        'картон', 'картонный',
        'бумага', 'бумажный',
        'резина', 'резиновый',
        'каучук', 'каучуковый']);
}

########################################################
#Доступ к полям
########################################################

sub ad_type {
    return 'childrens_goods';
}

# как матчится фраза с запросом

sub match_type {
    return 'norm';
}

sub process_monthes {
    #  от 0 до 11 месяцев -> представить в виде 'месяцев'
    # от 12 до 18 месяцев -> представить в виде 'месяцев' и 'лет'
    # от 19 месяцев       -> представить в виде 'лет'

    my ($monthes, $from_or_to) = @_;

    my @res = ();
    push(@res, $from_or_to." ".$monthes.' месяц') if ($monthes <= 18);

    #print "Месяцы после первого push: ", Dumper(\@res), "\n";
    if ($monthes <= 11) {
        return \@res;
    }

    my $year_exact = floor($monthes/12);
    my $month_short = $monthes % 12;

    my $year;
    if ($from_or_to eq 'от') {
        $year = ceil $year_exact;
    }
    elsif ($from_or_to eq 'до') {
        $year = floor $year_exact;
    }

    push @res, ($from_or_to." ".$year." год");
    if (($month_short != 0) and ($monthes <= 18)) {
        push @res, ($from_or_to." ".$year_exact." год ".$month_short." месяц");
    }
    return \@res;
}

sub get_age {
    #TODO: добавить поддержку 'от 3 до 5 лет' -> 3 года, 4 года, 5 лет
    my ($self) = @_;

    my $age_from = '';
    my $age_to = '';

    my $model = $self->model || '';
    my $brand = $self->vendor || '';
    my $description = $self->full_description || '';
    my $age = $self->age || '';
    my $params = $self->params || '';
    my $name = $self->name || '';

    # с 0 до 5 месяцев
    my $age_from_to_re = '(?:^|\h+)(?<PREP_FROM>от|с)\h?(?<DIGIT_FROM>\d+)\h?(?<PREP_TO>до|по)\h?(?<DIGIT_TO>\d+)\h?(?<UNIT>года|лет|мес\.|мес[а-яё]*)(?:$|\h+|\p{P}|\v)';
    # c 0 месяцев
    my $age_from_re = '(?:^|\h+)(?<PREP_FROM>от|с)\h+(?<DIGIT_FROM>\d+)\h+(?<UNIT>года|лет|мес\.|мес[а-яё]*)(?:$|\h+|\p{P}|v)';
    # до 5 лет
    my $age_to_re = '(?:^|\h+)(?<PREP_TO>до|по)\h?(?<DIGIT_TO>\d+)\h?(?<UNIT>года|лет|мес\.|мес[а-яё]*)(?:$|\h+|\p{P}|\v)';

    for my $t (grep { $_ } ($age, $model, $description, $name)) {
        if ($t =~ /$age_from_to_re/i) {
            #нашли возраст

            $age_from = join " ", (map { $+{$_}} qw(PREP_FROM DIGIT_FROM UNIT));
            $age_to = join " ", (map { $+{$_}} qw(PREP_TO DIGIT_TO UNIT));
            return ($age_from, $age_to);
        }

        if ($t =~ /$age_from_re/i) {
            #нашли возраст от
            $age_from = join " ", (map { $+{$_}} qw(PREP_FROM DIGIT_FROM UNIT));
        }
        if ($t =~ /$age_to_re/i) {
            #нашли возраст до
            $age_to = join " ", (map { $+{$_}} qw(PREP_TO DIGIT_TO UNIT));
        }

        return ($age_from, $age_to) if (($age_from ne '') or ($age_to ne ''));
    }

    if (($params) and ($params =~ /(?:,|^)возраст/i)) {

        my $age_unit = $self->age_unit || '';
        #print "AGE UNIT: $age_unit\n";

        if ($params =~ /(?:,|^)возраст\h+(?:от|с):(.*?)(?:,|$)/i) {
            $age_from = $1;
        }

        if ($params =~ /(?:,|^)возраст\h+(?:до|по):(.*?)(?:,|$)/i) {
            $age_to = $1;
        }

        # age_unit_year: 1, если возраст измеряется в годах; 0, если в месяцах
        my $age_unit_year;

        if ((not ($age_unit)) or ($age_unit !~ /^(лет|год.*|мес.*)$/)) {
            # непонятно, какая единица измерения, пытаемся угадать
            $age_unit_year = 1;

            for my $a (grep {$_ =~ /^[\d\-\,\.\ \_]+$/} ($age_from, $age_to, $age)) {
                if ($a >= 18) {
                    # это месяцы, лет так много не может быть
                    $age_unit_year = 0;
                    last;
                }
            }
        }
        elsif (($age_unit) and ($age_unit =~ /^(лет|год.*)$/)) {
            $age_unit_year = 1;
        }
        else {
            # если ничего из этого - месяцы
            $age_unit_year = 0;
        }

        if ($age_unit_year) {
            $age_to = "до ".$age_to." год" if ((defined $age_to) and ($age_to ne ''));
            $age_from = "от ".$age_from." год" if ((defined $age_from) and ($age_from ne ''));
            return ($age_from, $age_to);
        }
        else {
            #print "МЕЕЕЕЕЕЕЕЕЕЕЕЕЕСЯЯЯЯЯЯЯЯЯЯЯЯЦЫ\n";
            # это месяцы
            #  от 0 до 11 месяцев -> представить в виде 'месяцев'
            # от 12 до 18 месяцев -> представить в виде 'месяцев' и 'лет'
            # от 19 месяцев       -> представить в виде 'лет'
            $age_to = join ":", @{process_monthes($age_to, 'до')} if ((defined $age_to) and ($age_to ne ''));
            $age_from = join ":", @{process_monthes($age_from, 'от')} if ((defined $age_from) and ($age_from ne ''));
            #print "&&&&&&&&&&&& AGE TO: $age_to AGE FROM $age_from\n";
            return ($age_from, $age_to) if (($age_from ne '') or ($age_to ne ''));
        }
    }

    $age_from = $self->age_from || '';
    $age_to = $self->age_to || '';
    return ($age_from, $age_to);
}

sub get_age_variants {
    my ($age_from, $age_to) = @_;

    if (($age_from) or ($age_to)) {
        my ($age_from_digit, $age_to_digit) = map {
                my $age = $_;
                return '' unless ($age);

                my $unit;
                if ($age =~ /(год|лет|мес)/i) {
                    $unit = $1;
                }
                $age =~ s/\D//g;
                if (($unit) and ($unit =~ /мес/i)) {
                    $age = POSIX::floor($age / 12);
                }

                $age;
            } ($age_from, $age_to);

        if ($age_from_digit eq '') {
            $age_from_digit = ($age_to_digit - 2 < 0) ? 0 : $age_to_digit - 2;
        }

        if ($age_to_digit eq '') {
            $age_to_digit = $age_from_digit + 2;
        }

        my %age = ();
        $age_to_digit = 16 if $age_to_digit > 16;
        $age_from_digit = 0 if $age_from_digit < 1;
        for my $a ($age_from_digit..$age_to_digit) {
            ++$age{$_} for (get_age_name_by_digit($a));
           # ++$age{$a." лет ребенок"};
            ++$age{$a." лет"};
            if (exists $years_to_words{$a}) {
                ++$age{$_." ребенок"} for (split ":", $years_to_words{$a});
            }
        }

        my $res = "[".(join ":", (grep {$_ ne ''} ($age_from, $age_to, (keys %age))))."]";
        if (($res) and ($res !~ /:/)) {
            $res =~ s/(^\[|\]$)//g;
        }
        return $res;
    }
    return '';
}

sub harmonize_age_title {
    my $text  = $_[0];
    return '' unless ($text);

    #print "* * * harmonize_age_title: $text\n";
    my $prep = '';
    $prep = $1 if ($text =~ /^([а-яА-Я]+)\h+\d/i);
    my ($digit, $unit);
    $digit = $1 if ($text =~ /(\d+)/i);
    $unit = $1 if ($text =~ /\d\s+([а-яА-Я.]+)$/i);
    #print "* * * UNIT: $unit\n";
    my $unit_corrected = '';
    if (($unit) and ($unit =~ /мес/i)) {
        if (($digit % 10 == 1) and ($digit != 11)) {
            $unit_corrected = 'месяца';
        }
        else {
            $unit_corrected = 'месяцев';
        }
    }
    elsif (($unit) and ($unit =~ /год|лет/i)) {
        if (($digit % 10 == 1) and ($digit != 11)) {
            $unit_corrected = 'года';
        }
        else {
            $unit_corrected = 'лет';
        }
    }
    return "$prep $digit $unit_corrected";
}

sub get_sex {
    my $text = $_[0];
    # разваливаем по синонимам всё, что напарсили

    if ($text) {
        my $unisex = '[мальчик:девочка]';
        if ($text =~ /\b(девоч.*)\b/i && $text =~ /\b(мальчик.*)\b/i) {
            return $unisex;
        }
        elsif ($text =~ /\b(девоч.*)\b/i) {
            return 'девочка';
        }
        elsif ($text =~ /\b(мальчик.*)\b/i) {
            return 'мальчик';
        }
        else {
            # если ничего не указано, то считаем, что это для обоих полов
            return $unisex;
        }
    }

}

sub parse :CACHE {
    my ($self) = @_;

    my $old_vendor = $self->vendor || '';
    my $h = $self->SUPER::parse;
#    print STDERR "h after Super::parse:\n", Dumper($h);

    my %properties = ();
    my %size = ();

    # это основной текст
    my $model = $self->full_model || '';
    my $description = $self->full_description || '';
    my $params = $self->params || '';
    my $categpath = $self->categpath || '';
    my $name = $self->name || '';
    my $main_text = join("\n", (grep {$_ ne ''} ($model, $description, $params, $categpath, $name)));

    my $material = $self->material || '';
    my $sex = $self->sex || '';
    my $country = $self->country || '';
    $country = quotemeta $country;
    if (($country) and (%country_to_adjective ~~ /$country/i)) {
        $properties{$country_to_adjective{$country}}++;
    }

    for my $f (qw(model model_weak)) {
        if ($h->{$f}) {
            if ($h->{$f} =~ /(ый|ий|ой|ая|ья|ое|ее|ье|яя|ие|ые|ьи)$/i) {
                my $r = $1;
                next if (($r) and ($r =~ /друзья/i));

                # это "повисшее" прилагательное, идём искать его существиетльное
                $h->{$f} .= " $1" if (($main_text) and ($main_text =~ /\b$h->{$f}\b\h+(.*?)(?:[.,]|\h|$|\v)/));
            }
        }
    }

    # масштаб для модели
    my $scale = '';
    # количество деталей для конструктора
    my $details = '';

    # поищем в тексте всё, что не нашли в прямых методах
    if ($main_text) {

        unless ($sex) {
            if ($main_text =~ /(?:\v|,|^)пол:(?<SEX>.*?)(?:,|$|\v)/i) {
                $sex = $+{'SEX'};
            }
        }

        unless ($material) {
            if ($main_text =~ /$material_re/) {
               $material = $+{'RES'};
            }
        }

        if ($main_text =~ /$ocasion_re/i) {
            $properties{$+{'RES'}}++;
        }

        if ($main_text =~ /$two_in_one_re/i) {
            my $res = $+{'RES'};
            $properties{"$res !в 1"}++;
            $properties{"$res 1"}++;
            $properties{$res."в1"}++;
        }

        if ($main_text =~ /$twins_re/i) {
            $properties{$+{'RES'}}++;
        }

        if ($main_text =~ /$beginners_re/i) {
            $properties{'начинающий'}++;
            $properties{'новичок'}++;
        }

        if ($main_text =~ /$pregnant_re/i) {
            $properties{'беременная'}++;
            $properties{'будущая мама'}++;
        }

        if ($main_text =~ /$season_re/i) {
            $properties{$+{'RES'}}++;
        }

        my $phrase = $self->proj->phrase($main_text);

#        for my $e (@{($epithet_phl->search_subphrases_in_phrase($phrase))->perl_array}) {
#            $properties{$e}++ if ($e ne '');
#        }

        for my $e (@{($kind_phl->search_subphrases_in_phrase($phrase, only_norm => 1))->perl_array}) {
            $properties{$e}++ if ($e);
        }

        if ((not $material) and ($name)) {
            # ищем материал в name
            my @all_materials = @{($materials_phl->search_subphrases_in_phrase($self->proj->phrase($name)))->perl_array};
            if (scalar @all_materials > 0) {
                # добавляем только первый найденный материал
                $properties{$all_materials[0]}++;
            }
        }

        # масштаб
        if ($main_text =~ /\b1(?:\:|\/)(\d{2,3})\b/) {
            $scale = $1;
        }

        if ($params =~ /\bразмер.*?\:(?<RES>.*?)(?:\,|$)/i) {
            my $res = $+{'RES'};
            $res =~ s/\h//g;
            $res =~ s/\*/x/g;
            $size{$res}++;
        }

        if ($h->{qty}) {
            $size{$h->{qty}}++;
        }
        elsif (($main_text =~ /(\d{1,3})\h*шт(?:\h|\p{P}|$|\v)/i) or ($main_text =~ /(?:\h|\p{P})шт(?::|=)\h*(\d{1,4})(?:\h|\p{P}|$|\v)/i)) {
            $size{$1." шт"}++;
            $size{$1." штука"}++;
        }

        if ($h->{vol}) {
            $size{$h->{vol}}++;
        }

        if ($main_text =~ /(?:\v|^|\p{P})тип:(?<TYPE>.*?)(?:\p{P}|\v|$)/) {
            $h->{type_from_params} = $+{'TYPE'};
        }
    }


    if ($material) {
        $properties{$material}++;
        if ($material_to_adjective{$material}) {
            $properties{$material_to_adjective{$material}}++;
        }
    }

    $h->{sex} = get_sex($sex);
    if ($h->{sex}) {
        my $girls = ($h->{sex} =~ /девочк/i) ? 1 : 0;
        my $boys = ($h->{sex} =~ /мальчик/i) ? 1 : 0;
        if ($girls && $boys) {
            # "унисекс" - плохое слово
        }
        elsif ($girls) {
            $h->{sex_title} = 'для девочек';
        }
        elsif ($boys) {
            $h->{sex_title} = 'для мальчиков';
        }
    }

    my ($age_from, $age_to) = $self->get_age;
    #print "^^^^^^ AGES: FROM: $age_from TO: $age_to\n";
    if ($age_from ne '') {
        $h->{age_title} = $age_from;
    }
    elsif ($age_to ne '') {
        $h->{age_title} = $age_to;
    }

    $h->{age_title} = harmonize_age_title($h->{age_title}) if (exists $h->{age_title});

    $h->{age} = get_age_variants(($age_from, $age_to));

    my %models = ();
    for my $f (qw(model model_weak quotes)) {
        if ($h->{$f}) {
            $models{$h->{$f}}++;
            my $text = $h->{$f};

            #бьём по пробелам и знакам препинания
            #++$models{$_} for (grep { $_ !~ /^[a-zA-Zа-яА-Я]{1,3}$/ } (split /\h*\p{P}+\h*/, $text));

            $text =~ s/(^|\h)[-a-zA-Zа-яА-Я]*\d+(^|\h)//g;
            $text =~ s/(^\s+|\s+$)//g;
            $text =~ s/\s+/ /g;
            $models{$text}++ if ($text ne '');
            if (($scale eq '') and ($h->{$f} =~ /(?:^|\h)(\d+)(?:^|\h)/)) {
                $models{$1}++;
            }
        }
    }

    $h->{brand_title} = $h->{brand} if (exists $h->{brand});

    # для model_title выбираем первую модель, не состоящую только из цифр и не равную brand
    for my $f (qw(model model_weak quotes)) {
        if (not exists $h->{$f}) {
            next;
        }
        my $text = $h->{$f};
        if (($h->{brand_title}) and ($text eq $h->{brand_title})) {
            next;
        }

        if ($text) {
            # это удаление артикула
            $text =~ s/\b(([a-zA-Zа-яА-Я0-9]{2,}-?[a-zA-Zа-яА-Я0-9]*\d{2,})|(\d{2,}[-0-9.,-\/\\]*))\b//gi;
            $text =~ s/\s+/ /g;
            $text =~ s/(^\s+|\s+$)//g;

            $h->{model_title} = $text;
            if ($f eq 'quotes') {
                $h->{model_title} = "\"".(ucfirst($text))."\"";
            }
            $models{$text}++;
            last;
        }
    }

    if (not exists $h->{model_title}) {
        for my $f (sort keys %models) {
            if (($f) and ($f =~ /^[- _а-яА-Яa-zA-ZёЁ]+(\h*\d)?$/i)) {
                if (not exists $h->{brand_title}) {
                    $h->{model_title} = $f;
                    $models{$f}++;
                    last;
                }

                if ((exists $h->{brand_title}) and ($f ne $h->{brand_title})) {
                    $h->{model_title} = $f;
                    $models{$f}++;
                    last;
                }
            }
        }
    }

    # удаляем из моделей масштаб, если он там есть
    if ($scale) {
        for my $k (keys %models) {
            if (($k) and ($k =~ /^((1\h+$scale)|($scale\h+1))$/)) {
                delete $models{$k};
            }
        }
    }


    # джойним все модели и кладём в model
    # только после того, как выбрали model_title!
    my $models = join ":", (keys %models);
    if ($models) {
        if ($models =~ /\:/) {
            $models = "[".$models."]";
        }
        $h->{model} = $models;
    }

    $h->{original_type} = $self->original_type || '';

    if (exists $h->{type}) {
        for my $f (qw(model brand)) {
            if ($h->{$f}) {
                my $t = ($self->proj->phrase($h->{$f}) ^ $self->proj->phrase($h->{type}))->text;
                delete $h->{type} if (($t eq '') or (not defined $t));
            }
        }
    }

    # из всех типов выбираем один, самый хороший
    if (not exists $h->{type}) {
        for my $f (qw(type_from_params original_type typePrefix)) {
            if ((exists $h->{$f}) and ($h->{$f} ne '')) {
                $h->{type} = $h->{$f};
                last;
            }
        }
    }

    my $search_for_details = 0;
    for my $f (qw(model type minicategs categpath_short)) {
        if (($h->{$f}) and ($h->{$f} =~ /конструкт|пазл|мозаика|мозайка/i)) {
            # это конструктор, давайте найдём количество деталей в нём
            $search_for_details = 1;
            last;
        }
    }


    if ($search_for_details) {
        if ((exists $h->{qty}) and ($h->{qty} =~ /(\d+)/)) {
            $details = $1;
            $properties{"$details деталь"}++;
            $properties{"$details элемент"}++;
        }
        elsif (($main_text) and (($main_text =~ /(?:(\d+)\h+)(?:детал|элемент|фишек|фишка)/i) or
                                       ($main_text =~ /(?:детал|элемент|фишек|фишка)[^ ]*?:(?:\h*(\d+)\b)/i))) {
            #print "+ + + DETAILS: main_text: $main_text\nresult: $1\n";
            $details = $1;
            $properties{"$details деталь"}++;
            $properties{"$details элемент"}++;
        }
    }

    if (grep {$_} keys %properties) {
        $h->{property} = "[".join(":", (grep { $_ } keys %properties))."]";
        $h->{property_title} = (grep { ($_) and ($_ =~ /для /i) and ($_ !~ /разви/i) } keys %properties)[0];
    }

    if (grep {$_} keys %size) {
        $h->{size} = "[".join(":", (map { my $t = $_; my @r; push @r, $t; $t =~ s/[\.\,]/ /g; @r, $t; } grep { $_ } keys %size))."]";
    }

    # костыль: если есть type_for но нет type, то можно подумать, что мы ошиблись в парсинге
    if (((not exists $h->{type}) or (not $h->{type})) and (exists $h->{type_for})) {
        $h->{type} = $h->{type_for};
        delete $h->{type_for};
    }

    if (exists $h->{type}) {
        $h->{type_title} = $h->{type};
    }

    if ( $h->{type_title} && $h->{model_title} ){
        $h->{model_title} = ( $self->proj->phrase($h->{model_title}) ^ $self->proj->phrase($h->{type_title}) )->text;
    }
    if ( $h->{type_title} && $h->{brand_title} ){
        $h->{brand_title} = ( $self->proj->phrase($h->{brand_title}) ^ $self->proj->phrase($h->{type_title}) )->text;
    }
    if ( $h->{model_title} && $h->{brand_title} ){
        $h->{model_title} = ( $self->proj->phrase($h->{model_title}) ^ $self->proj->phrase($h->{brand_title}) )->text;
    }

    # это модель, указываем масштаб
    if (($scale) and $h->{model_title} and ($h->{model_title} !~ /\b1(\/|:)\b$scale\b/))  {
        if ($h->{model_title} =~ /\b1\s+\b$scale\b/) {
            $h->{model_title} =~ s/(\b1\s+$scale\b)//;
        }
        $h->{model_title} =~ s/\s+/ /g if ($h->{model_title});
        $h->{model_title} .= " 1\:$scale";
    }
    if (($details) and ($h->{model_title}) and ($h->{model_title} !~ /\b$details\b/)) {
        $h->{model_title} .= " $details эл\.";
        $h->{model_title} =~ s/\s+/ /g if ($h->{model_title});
    }
    $h->{model_title} =~ s/(^\s+|\s+$)//g if ($h->{model_title});

    for my $f (qw(type_title model_title brand_title)) {
        if ($h->{$f}) {
            if ($h->{$f} =~ /\bмодел/i) {
                next;
            }
            $h->{$f} =~ s/машина/модель/gi;

            if ($h->{$f} =~ /автомобиль/i) {
                $h->{$f} =~ s/автомобиль/модель/gi;
                $h->{$f} = $self->proj->phrase( $h->{$f} )->harmonize_by_first_noun;
            }
        }
    }

    if ($h->{vol}) {
        $h->{vol_title} = (split ":", $h->{vol})[0];
        $h->{vol_title} =~ s/\[// if ($h->{vol_title});
        delete $h->{vol_title} if ( $h->{vol_title} =~ /\dх\d/ );
    }

    if (((not exists $h->{model}) or ($h->{model} eq '')) and (exists $h->{model_weak})) {
        $h->{model} = $h->{model_weak};
    }
    if (((not exists $h->{model}) or ($h->{model} eq '')) and (exists $h->{quotes})) {
        $h->{model} = $h->{quotes};
    }

    # это тоже вычитание типа из модели
    if ( $h->{type} && $h->{model} ){
        my $mod = $h->{model};
        my $type = $h->{type};

        $mod =~s/(\]|\[)//g if ($mod);
        $type =~s/(\]|\[)//g if ($type);
        my %res = ();

        for my $m (split ":", $mod) {
            my $temp = $m;
            for my $t (split ":", $type) {
                $temp = ( $self->proj->phrase($temp) ^ $self->proj->phrase($t) )->text;
            }
            if ($temp ne '') {
                ++$res{$temp};
            }
        }
        $h->{model} = join ":", (sort keys %res);
        $h->{model} = "[".($h->{model})."]" if (scalar (keys %res) > 1);
    }

    $h->{age} = 'детский' if (not exists $h->{age});
    delete $h->{$_} for (grep { (not defined $h->{$_}) or ($h->{$_} eq '')  } (keys %$h));
    if (($self->minicategs =~ /автомобил|машин/i) and ($h->{brand})) {
        $h->{brand} .= " детский";
    }

#    print STDERR "PARSE:\n", Dumper($h);
    return $h;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title = $class->title_templ;

    my $TYPE = "type/type:_DEL_ADJ";
    my $MODEL = "model/model:_DEL_ADJ";

    my $res = "
        age [$TYPE] {___MULT_PHRASE} => $title
        property [$TYPE] {___MULT_PHRASE} => $title
        brand [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        age property [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        property sex [$TYPE] {___MULT_PHRASE} => $title
        age sex [$TYPE] {___MULT_PHRASE} => $title
        age brand [$TYPE] {___MULT_PHRASE} => $title
        brand property [$TYPE] {___MULT_PHRASE} => $title
        age season [$TYPE] {___MULT_PHRASE} => $title
        size [$TYPE] {___MULT_PHRASE} => $title
        property size [$TYPE] {___MULT_PHRASE} => $title
        season [$TYPE] {___MULT_PHRASE} => $title
        season sex [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] property {___MULT_PHRASE} => $title
        [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        country [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        property season [$TYPE] {___MULT_PHRASE} => $title
        brand sex [$TYPE] {___MULT_PHRASE} => $title
        age season sex [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        age brand [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        age size [$TYPE] {___MULT_PHRASE} => $title
        color property [$TYPE] {___MULT_PHRASE} => $title
        age country [$TYPE] {___MULT_PHRASE} => $title
        age property sex [$TYPE] {___MULT_PHRASE} => $title
        brand size [$TYPE] {___MULT_PHRASE} => $title
        age color [$TYPE] {___MULT_PHRASE} => $title
        color sex [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] sex [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] year {___MULT_PHRASE} => $title
        age property season [$TYPE] {___MULT_PHRASE} => $title
        country property [$TYPE] {___MULT_PHRASE} => $title
        brand country [$TYPE] {___MULT_PHRASE} => $title
        price [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] property {___MAX_10000} {___MULT_PHRASE} => $title
        [$MODEL] property sex {___MAX_10000} [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] size [$TYPE] {___MULT_PHRASE} => $title
        brand color [$TYPE] {___MULT_PHRASE} => $title
        color property sex [$TYPE] {___MULT_PHRASE} => $title
        sex size [$TYPE] {___MULT_PHRASE} => $title
        age brand property [$TYPE] {___MULT_PHRASE} => $title
        age brand [$TYPE] year {___MULT_PHRASE} => $title
        brand [$MODEL] size [$TYPE] {___MULT_PHRASE} => $title
        brand [$TYPE] year {___MULT_PHRASE} => $title
        country [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        age brand sex [$TYPE] {___MULT_PHRASE} => $title
        brand color [$MODEL] {___MULT_PHRASE} => $title
        age brand [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        country sex [$TYPE] {___MULT_PHRASE} => $title
        age property [$TYPE] year {___MULT_PHRASE} => $title
        age [$MODEL] sex [$TYPE] {___MULT_PHRASE} => $title
        brand season sex [$TYPE] {___MULT_PHRASE} => $title
        property sex [$TYPE] year {___MULT_PHRASE} => $title
        brand [$MODEL] sex [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] season [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] season sex [$TYPE] {___MULT_PHRASE} => $title
        age brand season [$TYPE] {___MULT_PHRASE} => $title
        age season [$TYPE] year {___MULT_PHRASE} => $title
        property season sex [$TYPE] {___MULT_PHRASE} => $title
        season sex [$TYPE] year {___MULT_PHRASE} => $title
        brand color [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        age property size [$TYPE] {___MULT_PHRASE} => $title
        color size [$TYPE] {___MULT_PHRASE} => $title
        brand property sex [$TYPE] {___MULT_PHRASE} => $title
        season [$TYPE] year {___MULT_PHRASE} => $title
        color property size [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] [$TYPE] year {___MULT_PHRASE} => $title
        age price [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] size [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] season [$TYPE] {___MULT_PHRASE} => $title
        color [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        brand property [$TYPE] year {___MULT_PHRASE} => $title
        sex [$TYPE] year {___MULT_PHRASE} => $title
        age country season [$TYPE] {___MULT_PHRASE} => $title
        brand property size [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] property sex [$TYPE] {___MULT_PHRASE} => $title
        brand color property [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] season [$TYPE] {___MULT_PHRASE} => $title
        country season sex [$TYPE] {___MULT_PHRASE} => $title
        age [$MODEL] season sex [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] [$TYPE] year {___MULT_PHRASE} => $title
        brand color [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        age property sex [$TYPE] year {___MULT_PHRASE} => $title
        age country sex [$TYPE] {___MULT_PHRASE} => $title
        brand season [$TYPE] year {___MULT_PHRASE} => $title
        brand [$MODEL] property size [$TYPE] {___MULT_PHRASE} => $title
        brand price [$TYPE] {___MULT_PHRASE} => $title
        age brand size [$TYPE] {___MULT_PHRASE} => $title
        country [$MODEL] {___MULT_PHRASE} => $title
        property sex size [$TYPE] {___MULT_PHRASE} => $title
        age brand property [$TYPE] year {___MULT_PHRASE} => $title
        color [$MODEL] property [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] property [$TYPE] year {___MULT_PHRASE} => $title
        brand color [$MODEL] property {___MULT_PHRASE} => $title
        brand country property [$TYPE] {___MULT_PHRASE} => $title
        [$MODEL] property size [$TYPE] {___MULT_PHRASE} => $title
        brand country [$MODEL] [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] season sex [$TYPE] {___MULT_PHRASE} => $title
        age brand country [$TYPE] {___MULT_PHRASE} => $title
        age country property [$TYPE] {___MULT_PHRASE} => $title
        brand sex size [$TYPE] {___MULT_PHRASE} => $title
        brand [$MODEL] {___MULT_PHRASE} => $title
        brand year {___MULT_PHRASE} => $title
        brand color {___MULT_PHRASE} => $title
        brand season [$TYPE] {___MULT_PHRASE} => $title
        brand property {___MAX_10000} {___MULT_PHRASE} => $title
        brand size {___MULT_PHRASE} => $title
        brand country {___MULT_PHRASE} => $title
    ";

    return $res;
}

sub perf_templates_text {
    return $_[0]->dyn_templates_text;
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        add_dynamic_homonymy_words_if_needed    goods accessory P
        get_wide_filtered                       goods accessory
        get_search_filtered50k                  goods accessory
        add_trade_phrases_childrens_goods       goods accessory S
        pack_phr                                goods accessory
        spec_pack_list                          goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}

sub perf_methods_arr {
    return $_[0]->dyn_methods_arr;
}

sub title_templ :GLOBALCACHE {
    my $TYPE = "[type_title/type_title:_MAINWORDS]";
    my $SEX_VOL_AGE = "[sex_title/vol_title/age_title]";
    my $VOL_AGE = "[vol_title/age_title]";

    my @t = (
        "$TYPE property_title brand_title model_title vol_title",
        "$TYPE property_title brand_title model_title",
        "$TYPE brand_title model_title vol_title",
        "$TYPE property_title model_title",

        "$TYPE property_title model_title vol_title",
        "$TYPE model_title sex_title $VOL_AGE",
        "$TYPE model_title sex_title",
        "$TYPE model_title vol_title",

        "$TYPE brand_title model_title",

        "$TYPE property_title brand_title vol_title",
        "$TYPE property_title brand_title",
        "$TYPE brand_title sex_title $VOL_AGE",
        "$TYPE brand_title $SEX_VOL_AGE",
        "$TYPE model_title age_title",
        "$TYPE brand_title",
        "$TYPE model_title",

        "$TYPE property_title sex_title vol_title",
        "$TYPE property_title sex_title",
        "$TYPE sex_title vol_title",
        "$TYPE property_title vol_title",
        "$TYPE property_title",
        "$TYPE sex_title age_title",
        "$TYPE $VOL_AGE",
        "$TYPE",

        "brand_title property_title model_title vol_title",
        "brand_title property_title model_title",
        "brand_title model_title $VOL_AGE",

        "model_title sex_title $VOL_AGE",
        "model_title $SEX_VOL_AGE",
        "model_title",

        "brand_title sex_title $VOL_AGE",
        "brand_title $SEX_VOL_AGE",
        "brand_title"
    );

    return join ",", @t;
}

sub banner_single_templates_text {
    my $self = shift;
    my $title_templ = $self->title_templ;
    return "model_title => $title_templ\ntype_title => $title_templ";
}

1;
