package BM::BannersMaker::ProductDSE;
use utf8;
use strict;

use base qw(BM::BannersMaker::ProductExternal);

__PACKAGE__->mk_accessors(qw(
    name
    url
));

my @offer_fields = qw{bl_phrases bl_title bl_title_perf bl_long_title name url domain source_letter offerfilters flags merge_key};

sub init {
    my ($self) = @_;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields, $self->get_common_offer_fields;
    }
}

sub match_type {
    return 'norm';
}

sub add_banner_fields {
    my $self = shift;
    my $arr = shift;
    for my $h (@$arr) {
        $h->{flags} = $self->{flags};  # if $self->{flags} ??
        $h->{name} = $self->{name};
        $h->{match_type} = $self->match_type;
    }
}

sub dyn_templates_text {
    return 'bl_phrases => bl_title';
}
sub perf_templates_text {
    return 'bl_phrases => bl_title_perf';
}

sub banner_single_templates_text {
    my $self = shift;
    return $self->perf_templates_text;
}

sub template_name {
    return 'dse';
}

sub title_source {
    return 'dse';
}

sub long_title_field {
    return 'bl_long_title';
}

sub dyn_banners {
    my $self = shift;
    my ($arr, $rpc) = $self->SUPER::dyn_banners(@_);
    if ($arr) {
        $self->add_banner_fields($arr);
        return $arr;
    }
    return (undef, $rpc);
}

sub perf_banners {
    my $self = shift;
    my ($arr, $rpc) = $self->SUPER::perf_banners(@_);
    if ($arr) {
        $self->add_banner_fields($arr);
        return $arr;
    }
    return (undef, $rpc);
}


1;
