package BM::BannersMaker::ProductExternal;
use utf8;
use strict;

use base qw(BM::BannersMaker::Product);

use Utils::Sys;

__PACKAGE__->mk_accessors(qw(
    name
    url
));

my @offer_fields = qw{phrases name url domain source_letter offerfilters flags merge_key};

sub init {
    my ($self) = @_;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

sub ad_type {
    return 'retail';
}

sub parse {
    return {};  # nothing to do, all in self
}

sub dyn_methods_arr {
    return ();
}
sub perf_methods_arr {
    return ();
}

# задаём названия полей через шаблоны, так как работаем через banners_data
# см. также ProductDSE
sub dyn_templates_text {
    return 'phrases => ';
}
sub perf_templates_text {
    return 'phrases => ';
}
sub banner_single_templates_text {
    my $self = shift;
    return $self->perf_templates_text;
}
sub template_name {
    return 'SCHPHRASE';
}

sub long_title_field {
    return;
}

sub title_source {
    return '';
}

sub process_templates {
    my $self = shift;
    my $tmpl = shift;
    my $ps = shift;
    my %par = @_;

    my ($text_fld, $title_fld) = split /\s*=>\s*/, $tmpl;
    $text_fld =~ s/\s//g;
    $title_fld =~ s/\s//g;

    my $need_long_title = $par{LONG_TITLE_LEN} > 0 ? 1 : 0;
    my @phrs;
    for my $phr (split /,/, $self->{$text_fld}) {
        $phr =~ s/:.+:.+$//;
        # TODO: i-gataullin удалить проверку на dyn_banners_dummy_phrase после DYNSMART-1317
        push @phrs, $phr if $phr ne $self->proj->options->{dyn_banners_dummy_phrase};
    }
    my $title = '';
    if ($title_fld) {
        $title = $self->proj->make_bs_compatible_or_empty($self->{$title_fld});
    }
    my $long_title = '';
    my $long_title_field = '';
    if ($need_long_title) {
        $long_title_field = $self->long_title_field // $title_fld;
        if ($long_title_field) {
            $long_title = $self->proj->make_bs_compatible_or_empty($self->{$long_title_field});
        }
    }
    # фильтруем по наличию символов, запрещенных в базе движка
    @phrs = grep {Utils::Sys::is_ucs2_compatible($_)} @phrs;
    return ({
        phl => $self->proj->phrase_list(\@phrs),
        title => $title,
        title_template => $title_fld,
        $need_long_title ? (long_title => $long_title) : (),
        $need_long_title ? (long_title_template => $long_title_field) : (),
        template => $self->template_name,
    });
}

# кэш не нужен, потому что фразы уже есть и хранятся в памяти
sub dyn_banners_cached {
    my $self = shift;
    return $self->dyn_banners(@_);
}

1;
