package BM::BannersMaker::ProductFurniture;
use utf8;
use strict;

use base qw(BM::BannersMaker::Product);
use Utils::Array;
use Data::Dumper;
use List::Util qw(min max);

__PACKAGE__->mk_accessors(qw(
    vendor
    model
    color
    material
    corpus
    size
    length
    width
    height
    unit
));

my @offer_fields = qw{color material corpus size length width height unit};

sub get_offer_fields {
    return @offer_fields;
}

our $materials_re = "акрил|алюминий|береза|брус|бук|венге|дcп|дcп/металл|дерево|древесно-волокнистый|дсп|дсп/мдф|дуб|жаккардовая|жаккард|зебрано|искусственная замша|искусственная кожа|искусственная кожа|искусственное дерево|искусственный ротанг|кдсп|клен|кожа|кожезаменитель|латунь|лдcп|лдcп/металл|лдcп/стекло|лдcп/шпон|лдсп|лдсп/мдф|лдсп/металл|лфб|массив|мдф|мдф/шпон|металл|металл/пластик|металл/стекло|мрамор|натуральная кожа|нержавеющая сталь|орех|оцинкованная|пвx|пластик|поликарбонат|полипропилен|полиуретан|полиэстер|полиэтилен|пробка|пэт|ротанг|слоновая кость|сосна|сталь|стекло|стекло/алюминий|ткань|ткань/сетка|фанера|флокированный|хром|хромированный|шпон|шпонированный|экокожа|ясень";

sub init {
    my ($self) = @_;
    $self->SUPER::init;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

########################################################
#Доступ к полям
########################################################

sub ad_type {
    return 'furniture';
}

sub match_type {
    return 'norm';
}

sub dict_materials :GLOBALCACHE {
    my %res = ();
    $res{$_}++ for ( split /\|/, $materials_re );
    return \%res;
}

sub parse :CACHE {
    my ($self) = @_;

    my $h = $self->SUPER::parse;
#    print STDERR Dumper ( $h );

    # предохраняемся от случайных типов
    if ( $h->{type} ){
        $h->{type} = '' unless $self->proj->phrase( $h->{type} )->get_goods;
    }

    # парамсы отдельной строкой в поле
    if ( $self->{params} ){
        $h->{params} = $self->_parse_params( $self->{params} );
    }

    # если модели нет, пытаемся выпарсить слабую модель
    if ( !$h->{model} && $self->txtsource ){
        my %hpweak = $self->proj->phrase( $self->txtsource )->parse( weak=>1 );
#        print STDERR Dumper ( ['weak', \%hpweak] );
        $h->{model} = $hpweak{model_weak} if $hpweak{model_weak};
        $h->{quotes} = $hpweak{quotes} if $hpweak{quotes};
        $h->{model} = '' if ( $h->{quotes} && $h->{model} && lc($h->{quotes}) eq lc($h->{model}) );
        $h->{model} = '' if ( $h->{brand} && $h->{model} && lc($h->{brand}) eq lc($h->{model}) );
#        $h->{model} = $h->{quotes} if ( !$h->{model} && $h->{quotes} );
    }

    # определяем размер
    if ( $h->{vol} ){
        $h->{vol} =~ s/\:.+$//; # если выпарсилось несколько размеров, оставляем первый
        $h->{vol} =~ s/[ ,]//g;
        $h->{vol} =~ s/\s+[a-zа-яё]+$//i;
        # оставляем только длинаXширина. все, что дальше удаляем
        $h->{vol} =~ s/(\d+(\.\d+)?)\s*(x|X|х|Х|\*)\s*(\d+(\.\d+)?)\s*(x|X|х|Х|\*)\s*(\d+(\.\d+)?).*$/$1x$4/g;
        $h->{vol} = '' unless $h->{vol} =~ /^\s*[0-9.]+\s*(?:(?:x|х|\*)\s*[0-9.]+\s*){1,2}$/;
    }
    if ( !$h->{vol} && $self->{size} ){
        $self->{size} =~ s/\s+[a-zа-яё]+$//i if $self->{size};
        $self->{size} =~ s/[ ,]//g if $self->{size};
        # оставляем только длинаXширина. все, что дальше удаляем
        $self->{size} =~ s/(\d+(\.\d+)?)\s*(x|X|х|Х|\*)\s*(\d+(\.\d+)?)\s*(x|X|х|Х|\*)\s*(\d+(\.\d+)?).*$/$1x$4/g;
        $h->{vol} = $self->{size} if $self->{size} =~ /^\s*[0-9.]+\s*(?:(?:x|х|\*)\s*[0-9.]+\s*){1,2}$/;
    }

    # у измерений оставляем только цифры
    for my $dimension ( qw/length width height/ ){
        next unless $self->{$dimension};
        $self->{$dimension} =~ s/\s+[a-zа-яё]+$//i;
        $self->{$dimension} =~ s/[ ,]//g;
        $self->{$dimension} = '' unless $self->{$dimension} =~ /^[0-9.]+$/;
    }

    # длина и ширина с конвертацией мм в см
    if ( $h->{vol} ){
        my $is_conv_needed = 0;
        $is_conv_needed = 1 if ( $self->{unit} && lc($self->{unit}) eq 'мм' || $self->{length} && length($self->{length}) > 3 || $self->{width} && length($self->{width}) > 3 );
        $self->{length} = 0.1*$self->{length} if ( $self->{length} && $is_conv_needed );
        $self->{width} = 0.1*$self->{width} if ( $self->{width} && $is_conv_needed );
        $self->{height} = 0.1*$self->{height} if ( $self->{height} && $is_conv_needed );
    }

    # заново собираем vol
    if ( $self->length && $self->width ){
        if ( $h->{type} && $h->{type} =~ /(?:^|\s)(?:матра(?:с|ц)|кровать)(?:\s|$)/i ){
            $h->{vol} = $self->width.'x'.$self->length;
        } else {
            $h->{vol} = $self->length.'x'.$self->width;
        }
    }
    if ( !$self->length && $self->width && $self->height ){
        $h->{vol} = $self->width.'x'.$self->height;
    }
    $h->{title_vol} = $h->{vol};

    # для диванов берем длину, для кроватей и матрасов - ширину
    if ( $h->{type} && $h->{type} =~ /(?:^|\s)(?:матра(?:с|ц)|кровать)(?:\s|$)/i ){
        $h->{vol} = join( ':', map { $_ || () } ( $h->{vol} || '', $self->{width} || '' ) );
    }
    if ( $h->{type} && $h->{type} =~ /(?:^|\s)диван(?:\s|$)/i ){
        $h->{vol} = join( ':', map { $_ || () } ( $h->{vol} || '', $self->{length} || '' ) );
    }
    $h->{vol} = '['.$h->{vol}.']' if ( $h->{vol} );

    # материал сначала пытаемся достать из модели
    if ( $h->{model} ){
       ( $h->{model}, my $arr_materials ) = $self->proj->phrase( $h->{model} )->cut_subphrases_by_dict( $self->dict_materials, 1 );
       $h->{material} = $arr_materials->[0] if @$arr_materials;
    }
    # потом из парамс - корпус и материал
    my $hdict_materials_norm = $self->proj->phrase->_norm_hash_keys( $self->dict_materials );
    if ( !$h->{material} ){
        for my $param ( grep { $self->{$_} } qw/corpus material/ ){
            my $param_safe_norm = $self->proj->phrase( $self->{$param} )->norm_phr_safe || '';
            $h->{material} = $self->{$param} if ( $param_safe_norm && $hdict_materials_norm->{$param_safe_norm} );
            last if $h->{material};
        }
    }
    # потом из name или params
    if ( !$h->{material} && ( $self->name || $h->{params} ) ){
       my $params_norm = '';
       my $params_line;
       $params_line = join(' ', split(/\:/, $h->{params})) if $h->{params};
       my $text = join(' ',  ($self->name || '', $params_line || '') );
       ( undef, my $arr_materials ) = $self->proj->phrase( $text )->cut_subphrases_by_dict( $self->dict_materials, 1 ) if $text;
       $h->{material} = $arr_materials->[0] if @$arr_materials;
    }

    $h->{color} ||= $self->{color} if ( $self->{color} && $self->{color} =~ /^[ \-a-zA-Zа-яёА-ЯЁ]+$/ );

    if ( $h->{shopname} && $h->{brand} ){
        my $shopname_re = quotemeta $h->{shopname};
        my $brand_re = quotemeta $h->{brand};
        $h->{shopname} = '' if ( $h->{brand} =~ /$shopname_re/ || $h->{shopname} =~ /$brand_re/ );
    }

    foreach my $field (grep {$h->{$_}} keys %$h) {
        $h->{$field} =~ s/\s+/ /g;
        $h->{$field} =~ s/(^\s+|\s+$)//g;
    }

    delete $h->{model} if $h->{model} && length($h->{model}) < 2; # режем однобуквенные модели
    delete $h->{$_} for grep {!$h->{$_}} keys %$h;

    return $h;
}

sub _parse_params {
    my ( $self, $text ) = @_;
    my $params = '';
    my @allparams = ();
    for my $kv ( split /\,/, $text ){
        next unless $kv;
        my $param = '';
        my ($k, $v) = split/\:/, $kv;
        next if $k =~ /^(?:кол-во|количество|дизайн)$/;
        $param = $kv unless $kv =~ /\:/;
        $param ||=  in_array($v,[qw/да есть еcть/]) ? $k : $v;
        $param = $self->_filter_param( $param );
        next unless $param;
        push @allparams, $param;
    }
    $params = join(':',uniq_array(@allparams)) if @allparams;
    return $params;
}

sub _filter_param {
    my ( $self, $text ) = @_;
    my $ban_re = "без|мультиколор|нет|средни|готовы|стандартн|требуется|искуственн|искусственн";
    return '' if $text =~ /(?:$ban_re)/;
    return '' if length ($text) < 2;
    return '' if ( $text =~ /^[\d,.]+$/ && $text !~ /^\d+$/ );
    return '' if ( $text =~ /^[a-zа-я]+$/ && length($text)<3 );
    return $text;
}

sub title_templ {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL], [type/type:_DEL_ADJ/type:_MAINWORDS] [model/model:_SHORT_MDL], [type/type:_DEL_ADJ/type:_MAINWORDS] brand, [type/type:_DEL_ADJ/type:_MAINWORDS], [type:_MULTIDOT_END]";
    return $res;
}

sub perf_title_templ {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL] (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] [model/model:_SHORT_MDL] (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] brand (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] (title_vol), [type:_MULTIDOT_END] (title_vol)";
    return $res;
}

sub title_templ_quotes {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] quotes:_QTS brand, [type/type:_DEL_ADJ/type:_MAINWORDS] quotes:_QTS, [type/type:_DEL_ADJ/type:_MAINWORDS] brand, [type/type:_DEL_ADJ/type:_MAINWORDS], [type:_MULTIDOT_END]";
    return $res;
}

sub perf_title_templ_quotes {
    my $res = "[type/type:_DEL_ADJ/type:_MAINWORDS] quotes:_QTS brand (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] quotes:_QTS (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] brand (title_vol), [type/type:_DEL_ADJ/type:_MAINWORDS] (title_vol), [type:_MULTIDOT_END] (title_vol)";
    return $res;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title_templ = $class->title_templ;
    my $title_templ_quotes = $class->title_templ_quotes;
    my $res = "
        [type/type:_DEL_ADJ/type:_MAINWORDS] model => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] quotes => $title_templ_quotes
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand model => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand quotes => $title_templ_quotes
        [type/type:_DEL_ADJ/type:_MAINWORDS] vol {___MULT_PHRASE} => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] material => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] color => $title_templ
    ";
    return $res;
}

sub perf_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title_templ = $class->perf_title_templ;
    my $title_templ_quotes = $class->perf_title_templ_quotes;
    my $res = "
        [type/type:_DEL_ADJ/type:_MAINWORDS] model => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] quotes => $title_templ_quotes
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand model => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] brand quotes => $title_templ_quotes
        [type/type:_DEL_ADJ/type:_MAINWORDS] vol {___MULT_PHRASE} => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] material => $title_templ
        [type/type:_DEL_ADJ/type:_MAINWORDS] color => $title_templ
    ";
    return $res;
}

sub banner_single_templates_text {
    my $self = shift;
    return $self->perf_templates_text;
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        add_dynamic_homonymy_words              goods accessory P
        modellike_product                       goods accessory P
        get_wide_filtered                       goods accessory
        add_trade_phrases_dynamic_wear          goods accessory S
        get_search_filtered50k                  goods accessory
        pack_phr_lite                           goods accessory
#        postfilter_base                         goods accessory
        spec_pack_list                          goods accessory
        get_search_filtered                     goods accessory
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}

1;
