package BM::BannersMaker::ProductGames;
use warnings;
use strict;
use utf8;

use base qw(BM::BannersMaker::Product);
use Utils::Array;
use Data::Dumper;
use List::Util qw(min max);
use Utils::Sys qw(uniq);

__PACKAGE__->mk_accessors(qw(
    price
    sales_notes
    params
));

my @offer_fields = qw(model sales_notes params);

sub get_offer_fields {
    return @offer_fields;
}

sub init {
    my ($self) = @_;
    my $data = $self->{data}; 
    if(ref($data->[0]) eq 'HASH'){
        for my $param (@offer_fields) {
            $self->{$param} = $data->[0]{$param};
        }
    }
    $self->SUPER::init;
}


########################################################
#Доступ к полям
########################################################

sub ad_type {
    return 'games';
}

# как матчится фраза с запросом
sub match_type {
    return 'norm';
}

sub clean{
    my ($phrase) = @_;
    $phrase =~ s/(\s+|^)(([-.a-zA-Zа-яА-ЯёЁ]{1,3}\d+)|(\d+[-.a-zA-Zа-яА-ЯёЁ])|\d{3,})[^\s]*//g;
    $phrase =~ s/\s*\b(см|шт|гр|мм|м)\b\s*//gi;
    $phrase =~ s/\s*\b(на|для|в|про|через|с|до|по|к|перед)$//gi;
    $phrase =~ s/\s+детал(ей|ь|и)\b//g;
    return $phrase;
}

sub add_brackets{
    my ($phrase) = @_;
    $phrase =~ s/\b((?:(?:новое|юбилейное|основное)\s+издание|переиздание|дополнение|(новая|дорожная)\s+версия)(?:(?:\s+(?:и|с)\s+)?дополнением?)?)\b/($1)/gi;
    # если осталось какое-нибудь хитрое издание, удаляем его
    $phrase =~ s/(\s*издание(.*\())|((.*\))\s*издание)//gi;
    if ($phrase !~ /\(/) {
        # во фразе вообще нет скобок
        $phrase =~ s/\s*издание\b//gi;
    }
    return $phrase;
}

sub get_age {
    my ($age_from, $age_to) = @_;
    my @res = ();

    if (not $age_from or $age_from < 1) {
        $age_from = 1;
    }
    if (not $age_to or $age_to > 18) {
        push @res, 'для пенсионеров';
        push @res, 'для взрослых';
        $age_to = 16;
    }

    if ($age_from < 12) {
        push @res, 'детская';
    }

    for my $age (($age_from..$age_to)) {
        my $common_word = '';
        $common_word = 'для детей' if ($age < 12);
        $common_word = 'для подростков' if ($age >= 13);
        push @res, "для $age лет";
        push @res, $common_word." $age лет";
        push @res, $common_word;
    }
    @res = uniq @res;
    return "[".(join ":", @res)."]";
}

sub get_players {
    my ($players_from, $players_to) = (@_);
    return '' unless ($players_from or $players_to);

    if ($players_from and not $players_to) {
        $players_to = $players_from + 5;
    }
    elsif (not $players_from and $players_to) {
        $players_from = $players_to - 5;
        $players_from = 1 if ($players_from < 1);
    }

    # print STDERR "PLAYERS: $players_from - $players_to\n"; 
    my @res = ();
    if ($players_to > 8) {
        push @res, "для большой компании"; 
    }
    for my $player (($players_from..$players_to)) {
        if ($player <= 4) {
            push @res, "на $player игроков";
            if ($player == 2) {
                push @res, "для двоих игроков";
                push @res, "для двух игроков";
                push @res, "на двоих игроков";
                push @res, "на двух игроков";
            } elsif ($player == 1) {
                push @res, "для одного игрока";
                push @res, "на одного игрока";
            }
        }
    }

    @res = uniq @res;
    return "[".(join ":", @res)."]";
}

sub parse :CACHE {
    my ($self) = @_;

    my $old_name = $self->name || ""; 
    my $h = $self->SUPER::parse;
    my $old_model_weak = $h->{model_weak} || "";
    #print STDERR "OUR GAMES PARCE\nh after Super::parse:\n", Dumper($h);
    unless ($old_name) {
        $old_name = $h->{src} || "";
    }

    my $brand_type = '';
    for my $f (qw(brand type)) {
        if (exists $h->{$f} and $h->{$f}) {
            if ($brand_type) {
                $brand_type .= " ".($h->{$f});
            }
            else {
                $brand_type = $h->{$f};
            }
        }
    }

    if ($old_name) {
        $old_name = ($self->proj->phrase($old_name) ^ $self->proj->phrase($brand_type))->text;
        $old_name = clean($old_name) if ($old_name);
        if (length $old_name > 33) {
            # считаем, что это плохой old_name, если он длиннее трёх слов
            $old_name = undef;
        }
    }

    # ищем модель, в ней обычно содержится название игры
    # ищем новую модель, только если старая "плохая": её нет, в ней больше 3 слов или она содержит буквенно-цифровые куски типа артикула

    if ($old_name) {
        if (exists $h->{model} and $h->{model}) {
            if ($h->{model} ne $old_name) {
                $h->{model} = $old_name;
            }
        }
        elsif (exists $h->{model_weak} and $h->{model_weak}) {
            # нет model, но есть model_weak
            if ($h->{model_weak} ne $old_name) {
                $h->{model_weak} = $old_name;
            }
        }
    }

    for my $m (grep { $_  =~ /model/ } keys %$h) {
        my $model_clean = ($self->proj->phrase($h->{$m}) ^ $self->proj->phrase($brand_type))->text;
        $model_clean = clean($model_clean);
        $h->{$m} = $model_clean if ($model_clean);
    }

    unless ((exists $h->{model}) or (exists $h->{model_weak})) {
        # никакая из моделей не существует, запихнём то, что выпарсили из old_name
        $h->{model} = $old_name if ($old_name);
    }

    # делаем из Игра "Дворовая" -> Дворовая игра
    for my $m (grep { (exists $h->{$_}) and $h->{$_} } qw(model model_weak)) {
        if (   ((not ($h->{$m} =~ /\s/)) and ($h->{$m} =~ /(ые|ие)$/) and (exists $h->{type}) and ($h->{type} =~ /ы$/))
            or ((not ($h->{$m} =~ /\s/)) and ($h->{$m} =~ /(ая|ыя|яя|ья)$/) and (exists $h->{type}) and ($h->{type} =~ /а$/))) {
            $h->{$m} = $h->{$m}." ".$h->{type};
            delete $h->{type};
        }
    }

    # а вдруг всё-таки первая модель была круче?
    if ($old_model_weak) {
        my @old_words = split /\s+/, $old_model_weak;
        # только если там было меньше 3 слов
        if (@old_words <= 3) {
            for my $m (qw(model model_weak)) {
                my @new_words = 0;
                if (exists $h->{$m}) {
                    @new_words = split /\s+/, $h->{$m};
                }
                if (scalar @old_words > scalar @new_words) {
                    $h->{$m} = clean($old_model_weak);
                }
            }
        }
    }

    # удаление повторений
    if ($h->{model} and $h->{model_weak} and ($h->{model} eq $h->{model_weak})) {
        delete $h->{model_weak};
    }
    if ($h->{type} and $h->{model_weak} and (lc($h->{type}) eq lc($h->{model_weak}))) {
        delete $h->{type};
    }
    if ($h->{type} and $h->{model} and (lc($h->{type}) eq lc($h->{model}))) {
        delete $h->{type};
    }

    if (exists $h->{type} and $h->{type}) {
        my @words_in_type = split /\s+/, $h->{type};
        for my $m (grep { (exists $h->{$_}) and $h->{$_} } qw(model model_weak)) {
            if (@words_in_type >= 4) {
                # считаем, что type достаточно большой и красивый, чтобы больше ничего не добавлять
                delete $h->{$m};
            }
            # проверяем: если type вмещает в себя весь model или model_weak, удаляем model/model_weak
            my $model_without_type = ($self->proj->phrase($h->{$m}) ^ $self->proj->phrase($h->{type}))->text;
            unless ($model_without_type) {
                delete $h->{$m};
            }
        }
    }

    for my $f (grep { (exists $h->{$_}) and $h->{$_} } qw(model model_weak type)) {
        $h->{$f} = add_brackets($h->{$f});
    } 

    # костылище
    if ($h->{brand} and $h->{model} and ($h->{brand} =~ /Leader/i) and ($h->{model} =~ /(^Mr\s+)(.*)/i)) {
        $h->{model} = $1.($h->{brand})." $2";
        delete $h->{brand};
    }
 
    # костылище
    if ((exists $h->{type}) and ($h->{type} =~ /летучая мышь/i) and (exists $h->{model}) and ($h->{model} =~ /где ты/i)) {
        $h->{type} = 'игра';
        $h->{model} = 'Летучая мышь, где ты?';
    }

    $h->{$_."_quotes"} = '"'.ucfirst($h->{$_}).'"' for (grep { (exists $h->{$_}) and $h->{$_} } qw(model model_weak));

    my $params = $self->params || '';
    if ($params) {
        my @vals = split /,\s*/, $params;
        my ($age_from, $age_to, $players_from, $players_to) = ();
        for my $v (@vals) {
            if ($v =~ /возраст от:\s*(\d+)/) {
                $age_from = $1;
            } elsif ($v =~ /возраст до:\s*(\d+)/) {
                $age_to = $1;
            } elsif ($v =~ /(?:число|количество)\s+игроков:\s*(.*)$/) {
                my $players = $1;
                if ($players =~ /\s*(\d+)\s*-\s*(\d+)/) {
                    $players_from = $1;
                    $players_to = $2;
                } elsif ($players =~ /\s*(\d+)\+/) {
                    $players_from = $1;
                    $players_to = '';
                } elsif ($players =~ /\s*(\d+)/) {
                    $players_from = $1;
                    $players_to = $1;
                } elsif ($players =~ /(?:от\s*(\d+)\s*)?(?:до\s*(\d+))?/) {
                    $players_from = $1;
                    $players_to = $2;
                }

                if ($players_from or $players_to) {
                    $h->{players} = get_players($players_from, $players_to);
                }
            }
        }

        $h->{age} = get_age($age_from, $age_to);
    }
    
    my $sales = $self->sales_notes || '';
    if ($sales and $sales =~ /скидк|акци/) {
        $h->{sales} = "[скидка:акция:распродажа]";
    }

    # костыль!
    if ((not exists $h->{type}) or (not $h->{type})) {
        $h->{type} = 'игра';
    }

    #print STDERR "URL: ".($self->url)."\n";
    #print STDERR "PARAMS: ".($self->params)."\n";
    #print STDERR "======\n", Dumper($h), "=========\n";
    return $h;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title = $class->title_templ;

    my $TYPE = "[type/type:_DEL_ADJ]";
    my $MODEL = "[model/model:_DEL_ADJ]";

    my $res = "
        age brand $MODEL $TYPE {___MULT_PHRASE} => $title
        age brand $TYPE {___MULT_PHRASE} => $title
        age $MODEL $TYPE {___MULT_PHRASE} => $title
        age $TYPE {___MULT_PHRASE} => $title
        age $MODEL {___MULT_PHRASE} => $title
        brand $MODEL {___MULT_PHRASE} => $title
        brand $TYPE {___MULT_PHRASE} => $title
        brand $MODEL $TYPE {___MULT_PHRASE} => $title
        $MODEL $TYPE {___MULT_PHRASE} => $title
        sales $MODEL {___MULT_PHRASE} => $title
        sales $TYPE {___MULT_PHRASE} => $title
        players $TYPE {___MULT_PHRASE} => $title
        players $MODEL {___MULT_PHRASE} => $title
    ";

    return $res;
}

sub perf_templates_text {
    return $_[0]->dyn_templates_text;
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        add_dynamic_homonymy_words              goods accessory P
        get_wide_filtered                       goods accessory
        get_search_filtered2k                   goods accessory
        add_trade_phrases_childrens_goods       goods accessory S
        pack_phr                                goods accessory
        spec_pack_list                          goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}

sub perf_methods_arr {
    return $_[0]->dyn_methods_arr;
}

sub title_templ :GLOBALCACHE {
    my @t = (  
        "type model_quotes",
        "type model",

        "type:_DEL_ADJ model_quotes",
        "type:_DEL_ADJ model",

        "type:_MAINWORDS model_quotes",
        "type:_MAINWORDS model",

        "type model_weak_quotes",
        "type model_weak",

        "type:_DEL_ADJ model_weak_quotes",
        "type:_DEL_ADJ model_weak",

        "type:_MAINWORDS model_weak_quotes",
        "type:_MAINWORDS model_weak",

        "model_quotes",
        "model",

        "type",
    ); 

    return join ", ", @t;
}

sub banner_single_templates_text :GLOBALCACHE("DERIVED") {
    my $self = shift;

    my $title_templ = $self->title_templ;
    my $TYPE = "[type/type:_MAINWORDS]";
    my $MODEL = "[model/model:_MAINWORDS/model_weak/model_weak:_MAINWORDS]";
    
    my @templates_text = (
            "$TYPE brand $MODEL  {___MULT_PHRASE} => $title_templ",
            "$TYPE brand age  {___MULT_PHRASE} => $title_templ",
            "$TYPE $MODEL age  {___MULT_PHRASE} => $title_templ",
            "brand $MODEL age  {___MULT_PHRASE} => $title_templ",
            "$TYPE brand  {___MULT_PHRASE} => $title_templ",
            "$TYPE $MODEL  {___MULT_PHRASE} => $title_templ",
            "$TYPE age  {___MULT_PHRASE} => $title_templ",
            "$TYPE players  {___MULT_PHRASE} => $title_templ",
            "$TYPE sales  {___MULT_PHRASE} => $title_templ",
    );
    return join("\n", @templates_text);
}

1;
