package BM::BannersMaker::ProductHotels;

use strict;
use utf8;

use base qw(BM::BannersMaker::Product);
use utf8;
use Data::Dumper;
use List::Util qw(min);
use Utils::Sys qw(uniq);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    country
    location
    class
    Address
    property_type
    facilities
));

my @offer_fields = qw{type country location class Address property_type images bad_flags picture facilities };

our %h_type_map = (
    'hotel' => 'отель:гостиница',
    'отель' => 'отель:гостиница',
    'мотель' => 'отель:гостиница',
    'гостиница' => 'гостиница:отель',
    'apartments' => 'апартаменты:apartments',
    'apartment' => 'апартаменты:apartments',
    'апартаменты' => 'апартаменты:apartments',
    'апартамент' => 'апартаменты:apartments',
    'аппартаменты' => 'апартаменты:apartments',
    'аппартамент' => 'апартаменты:apartments',
    'hostel' => 'хостел:hostel',
    'хостел' => 'хостел:hostel',
    'villa' => 'вилла:villa',
    'вилла' => 'вилла:villa',
    'гестхаус' => 'гестхаус:гостевой дом',
    'гостевой дом' => 'гестхаус:гостевой дом',
    'дом для отдыха' => 'дом для отдыха:дом отдыха:база отдыха',
    'дом отдыха' => 'дом для отдыха:дом отдыха:база отдыха',
    'база отдыха' => 'дом для отдыха:дом отдыха:база отдыха',
);

sub init {
    my ($self) = @_;
    $self->SUPER::init;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

sub ad_type {
    return 'hotel';
}

sub match_type {
    return 'norm';
}

sub are_all_first_letters_capital {
    my $txt = $_[0];
    my @words = split /\s+/, $txt;
    for my $w (@words) {
        return 0 if ($w =~ /^a-zа-яё/);
    }
    return 1;
}

sub parse :CACHE {
    my ($self) = @_;
    my $h = {};
    $h->{$_} = $self->{$_} for ( qw/name country type location class Address/ );
#print STDERR Dumper ( $h );

    # определяем type
    # если поле type есть в фиде, то на этом моменте оно должно быть уже определено
    my $phl_type = $self->proj->phrase_list( [ 'отель','гостиница','мини-отель','апартаменты', 'хостел', 'hotel', 'apartments', 'hostel', 'suites', 'парк-отель', 'спа-отель' ] );
    if ( !$h->{type} ) {
        # если type не опредеён, пытаемся достать его из property_type ...
        if ($self->property_type ) {
            $h->{type} = lc($self->property_type);
        }
        elsif ( $h->{name} ) {
        # ... или из названия отеля
            my $source_text = join (' ', $self->proj->phrase( $h->{name} )->words );
            my $phl_type_found = $phl_type->search_subphrases_in_phrase( $self->proj->phrase( $source_text ), no_norm=>1 );
            if ( $phl_type_found && $phl_type_found->count ){
                $h->{type} = $phl_type_found->perl_array->[0];
                my $delete_from_name = join " ", @{$phl_type_found->perl_array};
                $h->{name} = ( $self->proj->phrase( $h->{name} ) ^ $self->proj->phrase( $delete_from_name ) )->text;
            }
        }
    }

    if ($h->{type}) {
        if ( $h_type_map{ $h->{type} } ) {
            $h->{type} = $h->{type} . ":". $h_type_map{ $h->{type} };
        }
        else {
            # очищаем тип и имя от дополнительного слова
            my $phl_type_found = $phl_type->search_subphrases_in_phrase( $self->proj->phrase( $h->{type} ), no_norm=>1 );
            if ( $phl_type_found && $phl_type_found->count ) {
                my @types = @{$phl_type_found->perl_array};
                my @res = ();
                for my $t (@types) {
                    push @res, $h_type_map{ $t } if ($h_type_map{ $t });
                }
                $h->{type} = join ":", @res, @types, $h->{type};
                my $delete_from_name = $h->{type};
                $delete_from_name =~ s/:/ /ig;
                $h->{name} = ( $self->proj->phrase( $h->{name} ) ^ $self->proj->phrase( $delete_from_name ) )->text;
            }
        }
    }

    if ($h->{type}) {
        my ($original_type, @types) = split /:/, $h->{type};
        push @types, 'отель', 'гостиница', 'hotel';
        $h->{type} = join ":", $original_type, uniq(@types);
        $h->{type} = "[".($h->{type})."]" if ($h->{type} =~ /:/);
    }

    # определяем country
    if ( !$h->{country} && $h->{location} ){

        my @aoh = $self->proj->phrase( $h->{location} )->get_regions;
        if ( @aoh ){
            my $hregion = $aoh[0];
            $h->{country} = $hregion->{is_world} ? $hregion->{name} : 'Россия';
        }
    }
    $h->{country} = '' if ( $h->{country} && $h->{country} eq 'Россия' );

    # удаляем type из name_title чтобы избежать ситуаций "Отель Отель Космос"
    if ($h->{type}) {
        my $main_type = '';
        if ($h->{type} =~ /\[(.*?)\:/) {
            $main_type = $1;
        } else {
            $main_type = $h->{type};
        }
        my $re = "^".($main_type);
        $h->{name_no_type} = $h->{name};
        # нашли type в начале name, удаляем его оттуда
        if ($h->{name} and $h->{name} =~ /$re/i) {
            $h->{name_no_type} =~ s/$re//i;
            $h->{name_no_type} =~ s/(^\s+|\s+$)//g;
        }
    }

    # проверяем и мультиплицируем class
    if ( $h->{class} && $h->{class} =~ /^(\d)/ ){
        $h->{class} = int($1);
        if (($h->{class} >= 1) and ($h->{class} <=5) ) {
            # если выпарсили другую цифру, это ошибка
            my @temp = ();
            push @temp, map { $h->{class}.$_ } ("*", " звезда");
            $h->{class} = "[".join(':',@temp)."]";
        }
        else {
            delete $h->{class};
        }
    }

    my $facility = $self->facilities || '';
    if ($facility) {
        my @fac = ();
        for my $f (split /[;,]\s*/, $facility) {
            next if ( $f =~ /трансфер|фильм|меню/i );
            next if ( scalar( my @temp = $f =~ /(\s+)/gi) >= 3 );
            push @fac, lc($f);
            if ($f =~ /(\(.*\))/) {
                $f =~ s/$1//;
                $f =~ s/\(\)//g;
                $f =~ s/(^\s+|\s+$)//g;
                push @fac, lc($f);
            }
        }
        push (@fac, 'wifi', 'wi-fi', 'wi fi', 'интернет')   if ($facility =~ /wi[-\s]?fi/i);
        push (@fac, 'парковка')                             if ($facility =~ /парковка/i);
        push (@fac, 'дети')                                 if ($facility =~ /((для)\s+)?дет(ей|ск)/i);
        push (@fac, 'животные', 'домашние животные')        if ($facility =~ /(допуск|разреш)[а-яёА-ЯЁ\s]/i);
        push (@fac, 'диетичечкое меню', 'диетическое питание')  if ($facility =~ /диетическ/i);
        push (@fac, 'инвалид', 'инвалид колясочник', 'колясочник')  if ($facility =~ /((ограниченн[а-я]+ (физическ[а-я]+ )?возможност)|инвалид|колясочник)/i);
        push (@fac, 'диетическое питание')  if ($facility =~ /диетическ/i);
        @fac = uniq @fac;
        $h->{facility} = "[".(join ":", @fac)."]";
    }

    delete $h->{Address} if ( $h->{Address} && $h->{Address} !~ /\d/ );
    for my $k (keys %$h) {
        delete $h->{$k} unless ($h->{$k});
    }
#    print STDERR Dumper($h);
    return $h;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $type = "type:_DEMULT";
    my $typec = "type:_DEMULT:_ADD_COMMA";
    my $name = "[name/name:_NO_ADDR]";
    my $namec = "[name:_ADD_COMMA/name:_NO_ADDR:_ADD_COMMA]";
    my $name_no_type = "[name_no_type/name_no_type:_NO_ADDR]";
    my $namec_no_type = "[name_no_type:_ADD_COMMA/name_no_type:_NO_ADDR:_ADD_COMMA]";
    my $locationc = "location:_ADD_COMMA";
    my $classc = "class:_DEMULT:_ADD_COMMA";
    my $res = "
        $type location {___MULT_PHRASE} => $type $namec_no_type location, $namec location, $typec location, $type $name_no_type, $name
        $type [name/name:_NO_ADDR] location {___MULT_PHRASE} => $type $namec_no_type location, $namec location, $type $name_no_type, $name
        [name/name:_NO_ADDR] location => $type $namec_no_type location, $namec location, $type $name_no_type, $name
        [name/name:_NO_ADDR] {___MAX_500} {___ADD_MINUS_IF_NEEDED} => $type $namec_no_type location, $namec location, $type $name_no_type, $name
        [name:_FILTER_LEN/name:_NO_ADDR:_FILTER_LEN] country => $type $namec_no_type $locationc country, $type $namec_no_type country, $namec country, $type $name_no_type, $name
        $type [name/name:_NO_ADDR] {___MULT_PHRASE} {___ADD_MINUS_IF_NEEDED} => $type $namec_no_type location, $type name_no_type, $namec location, name
        $type location class {___MULT_PHRASE} => $type $namec_no_type $classc location, $namec $classc location, $typec $classc location, $type $name_no_type, $name
        country location $type {___MULT_PHRASE} => $type $namec_no_type $locationc country, $type $namec_no_type country, $namec country, $type $name_no_type, $name
        $type facility country {___MULT_PHRASE} => $type $namec_no_type $locationc country, $type $namec_no_type country, $namec country, $type $name_no_type, $name
        $type facility location {___MULT_PHRASE} => $type $namec_no_type location, $namec location, $type $name_no_type, $name
    ";
    return $res;
}

sub perf_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $type = "[type/type:_DEL_ADJ]";
    my $name = "[name/name:_NO_ADDR]";

    my $title = "type:_DEMULT name_no_type {_MULTIDOT_END_NON_EMPTY}, name {_MULTIDOT_END_NON_EMPTY}";
    my $res = "
        [name:_ADD_HOTEL_WORD_IF_NEEDED/name:_ADD_HOTEL_WORD_IF_NEEDED:_NO_ADDR] {___MULT_PHRASE} {___MAX_500} {___ADD_MINUS_IF_NEEDED} => $title
        $name location {___ADD_MINUS_IF_NEEDED} => $title
        [name:_NO_ADDR] country {___ADD_MINUS_IF_NEEDED} => $title
        $type $name location {___MULT_PHRASE} {___ADD_MINUS_IF_NEEDED} => $title
        $type $name {___MULT_PHRASE} {___ADD_MINUS_IF_NEEDED} => $title
        $type class location {___MULT_PHRASE} {___MAX_3000} => $title
        $type location {___MULT_PHRASE} {___MAX_3000} => $title
        $type location country {___MULT_PHRASE} {___MAX_3000} => $title
        $type facility country {___MULT_PHRASE} => $title
        $type facility location {___MULT_PHRASE} => $title
    ";
    return $res;
}

sub banner_single_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $type = "[type/type:_DEL_ADJ]";
    my $name = "[name/name:_NO_ADDR]";

    my $title = "type:_DEMULT name_no_type {_MULTIDOT_END_NON_EMPTY}, name {_MULTIDOT_END_NON_EMPTY}";
    my $result = "
        $name => $title
        $type => $title
    ";
    return $result;
}


sub perf_banners_single {
    my ($self,  %params) = @_;

    # первый попавшийся баннер из сгенерившихся
    my ($arr) = $self->banners_data(
        templates_text => $self->banner_single_templates_text,
        methods_arr => [ 'pack_list', 'replace_strange_symbols_by_space' ],
        max_count => 1,
        title_template_type => 'single',
        assert_no_rpc => 1,
        %params,
    );

    $arr = $self->single_banner_default('perf', 'additional_methods' => ['replace_strange_symbols_by_space'], %params) unless @$arr;
    return @$arr ? [ $arr->[0] ] : [];
}

sub _ADD_COMMA {
    my ( $self, $txt ) = @_;
    return "$txt," if ($txt);
    return "";
}

sub _ADD_STAR {
    my ( $self, $txt ) = @_;
    return "$txt*" if ($txt);
    return "";
}

sub _NO_ADDR {
    my ( $self, $txt ) = @_;
    return '' unless $self->{Address};
    my $address = $self->{Address};
    return '' unless $address =~ /\d/;
    $address =~ s/\// /g;
    my $phl = $self->proj->phrase_list([$txt,$address])->intersection;
    my $shortname = ( $self->proj->phrase( $txt ) ^ $self->proj->phrase( 'на '.$address ) )->text;
    return '' unless $shortname;
    return $shortname if length( $shortname ) < length( $txt );
    return '';
}

sub _FILTER_LEN {
    my ( $self, $txt ) = @_;
    return '' unless scalar( split /\s+/, $txt ) >= 3;
    return $txt;
}

sub _MULT_TYPE {
    my ( $self, $txt ) = @_;
}

sub _ADD_HOTEL_WORD_IF_NEEDED {
    my ( $self, $txt ) = @_;
    return '' unless $txt;
    my $before = $txt;
    my @types = ('inn', 'inns', 'suite', 'suites', 'resort', ,'resorts', 'hostel', 'hostels', 'отель', 'guest house', 'гостиница', 'holiday house', 'plaza', 'hostal', 'motel', 'гостевой дом', 'guesthouse', 'санаторий', 'дом отдыха', 'bungalow', 'haus', 'beach house', 'hôtel', 'gasthaus');

    for my $t (@types) {
        my $type_re = '\b'.$t.'\b';
        if ($txt =~ /$type_re/i) {
            # в тексте нашлось слово, которое говорит о том, что это отель, ничего добавлять не надо
            return $txt;
        }
        return $txt if ($txt =~ /ap?part|residenc|апп?арт|hos?tel/i);
    }
    # в тексте нет слова, говорящего о том, что это отель, допишем это слово к name во фразах
    my $word_to_add = '';
    if ($txt =~ /[а-яА-ЯёЁ]/i) {
        $word_to_add = "отель";
    } else {
        $word_to_add = "hotel";
    }
    $txt .= " ".$word_to_add;
    return $txt;
}

sub ___ADD_MINUS_IF_NEEDED {
    my ( $self, $txt ) = @_;
    my @regs = $self->proj->phrase( $txt )->get_regions;
    return $txt unless @regs;
    my %htown = map { $_->{town} => 1  } @regs;
    return $txt unless %htown;
    return $txt if scalar( keys %htown ) != 1;
    return $txt if !$self->proj->phrase_list([$txt, (keys %htown)[0]])->intersection->count;
    return $txt if ( $self->location && $self->proj->phrase_list([$txt, $self->location])->intersection->count );
    return "$txt -!в";
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        replace_strange_symbols_by_space        hotel
        set_exclamations_before_stops_safe      hotel
        set_exclamations_before_bsstops         hotel
        get_wide_filtered                       hotel
        postfilter_hotel                        hotel
        get_search_filtered50k                  hotel
        pack_phr_lite                           hotel
        pack_list_safe                          hotel
        norm_phrase_list_safe                   hotel
        pack_list                               hotel
        move_minuswords_to_end                  hotel
        to_lc                                   hotel
        set_exclamations_before_stops_safe      hotel
        set_exclamations_before_bsstops         hotel
        replace_exclamations_with_pluses        hotel
    ';
    return @res;
}

1;
