package BM::BannersMaker::ProductPromocodes;

use strict;
use utf8;

use base qw(BM::BannersMaker::Product);
use utf8;
use Data::Dumper;
use List::Util qw(min);
use Utils::Sys qw(uniq);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    domain
    discount_type
    discount_amount
    merchant_logo
    merchant_name
    conditions
    description
));

my @offer_fields = qw{domain discount_type discount_amount merchant_logo merchant_name conditions description};

sub init {
    my ($self) = @_;
    $self->SUPER::init;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields;
    }
}

sub ad_type {
    return 'promocodes';
}

sub match_type {
    return 'norm';
}

sub parse :CACHE {
    my ($self) = @_;
    my $h = {};
    my $merchant = $self->{merchant_name} || '';
    $merchant = $1 if $merchant =~ /«(.*)»/;
    $merchant = $1 if $merchant =~ /(.*?)(\s+?|\s*?\.\s*?)(com|ru|рф|ру)$/i;
    $merchant = $1 if $merchant =~ /\.(.*)/; # only for current feed (can be wrong for another)

    my $get_variations = sub {
        my $word = shift;
        return () unless $word;

        my @results = ();
        push @results, $word;

        # get snorm
        my $snorm = $self->proj->phrase($word)->snorm_phr;
        push @results, $snorm if $snorm;

        my $types_line = "types:merchant_sim";
        # get phrases from dict_csyns: compoundwords, translit
        my $phl = $self->proj->phrase_list([$word])->context_syns_extend_custom($types_line);
        my @int_results = ();
        for my $phr ($phl->phrases) {
            $phl = $self->proj->phrase_list([$phr]);
            # get phrases from dict_csyns: compoundwords, translit (second level)
            $phl = $phl->context_syns_extend_custom($types_line);
            push @int_results, @{ $phl->perl_array };
        }

        # Exception - because ’
        if ($word =~ /л(’|')этуаль/i) {
            $phl = $self->proj->phrase_list([qw/летуаль/])->context_syns_extend_custom($types_line);
            push @int_results, @{ $phl->perl_array };
        }
        push @results, @int_results;

        # Remove 'спорт мастер' and other compoundwords
        @results = grep { $_ !~ /\s+/ } @results if ($word eq "sportmaster");

        my %addition_syns = (
            "mediamarkt" => "медиа маркт",
            "связной" => "svyaznoy",
        );
        $word = lc($word);
        push @results, $addition_syns{$word} if exists $addition_syns{$word};
        return @results;
    };
    #(Интернет-магазин детских товаров )Кораблик
    $merchant =~ s/.*?магазин.*?товаров\s+//i if $merchant;
    my @merchant_variations;
    @merchant_variations = (uniq $get_variations->($merchant)) if $merchant;
    @merchant_variations = grep { $_ !~ /(купить|эскиз|work|eskiz)/i } @merchant_variations;

    # add modellike_modifications
    my $get_modellike_ar_ref = sub {
        my $merchant_vars_ref = shift;
        my @res = ();
        for my $var (@{$merchant_vars_ref}) {
            my $phr = $self->proj->phrase($var);
            my $exp_phl = $phr->get_modellike_modifications_lite;
            push @res, @{ $exp_phl->perl_array };
        }
        return \@res;
    };

    my $modellike_ar_ref = $get_modellike_ar_ref->(\@merchant_variations);
    push @merchant_variations, @{ $modellike_ar_ref };
    @merchant_variations = grep { $_ } uniq @merchant_variations;

    $h->{merchant} = (join ":", @merchant_variations) if @merchant_variations;

    my $discount_type = $self->{discount_type} || '';
    my $discount_amount = $self->{discount_amount} || '';
    if ($discount_type and $discount_amount) {
        if ($discount_type eq 'text') {
            $h->{discount} = $discount_amount;
        } elsif ($discount_type eq 'fix') {
            $h->{discount} = "скидка ".$discount_amount." рублей";
        } elsif ($discount_type eq 'percent') {
            $h->{discount} = "скидка ".$discount_amount."%";
        }
    }

    my $domain = $self->{domain} || '';
    if ($domain) {
        $domain =~ s/^https?:\/\///i;
        $domain =~ s/^www\.//i;
        $domain =~ s/\/$//i;
        my $domain_short = $domain;
        $domain_short =~ s/\.[^\.]*?$//i;
        $h->{domain} = join ":", uniq(($domain, $domain_short));
    }

    $h->{promocode} = "[купон:купон скидка:купон +на скидка:скидочный купон:промо код:промокод:скидка:акция]";

    my @categs = ();

    my $minicategs_ref = $self->proj->phrase($self->description)->get_minicategs_subphrases_hash;
    my @minicategs;
    for my $key (keys %$minicategs_ref) {
        for my $key2 (keys %{ $minicategs_ref->{$key} }) {
            push @minicategs, lc($key2);
        }
    }
    @categs = @minicategs if (@minicategs);

    sub is_adj {
        my $word = shift;
        my $adj_re = "ий|ый|ой|вая|ная|мая|лая|кая|ые|ие|ое|ых|их";
        return 1 if $word =~ /($adj_re)$/;
        return 0;
    }

    my $description = $self->description || '';
    if ($description) {
        my @new_categories;
        if ($description =~ /скидка на (?<res>.*)/i) {
            my $res = $+{res};
            $res = $1 if $res =~ /(.*) при/;
            $res = $1 if $res =~ /(.*) в/;
            $res = $1 if $res =~ /(.*?) \b[a-z]+?\b/i;
            if (($res !~ /покупк/) and ($res !~ /(заказ|от)/) and ($res !~ /^все/)) {
                push @new_categories, $res;
                if ($res =~ /(?<categ1>.*) и (?<categ2>.*)/) {
                    pop @new_categories;
                    push @new_categories, ($+{categ1}, $+{categ2});
                }
            }
        } elsif ($description =~ /\b(интернет-магазин|магазин)\b (?<res>[^—–]*?)\./i) {
            my $res = $+{res};
            if (($res !~ /^\s*для/) and ($res !~ /\w+\sтовар/)) {
            push @new_categories, $res;
            if ($res =~ /,/) {
                my @parts = split(",", $res);
                if (($parts[0] !~ /товар/) and ($parts[-1] =~ /(?<categ1>.*) и (?<categ2>.*)/)) {
                    pop @parts;
                    push @parts, ($+{categ1}, $+{categ2});
                    if ($parts[-1] =~ /(?<last_good>товар.*)/) {
                        for my $idx (0..$#parts-1) {
                            $parts[$idx] .= " $+{last_good}" if is_adj($parts[$idx]);
                        }
                    }
                }
                pop @new_categories;
                push @new_categories, @parts;
            } elsif (($res =~ /(?<categ1>.*) и (?<categ2>.*)/) and ($res !~ /товар/)) {
                pop @new_categories;
                push @new_categories, ($+{categ1}, $+{categ2});
            }
            }
        }
        @new_categories = map { s/^\s+|\s+$//; lc($_) } @new_categories; ##no critic

        # Костыль - более (150 тысяч) товаров (цифровой) и (бытовой) (техники)
        if ($description =~ /более (.*?) товаров (\w+) и (\w+?) (\w+?)\./) {
            my $first_categ = "$2 $4";
            my $second_categ = "$3 $4";
            push @new_categories, ($first_categ, $second_categ);
        }
        # Костыль №2 - Л’Этуаль — (парфюмерия) и (косметика)
        if ($description =~ /(тренды в|Л’Этуаль —) (.*?) и (.*?)\./) {
            push @new_categories, ($2, $3);
        }
        push @categs, @new_categories;
    }
    my $minicateg = $self->minicategs || '';
    push @categs, (split "/", lc($minicateg));

    # Find goods with get_goods
    my $conds = $self->{conditions} || '';
    my $good = $conds =~ /\b(кроме|не)\b/ ? '' : $conds;
    $good = $good =~ /Скидка.*?на (.*?)[.,]/ ? $1 : '';

    my $descr = $self->{description} || '';
    my $good2 = $descr =~ /.*? — (.*?)\./ ? $1 : '';
    my @goods = $good2 eq '' ? () : split(',', $good2);
    push @goods, $good if $good;
    @goods = map { $self->proj->phrase($_)->get_goods } @goods;

    push @goods, @categs;

    @goods = uniq @goods;
    @goods = grep { defined $_ and ($_ ne '') and ($_ !~ /(универсальны|амуниция|растения|^аксессуар)/i) } @goods; # костыль
    $h->{good} = join(":", @goods);

    for my $k (keys %$h) {
        unless ($h->{$k}) {
            delete $h->{$k};
            next;
        }
        $h->{$k} =~ s/^://;
        $h->{$k} = "[".$h->{$k}."]" if ($h->{$k} =~ /:/ and $h->{$k} !~ /^\[/ and $h->{$k} !~ /\]$/);
    }
    #print STDERR " =====     Кирпичи:     ========\n";
    #print STDERR Dumper($h);
    #print STDERR "================================\n\n";
    return $h;
}

sub _ADD_PREPOSITION {
    my ($self, $txt) = @_;
    return '' unless $txt;
    return "в $txt";
}

sub _FIRST_WORD {
    my ($self, $txt) = @_;
    my @words = split /\s+/, $txt;
    return $words[0];
}

sub title_templ {
    my $merchant_title = "merchant:_DEMULT:_UP_FIRST:_ADD_PREPOSITION";
    my $domain_title = "domain:_DEMULT:_ADD_PREPOSITION";
    my $res = "discount:_DEMULT $merchant_title, discount:_DEMULT:_FIRST_WORD $merchant_title, promocode:_DEMULT $merchant_title, discount:_DEMULT $domain_title, discount:_DEMULT:_FIRST_WORD $domain_title, promocode:_DEMULT $domain_title";
    return $res;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title = $class->title_templ;
    my $res = "
        merchant good {___MULT_PHRASE} {___MAX_500} => $title
        merchant good promocode {___MULT_PHRASE} {___MAX_500} => $title
        domain good {___MULT_PHRASE} {___MAX_500} => $title
        domain good promocode {___MULT_PHRASE} {___MAX_500} => $title
        promocode good {___MULT_PHRASE} {___MAX_500} => $title
        promocode merchant {___MULT_PHRASE} {___MAX_500} => $title
        promocode domain {___MULT_PHRASE} {___MAX_500} => $title
        merchant {___MULT_PHRASE} => $title
        good {___MULT_PHRASE} => $title
    ";
    return $res;
}

sub perf_templates_text {
    return $_[0]->dyn_templates_text;
}

sub banner_single_templates_text {
    my $class = shift;
    my $title = $class->title_templ;
    my $res = "
        promocode => $title
        merchant => $title
        good => $title
    ";
    return $res;
}

sub perf_banners_single {
    my ($self,  %params) = @_;

    # первый попавшийся баннер из сгенерившихся
    my ($arr) = $self->banners_data(
        templates_text => $self->banner_single_templates_text,
        methods_arr => [ 'pack_list', 'replace_strange_symbols_by_space' ],
        max_count => 1,
        title_template_type => 'single',
        assert_no_rpc => 1,
        %params,  # ctx
    );

    $arr = $self->single_banner_default('perf', 'additional_methods' => ['replace_strange_symbols_by_space'], %params) unless @$arr;

    # кирпич "promocode" всегда определён
    unless ( @$arr ){
        $arr = $self->banners_data(
            methods_arr => [ 'pack_list', 'replace_strange_symbols_by_space' ],
            max_count => 1,
            templates_text => "promocode:_DEMULT => promocode:_DEMULT",
            assert_no_rpc => 1,
            title_template_type => 'fallback',
            %params
        );
    }

    return @$arr ? [ $arr->[0] ] : [];
}

sub dyn_methods_arr {
    my ($self) = @_;
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        replace_strange_symbols_by_space        hotel
        set_exclamations_before_stops_safe      hotel
        set_exclamations_before_bsstops         hotel
        get_wide_filtered                       hotel
        get_search_filtered50k                  hotel
        pack_phr_lite                           hotel
        pack_list_safe                          hotel
        norm_phrase_list_safe                   hotel
        pack_list                               hotel
        move_minuswords_to_end                  hotel
        replace_exclamations_with_pluses        hotel
    ';
    return @res;
}

1;
