package BM::BannersMaker::ProductSports;

use strict;
use utf8;

use base qw(BM::BannersMaker::ProductWear);
use Data::Dumper;
use List::Util qw(min);


########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    vendor
    model
    name
    sex
    color
    season
    collection
    age
    material
    vol
    add
    club
    qty
));


sub init {
    my ($self) = @_;    
    return $self->BM::BannersMaker::Product::init;
}

sub ad_type {
    return 'sports';
}

sub match_type {
    return 'norm';
}

sub parse :CACHE {
    my ($self) = @_;
    
    
    if ($self->{model}){
        if ( $self->vendor && $self->model ){
            my $temp = $self->model;
            $temp =~ s/^(.*)$/\l$1/ if $self->proj->phrase( $temp )->get_goods;
            $self->{model} = $self->vendor.' '.$temp;
        }
    }

    # проверка фидовых значений color, age. season, material
    $self->check_attr;
   
    my $h = $self->BM::BannersMaker::Product::parse;
    
    # спортивная добавка/ для чего товар
    my $phl_additions = $self->proj->phrase_list( ['волейбол', 'охота', 'для охоты', 'охотничий', 'рыбалка','для рыбалки','рыболовный', 'рыбацкий', 'фитнес', 'сноуборд', 'рыболовный', 'хоккейный', 'туристический', 'ходьба', 'футбольный', 'теннис', 'боксерский', 'горнолыжный', 'для сноуборд', 'домашний', 'уличный', 'страйкбольный', 'туризм', 'для футбола', 'для тенниса', 'хоккей', 'пейнтбол', 'теннисный', 'для бега', 'пейнтбольный', 'альпинистский', 'для гимнастики', 'для спортзала', 'пинг понг', 'футбол', 'аэробика', 'для страйкбола', 'баскетбол', 'плавательный', 'сноубординг', 'настольный теннис', 'велосипедист', 'для художественной гимнастики', 'дачный', 'для ловли', 'для аэробики', 'для альпинизма', 'борьба', 'для дома', 'профессиональный', 'запчасть', 'для туризма', 'для дачи', 'для похудения' ] );

    my $source_text = '';
    $source_text = join (' ', map { $_ || () } ( $self->model, $self->name, $self->proj->phrase( $self->description )->head(10), $self->categpath) );
    $source_text = join (' ', $self->proj->phrase( $source_text )->words );
   
   #Берем сильно больше 10 слов, для определения поля club.
    my $full_source_text = join (' ', map { $_ || () } ( $self->model, $self->name, $self->description, $self->categpath) );
    $full_source_text = join (' ', $self->proj->phrase( $full_source_text )->words );
    
    $h->{full} = $full_source_text; 
    my $phl_additions_found = $phl_additions->search_subphrases_in_phrase( $self->proj->phrase( $source_text ), safe_norm=>1 );
    $h->{add} = '';
    if ( $phl_additions_found && $phl_additions_found->count ){
        my @additions_found = @{$phl_additions_found->perl_array};
        my $addition = shift @additions_found ;
        my $phl_additions_text = join(' ', @{$phl_additions->perl_array} );
        $h->{add} = $self->proj->phrase( $phl_additions_text )->_denorm_text( $addition );
        $h->{add} = $1 if ( $phl_additions_text =~ /(для $h->{add})/ );
    }
    
    my @clubs = ('бавария', 'барселона', 'barcelona', 'реал', 'реал мадрид', 'real madrid', 'валенсия', 'атлетико', 
    'arsenal', 'атлетико мадрид', 'челси', 'бавария', 'бавария мюнхен', 'bayern', 'боруссия', 'боруссия дортмунд', 'динамо', 'интер', 'ливерпуль', 'локомотив', 'милан', 'спартак', 'манчестер', 'манчестер юнайтед', 'манчестер сити', 'мю',
    'ювентус', 'цска', 'кубань', 'рома', 'монако', 'наполи', 'manchester united', 'manchester city', 'сочи', 'динамо', 'цска', 'салават юлаев', 'Pittsburgh Penguins', 'Detroit Red Wings', 'Washington Capitals', 'Carolina Hurricanes', 'Columbus Blue Jackets', 'New Jersey Devils', 'New York Islanders', 'New York Rangers', 'Philadelphia Flyers', 'Buffalo Sabres', 'Boston Bruins', 'Canadiens Monreal', 'Ottawa Senators', 'Tampa Bay Lightning', 'Toronto Maple Leaf', 'Florida Panthers', 'Winnipeg Jets', 'Dallas Stars', 'Colorado Avalanche', 'Minnesota Wild', 'Nashville Predators', 'St. Louis Blues', 'Chicago Blackhawks', 'Anaheim Ducks', 'Arizona Coyotes', 'Vancouver Canucks', 'Calgary Flames', 'Los Angeles Kings', 'San Jose Sharks'
    );
    
    my $phl_clubs = $self->proj->phrase_list(\@clubs);
    my $phl_clubs_found = $phl_clubs->search_subphrases_in_phrase($self->proj->phrase( $full_source_text), only_norm=>1);

    $h->{club} = '';
    if ($phl_clubs_found && $phl_clubs_found->count) {
        my @clubs_found = @{$phl_clubs_found->perl_array};
        #берем первый найденный клуб
        $h->{club} = $clubs_found[0];
        #если не нашли слов фк или футбольный клуб, чтобы не ошибиться решаем, что это не клуб
        if ($full_source_text !~ /hc|хк|nhl|хоккейный клуб|fc|фк|футбольный клуб|футбольного клуба/) {
            $h->{club} = '';
        }
    }

    if ( $h->{brand} ){
        # если брэнд и магазин совпадают, обнуляем брэнд
        $h->{brand} = '' if ( $h->{shopname} && lc($h->{brand}) eq $h->{shopname} );
        # поднимаем первую букву
        $h->{brand} =~ s/^(.*)$/\u$1/ if $h->{brand};
    }
    
    if (exists $h->{sex}) {
        $h->{sex} = '' if $h->{sex} =~ /\,/;
    }
    
    if ( $self->description && !$h->{sex} ){
        my ( $sex ) = $self->proj->phrase($self->description)->cut_sex;
        $h->{sex} = $sex if ( $sex && $sex !~ /\:/ ); # не берем пол, если найдено несколько, чтобы не сгенерилось мужское платье
    }

    if ( $self->description && !$h->{color} ){
        my ( $colors ) = $self->proj->phrase($self->description)->cut_colors;
        $h->{color} = (split/\:/,$colors)[0] if $colors;
    }
    if ( $self->description && !$h->{season} ){
        $h->{season} = ($self->proj->phrase($self->description)->cut_season)[0];
    }
    if ( $self->description && !$h->{wear_prop} ){
        my $wear_prop = '';
        $wear_prop = ($self->proj->phrase($self->description)->cut_wear_property)[0];
        $h->{wear_prop} = $wear_prop if $wear_prop;
    }
    if ($h->{type} && $h->{wear_prop}) {
        my @wear_props = grep { $h->{type} !~ m/\b$_\b/} split /\:/, $h->{wear_prop};
        $h->{wear_prop} = join(':', @wear_props);
    }

    # удаляем все лишние символы
    $h->{$_}=~s/(^[^0-9a-zа-яё-]+|[^0-9a-zа-яё-]+$)//gi for ( grep { $h->{$_} } qw/add club color season age sex material/ );

    if ($h->{season} && $h->{season} =~ /[-\/ ]/ ){
        $h->{collection} =  lc $h->{season};
        $h->{season} = '';
    }
    my $simple_color = $self->get_simple_color($h->{color});

    # согласование словоформ для заголовков
    for my $text ( grep { $h->{$_} } qw/color season age sex/ ){
        $h->{$text} = $self->proj->phrase($h->{type})->harmonize($h->{$text});
    }
    $simple_color = $self->proj->phrase($h->{type})->harmonize($simple_color) if $simple_color;

    # вычитаем из типа лишнее    
    if ( $h->{type} && $h->{season} ){
        $h->{type} = ( $self->proj->phrase($h->{type}) ^ $self->proj->phrase($h->{season}) )->text;
    }
    if ( $h->{type} && $h->{sex} ){
        $h->{type} = ( $self->proj->phrase($h->{type}) ^ $self->proj->phrase($h->{sex}) )->text;
    }
    if ( $h->{type} && $h->{age} ){
        $h->{type} = ( $self->proj->phrase($h->{type}) ^ $self->proj->phrase($h->{age}) )->text;
    }
    if ( $h->{type} ){
        $h->{type} =~ s/^(.)/\l$1/;
    }

    # мапим цвет на латинице, только если есть тип
    # зануляем цвет, если он входит в часть после "c|со" (поло с синими вставками)
    if ( $h->{color} && $h->{type} ){
        $h->{color} = '' if ( $h->{brand} && ($self->proj->phrase( $h->{brand} )->cut_colors)[0] );
        $h->{color} = $BM::BannersMaker::ProductWear::h_colors_map{lc($h->{color})} if $BM::BannersMaker::ProductWear::h_colors_map{lc($h->{color})};
        # ищем плохую фразу, когда тип перед "с|со", а цвет после
        for my $text ( grep { $_ && /\S/ } ( $self->model, $self->name, $self->description ) ){
            my ( $before_c, $after_c ) = split/\s+(?:с|со)\s+/, $text;
            next unless defined( $after_c );
            next unless (       $self->proj->phrase_list( [$before_c, $h->{type}] )->intersection(norm=>1)->count
                            &&  $self->proj->phrase_list( [$after_c, $h->{color}] )->intersection(norm=>1)->count );
            $h->{color} = '';
        }
    }

    # взрослый и так по умолчанию, он не нужен
    # если стоит 18, убираем
    if ( $h->{age} ){
        $h->{age} = '' if $h->{age} =~ /взросл/i;
        $h->{age} = '' if $h->{age} =~ /18/;
    }

    if (exists $h->{age} && $h->{age} ne '') {
        $h->{sex} = '';
    }

    # зануляем shopname, если он совпадает с брэндом
    if ( $h->{shopname} && $h->{brand} ){
        my $brand_reg = quotemeta $h->{brand};
        my $shopname_reg = quotemeta $h->{shopname};
        $h->{shopname} = '' if ( $h->{brand} =~ /$shopname_reg/i || $h->{shopname} =~ /$brand_reg/i );
    }

    $h->{$_}=lc($h->{$_}) for ( grep { $h->{$_} } qw/season age collection color sex wear_prop/ );

    if ($h->{color} and $simple_color and $h->{color} ne $simple_color) {
        $h->{color} = '[' . $h->{color} . ':' . $simple_color . ']';
    } 

    if ($h->{club} && $h->{brand} eq '') {
        $h->{brand} = $h->{club};
        $h->{add} = '';
    }

    if (exists $h->{type} and exists $h->{material} and $h->{type} eq $h->{material}) {
        $h->{material} = '';
    }

    if ($h->{vol}) {
        $h->{vol} .= ":$1 $2" if ($h->{vol} =~ /^(\d+)([^\d]+)$/);
        $h->{vol} = "[".$h->{vol}."]";
    }

    if (exists $h->{sex} && $h->{sex} =~ /нисекс/) {
        $h->{sex} = '';
    }

    return $h unless (exists $h->{age});


    my @kids = split ':', $h->{age};

    for (@kids) {
        if ($_ =~ /^для /) {
            my $kid = $_;
            $kid =~ s/^для //;
            $_ = 'для '.$self->proj->phrase($kid)->set_gender_number_case({case => 'gen'});
        }
    }
    $h->{age} = $kids[0] if ((scalar @kids) == 1);
    $h->{age} = '['.join(':', @kids).']' if ($h->{age} and ((scalar @kids) > 1));
    for my $k (keys %$h) {
        delete($h->{$k}) if (!defined($h->{$k}) || ($h->{$k} eq ''));
    }
    return $h;
}


my $MDL = 'model/model:_SHORT_MDL/model:_MDL_FIRSTWORD';
my $MDLD = 'model:_DOT_END/model:_SHORT_MDL:_DOT_END';
my $MDLF = 'model_for/model_for:_SHORT_MDL';

my $TYPE = "type/type:_DEL_ADJ/type:_MAINWORDS";

sub title_templ :GLOBALCACHE {
    my $res = join (", ",
        "age:_DEMULT:_NOFOR [type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL]",
        "[type/type:_DEL_ADJ/type:_MAINWORDS] age:_DEMULT:_FOR brand [model/model:_SHORT_MDL]",
        "age:_DEMULT:_NOFOR [type/type:_DEL_ADJ/type:_MAINWORDS] brand",
        "[type/type:_DEL_ADJ/type:_MAINWORDS] age:_DEMULT:_FOR brand",
        "age:_DEMULT:_NOFOR [type/type:_DEL_ADJ] [model/model:_SHORT_MDL]",
        "[type/type:_DEL_ADJ] age:_DEMULT:_FOR [model/model:_SHORT_MDL]",
        "age:_DEMULT:_NOFOR brand [model/model:_SHORT_MDL]",
        "brand age:_DEMULT:_FOR [model/model:_SHORT_MDL]",
        "age:_DEMULT:_NOFOR brand",
        "brand age:_DEMULT:_FOR",
        "sex [type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL]",
        "sex [type/type:_DEL_ADJ/type:_MAINWORDS] brand",
        "sex [type/type:_DEL_ADJ] [model/model:_SHORT_MDL]",
        "sex brand [model/model:_SHORT_MDL]",
        "sex brand",
        "[type/type:_DEL_ADJ/type:_MAINWORDS] brand [model/model:_SHORT_MDL]",
        "[type/type:_DEL_ADJ/type:_MAINWORDS] brand",
        "[type/type:_DEL_ADJ] [model/model:_SHORT_MDL]",
        "brand [model/model:_SHORT_MDL]",
        "sex [type/type:_DEL_ADJ/type:_MAINWORDS]",
        "[type/type:_DEL_ADJ/type:_MAINWORDS]",
        "type:_MULTIDOT_END");
    return $res;                                                                                                 
}    

#В отличие от базового класса используются только аксессуарные фразы
sub title_templ_acc {
    my $res = join ' ', map { s/^\s+//; $_ } grep { /\S/ } ##no critic
            split /\n/, "
                        brand [$MDLD] [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] brand_for [$MDLF],
                        brand [$MDLD] [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] [$MDLF],
                        [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] [$MDLF],
                        brand [$MDL] [model_for:_FOR/model_for:_SHORT_MDL:_FOR],
                        type_for:_MAINWORDS brand [$MDL],
                        type_for:_MAINWORDS [$MDL],
                        [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] brand [$MDL],
                        brand [$MDL],
                        [model/model:_SHORT_MDL/model:_MULTIDOT_END],
                        brand [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] brand_for,
                        [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] brand_for,
                        [type_for:_UP_FIRST/type_for:_UP_FIRST:_DEL_ADJ/type_for:_UP_FIRST:_MAINWORDS_FOR] brand,

    ";
    return $res;
}

sub dyn_templates_text :STATIC :GLOBALCACHE {
    my $class = shift;
    my $title_templ = $class->title_templ;
    my $title_templ_acc = $class->title_templ_acc;

    my $res = "
        brand [$TYPE] => $title_templ
        brand model => $title_templ
        age {___MULT_PHRASE}  [$TYPE]  => $title_templ
        brand model  [$TYPE]  => $title_templ
        model  [$TYPE]  => $title_templ
        add season  [$TYPE]  => $title_templ
        add brand [$TYPE]  => $title_templ
        add age {___MULT_PHRASE} [$TYPE]  => $title_templ
        season [$TYPE]  => $title_templ
         [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        shopname  [$TYPE]  => $title_templ
        sex  [$TYPE]  => $title_templ
        club  [$TYPE]  => $title_templ
        add sex  [$TYPE]  => $title_templ
        brand  [$TYPE]  vol {___MULT_PHRASE}  => $title_templ
        add brand model  [$TYPE]  => $title_templ
        add shopname  [$TYPE]  => $title_templ
        model shopname => $title_templ
        age {___MULT_PHRASE}  brand  [$TYPE]  => $title_templ
        brand material  [$TYPE]  => $title_templ
        add model  [$TYPE]  => $title_templ
        age {___MULT_PHRASE}  [$TYPE]  vol {___MULT_PHRASE}  => $title_templ
        add material  [$TYPE]  => $title_templ
        add club  [$TYPE]  => $title_templ
        brand season  [$TYPE]  => $title_templ
        brand club  [$TYPE]  => $title_templ
        brand  [$TYPE]  year => $title_templ
        material  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        club  [$TYPE]  year => $title_templ
        brand color model => $title_templ
        add  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand sex  [$TYPE]  => $title_templ
        brand material  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand model_weak => $title_templ
        add brand season  [$TYPE]  => $title_templ
        age {___MULT_PHRASE} club  [$TYPE]  => $title_templ
        add age {___MULT_PHRASE} brand  [$TYPE]  => $title_templ
        brand color  [$TYPE]  => $title_templ
        add age {___MULT_PHRASE} club  [$TYPE]  => $title_templ
         [$TYPE]  wear_prop => $title_templ
        brand model  [$TYPE]  year => $title_templ
        age {___MULT_PHRASE} model  [$TYPE]  => $title_templ
        model  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand model_weak  [$TYPE]  => $title_templ
        club model  [$TYPE]  => $title_templ
        age {___MULT_PHRASE} shopname  [$TYPE]  => $title_templ
        brand color model  [$TYPE]  => $title_templ
        age {___MULT_PHRASE} material  [$TYPE]  => $title_templ
        brand model  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        material shopname  [$TYPE]  => $title_templ
        age {___MULT_PHRASE}  brand model  [$TYPE]  => $title_templ
        add season sex  [$TYPE]  => $title_templ
        brand model vol {___MULT_PHRASE} => $title_templ
        brand model season  [$TYPE]  => $title_templ
        model vol {___MULT_PHRASE} => $title_templ
        color model  [$TYPE]  => $title_templ
        color  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        season  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand shopname => $title_templ
        add brand sex  [$TYPE]  => $title_templ
        add age {___MULT_PHRASE}  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand model sex => $title_templ
        model  [$TYPE]  year => $title_templ
        material model  [$TYPE]   => $title_templ
        color material  [$TYPE]   => $title_templ
        color material  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        add brand club  [$TYPE]  => $title_templ
        club model => $title_templ
        brand model sex  [$TYPE]  => $title_templ
        brand sex => $title_templ
        brand material => $title_templ
        add club  [$TYPE]  year => $title_templ
        season sex  [$TYPE]  => $title_templ
        age {___MULT_PHRASE}  season  [$TYPE]  => $title_templ
        add age {___MULT_PHRASE}  brand => $title_templ
        material season  [$TYPE]  => $title_templ
        brand club  [$TYPE]  year => $title_templ
        model_weak  [$TYPE]  => $title_templ
        brand material model  [$TYPE]  => $title_templ
        brand shopname [$TYPE]  => $title_templ
        material sex [$TYPE]  => $title_templ
        model season [$TYPE]  => $title_templ
        add age {___MULT_PHRASE}  material [$TYPE]  => $title_templ
        brand material model => $title_templ
        age {___MULT_PHRASE}  brand model => $title_templ
        add season [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        add brand model sex [$TYPE]  => $title_templ
        model sex => $title_templ
        model season => $title_templ
        sex type wear_prop => $title_templ
        color sex [$TYPE]  => $title_templ
        brand color model year => $title_templ
        add age {___MULT_PHRASE}  brand club [$TYPE]  => $title_templ
        add material sex [$TYPE]  =>$title_templ
        color season [$TYPE]  => $title_templ
        brand season => $title_templ
        age {___MULT_PHRASE}  [$TYPE]  year =>$title_templ
        age {___MULT_PHRASE} brand club [$TYPE]  => $title_templ
        add material season [$TYPE]  => $title_templ
        brand model season => $title_templ
        age {___MULT_PHRASE} brand [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand model sex [$TYPE]  year => $title_templ
        add color model [$TYPE]  => $title_templ
        add club model [$TYPE]  => $title_templ
        material model => $title_templ
        add sex [$TYPE]  wear_prop => $title_templ
        add [$TYPE]  wear_prop => $title_templ
        model sex [$TYPE]  => $title_templ
        add sex shopname [$TYPE]  => $title_templ
        add model season [$TYPE]  => $title_templ
        sex [$TYPE]  year => $title_templ
        material model [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        add age {___MULT_PHRASE} brand model [$TYPE]  => $title_templ
        sex shopname [$TYPE]  => $title_templ
        brand sex [$TYPE]  year => $title_templ
        brand color [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        add brand color [$TYPE]  => $title_templ
        add age {___MULT_PHRASE} season [$TYPE]  => $title_templ
        brand color material [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        age {___MULT_PHRASE}  club [$TYPE]  year => $title_templ
        age {___MULT_PHRASE} [$TYPE]  wear_prop => $title_templ
        add brand model season [$TYPE]  => $title_templ
        brand model sex year => $title_templ
        add model_weak [$TYPE]  => $title_templ
        add age {___MULT_PHRASE}  model [$TYPE]  => $title_templ
        brand color material [$TYPE]  => $title_templ
        club model [$TYPE]  year => $title_templ
        club sex [$TYPE]  => $title_templ
        material season [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        brand model season sex [$TYPE]  => $title_templ
        money [$TYPE]  => $title_templ
        brand color model season [$TYPE]  => $title_templ
        brand color model sex => $title_templ
        brand season  [$TYPE]  vol {___MULT_PHRASE} => $title_templ
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand brand_for model_for => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand brand_for model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model brand_for model_for => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model model_for => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand model_for => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand_for model_for => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand_for model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model_for model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] model_for => $title_templ_acc
        brand brand_for model_for => $title_templ_acc
        brand brand_for model => $title_templ_acc
        model brand_for model_for => $title_templ_acc
        brand model model_for => $title_templ_acc
        brand_for model => $title_templ_acc
        model_for model => $title_templ_acc
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] brand {___MAX_3000} => $title_templ_acc
    ";
    my @resarr = ();
    for my $line ( map { s/(^\s+|\s+$)//g; $_ || () } split( /\n/, $res) ){ ##no critic
        my ($phrase, $title) = split /\s*=>\s*/, $line;
        # к цетам добавляем мультипликаторо для упрощения оттенков
        if ($phrase =~ /(^|\s+)color(\s+|$)/) {
            $phrase .= "{___MULT_PHRASE} " if $phrase !~ /{___MULT_PHRASE}/;
        }
        # в заголовках мультипликатор удаляем
        if ($title =~ /(^|\s+)color(\s+|$)/) {
            $title =~ s/(^|\s+)color(\s+|$)/$1color:_DEMULT$2/g;
        }
        $line = join(' => ', $phrase, $title);
        push @resarr, $line;
    }
    $res = join ("\n", @resarr );

    return $res;
}

sub banner_single_templates_text {
    my $class = shift;
    my $title_templ = $class->title_templ;
    my $title_templ_acc = $class->title_templ_acc;

    my $result = "
        [$TYPE] => $title_templ
        brand => $title_templ
        model => $title_templ
        [type_for/type_for:_DEL_ADJ/type_for:_MAINWORDS] => $title_templ_acc
        model => $title_templ_acc
        model_for => $title_templ_acc
        brand => $title_templ_acc
        brand_for => $title_templ_acc
    ";
    return $result;
}

sub _CHECK_MDL {
    my ( $self, $txt ) = @_;
    return '' unless ( $txt =~ / / && length($txt)>4 );
    return $txt;
}

sub _SHORT_MDL {
    my ( $self, $txt ) = @_;
    my @words = grep{$_} split /\s+/, $txt;
    return join(" ", @words[0..min(1, $#words)]);
}

sub _MDL_FIRSTWORD {
    my ( $self, $txt ) = @_;
    my @words = grep{$_} split /\s+/, $txt;
    return '' unless @words;
    return $words[0] if length($words[0])>4;
    return '';
}

sub _SEASON {
    my ( $self, $txt ) = @_;
    if ( $txt =~ /(?:^|\s)([а-яё]+[\/-][а-яё]+)(?:\s|$)/i ){
        return $1 unless (lc($1) eq lc($txt));
    }
    return '';
}

sub _SECONDW {
    my ( $self, $txt ) = @_;
    my $season = $self->_SEASON($txt);
    return '' unless $season;
    return (split/ /, $season)[1];
}

sub _NOFOR {
    my ($self, $txt) = @_;
    return '' if (lc$txt =~ /^для /);
    return $txt;
}

sub _FOR {
    my ($self, $txt) = @_;
    return '' if (lc$txt !~ /^для/);
    return $txt;
}

sub _3WORDS {
    my ( $self, $txt ) = @_;
    my $season = $self->_SEASON($txt);
    return '' unless $season;
    $season =~ s/[\/-]/ /g;
    return '' unless $season =~ / {2,}/;
    return $self->proj->phrase($season)->head(3);
}

sub _ADD_COMMA {
    my ( $self, $txt ) = @_;
    return "$txt," if ($txt);
    return "";
}

sub dyn_methods_arr :GLOBALCACHE {
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        add_dynamic_homonymy_words              goods accessory P
        modellike_product                       goods accessory P
        get_wide_filtered                       goods accessory
        add_trade_phrases_dynamic_wear          goods accessory S
        get_search_filtered50k                  goods accessory
        pack_phr                                goods accessory
        spec_pack_list                          goods accessory
        get_search_filtered                     goods accessory
        set_exclamations_before_stops           goods accessory
        set_exclamations_before_bsstops         goods accessory
        replace_exclamations_with_pluses        goods accessory
    ';
    return @res;
}

sub banner_single_methods_arr {
    my $self = shift;
    return (
        'pack_phr goods accessory',
        'pack_list goods accessory',
    );
}

sub perf_templates_text {
    my $self = shift;
    return $self->dyn_templates_text;
}
sub perf_methods_arr {
    my $self = shift;
    return $self->dyn_methods_arr;
}

1;
