package BM::BannersMaker::ProductTravel;
use utf8;
use strict;
use base qw(BM::BannersMaker::Product);
use Data::Dumper;

my @offer_fields = qw{url picture price currencyId title origin destination offerfilters
                     images additional_data bad_flags
                     custom_phrases merge_key oldprice};

our $dict_city_name_ru2en;
our $dict_city_name_en2ru;

sub init {
    my ($self) = @_;
    my $data = $self->{data};
    if(ref($data->[0]) eq 'HASH'){
        $self->{$_} = $data->[0]{$_} for @offer_fields, $self->get_common_offer_fields;
    }
    $self->class_init(proj => $self->proj);
}

sub class_init :RUN_ONCE {
    my $class = shift;
    my %par = @_;
    my $proj = $par{proj};

    # грузим словарь названий городов на русском и английском
    $dict_city_name_ru2en = {};
    $dict_city_name_en2ru = {};
    for my $line ($proj->file($proj->options->{dicts}.'dict_city_names_ru_en')->lines) {
        chomp $line;
        my ($rus, $eng) = map { lc $_ } split("\t", $line);
        $dict_city_name_ru2en->{$rus} = $eng;
        $dict_city_name_en2ru->{$eng} = $rus;
    }
}


sub ad_type {
    return 'travel';
}

sub match_type {
    return 'norm';
}

sub parse :CACHE {
	my ($self) = @_;
	my $h = {};
    $h->{$_} = $self->{$_} for @offer_fields;
    $h->{add_words} = '[ЖД:Поезд:Автобус:Тур:Туроператор:Турагентство:Билеты:Авиабилеты:Самолет:Рейс:Авиарейс:Перелет:Трансфер:Путешествие:Полететь:Полет:Авиакомпания:Авиа:Слетать:Расписание:Прямой:Аэрофлот:Лететь]';
    $h->{name} = $h->{origin} . ' - ' . $h->{destination} if ($h->{origin} && $h->{destination});
    # если нет Destination name, пытаемся взять его из title
    if (!$h->{destination} && $h->{origin} && $h->{title}) {
        my $destination = ($self->proj->phrase($h->{title})->cut_regions)[1];
        my $origin = ($self->proj->phrase($h->{origin})->cut_regions)[1];
        my @destination = grep {$_ ne $origin} split /:/, $destination;
        $h->{destination} = $destination[0];
        $h->{name} = $h->{title}
    }
    # https://st.yandex-team.ru/DYNSMART-31, города на русском и английском
    if ($h->{origin} && $h->{destination}) {
        $h->{location} = (lc $h->{origin}) . ' ' . (lc $h->{destination});
        if ($h->{origin} =~ m/a-z/i) {
            if ($dict_city_name_en2ru->{lc $h->{origin}} && $dict_city_name_en2ru->{lc $h->{destination}}) {
                $h->{destination_2} = $dict_city_name_en2ru->{lc $h->{destination}};
                $h->{location_2} = $dict_city_name_en2ru->{lc $h->{origin}} .' '. $h->{destination_2};
            }
        } else {
            if ($dict_city_name_ru2en->{lc $h->{origin}} && $dict_city_name_ru2en->{lc $h->{destination}}) {
                $h->{destination_2} = $dict_city_name_ru2en->{lc $h->{destination}};
                $h->{location_2} = $dict_city_name_ru2en->{lc $h->{origin}} .' '. $h->{destination_2};
            }
        }
    }
    return $h;
}


sub dyn_templates_text :GLOBALCACHE {
	return "
		[location/location_2] {___MULT_PHRASE} {_SAVE_ORDER} {_LC} => name:_MULTIDOT_END_NON_EMPTY_56
		add_words [location/location_2] {___MULT_PHRASE} {_SAVE_ORDER_1} {_LC} => name:_MULTIDOT_END_NON_EMPTY_56
		add_words <+в> [destination/destination2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} => destination <. Билеты>,  destination
		add_words <+до> [destination/destination2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} =>  destination <. Билеты>, destination
	";
}

sub perf_templates_text :GLOBALCACHE {
	return "
		[location/location_2] {___MULT_PHRASE} {_SAVE_ORDER} {_LC} => name:_MULTIDOT_END_NON_EMPTY
		add_words [location/location_2] {___MULT_PHRASE} {_SAVE_ORDER_1} {_LC} => name:_MULTIDOT_END_NON_EMPTY
		add_words <+в> [destination/destination2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} => destination <. Билеты>,  destination
		add_words <+до> [destination/destination2] {_IF_ORIGIN_EMPTY} {___MULT_PHRASE} {_LC} =>  destination <. Билеты>, destination
	";
}

sub dyn_methods_arr :GLOBALCACHE {
    my ($self) = @_;
    my @res = map { s/^\s+//; $_ } grep {/\S/} grep {!/#/} ##no critic
        split /\n/, '
        get_search_filtered50k                  flights
        set_exclamations_before_stops_safe      flights
        set_exclamations_before_bsstops         flights
        add_minus_words_travel                  travel
        replace_exclamations_with_pluses        flights
    ';
    return @res;
}

sub perf_banners_single {
    my ($self, %params) = @_;

    # первый попавшийся баннер из сгенерившихся
    my ($arr) = $self->banners_data(
        templates_text => $self->perf_templates_text,
        methods_arr => [ 'pack_list', ],
        max_count => 1,
        title_template_type => 'single',
        assert_no_rpc => 1,
        %params,  # ctx
    );

    $arr = $self->single_banner_default('perf', %params) unless @$arr;

    return @$arr ? [ $arr->[0] ] : [];
}

sub _MULTIDOT_END_NON_EMPTY_56 {
    my ( $self, $txt ) = @_;
    return substr($txt, 0, 52) . '...' if ( length ($txt)>56 );
    return $txt;
}

1;
